/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.federation.policy;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.ParseException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.JSONObjectUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.federation.policy.MetadataPolicyEntry;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.federation.policy.language.PolicyOperation;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.federation.policy.language.PolicyViolationException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.federation.policy.operations.PolicyOperationCombinationValidator;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.federation.policy.operations.PolicyOperationFactory;
import macromedia.jdbc.sqlserver.externals.net.minidev.json.JSONAware;
import macromedia.jdbc.sqlserver.externals.net.minidev.json.JSONObject;

public class MetadataPolicy
implements JSONAware {
    private final Map<String, List<PolicyOperation>> entries = new LinkedHashMap<String, List<PolicyOperation>>();

    public JSONObject apply(JSONObject jSONObject) throws PolicyViolationException {
        if (jSONObject == null) {
            return null;
        }
        JSONObject jSONObject2 = new JSONObject();
        for (String string : jSONObject.keySet()) {
            if (this.entries.containsKey(string)) continue;
            jSONObject2.put(string, jSONObject.get(string));
        }
        for (String string : this.entries.keySet()) {
            Object v2 = jSONObject.get(string);
            MetadataPolicyEntry metadataPolicyEntry = this.getEntry(string);
            Object object = metadataPolicyEntry.apply(v2);
            if (object == null) continue;
            jSONObject2.put(string, object);
        }
        return jSONObject2;
    }

    public void put(String string, PolicyOperation policyOperation) {
        this.put(new MetadataPolicyEntry(string, Collections.singletonList(policyOperation)));
    }

    public void put(String string, List<PolicyOperation> list) {
        this.put(new MetadataPolicyEntry(string, list));
    }

    public void put(MetadataPolicyEntry metadataPolicyEntry) {
        this.entries.put(metadataPolicyEntry.getKey(), (List<PolicyOperation>)metadataPolicyEntry.getValue());
    }

    public List<PolicyOperation> get(String string) {
        return this.entries.get(string);
    }

    public MetadataPolicyEntry getEntry(String string) {
        List<PolicyOperation> list = this.entries.get(string);
        if (list == null) {
            return null;
        }
        return new MetadataPolicyEntry(string, list);
    }

    public Set<MetadataPolicyEntry> entrySet() {
        LinkedHashSet<MetadataPolicyEntry> linkedHashSet = new LinkedHashSet<MetadataPolicyEntry>();
        for (Map.Entry<String, List<PolicyOperation>> entry : this.entries.entrySet()) {
            linkedHashSet.add(new MetadataPolicyEntry(entry.getKey(), entry.getValue()));
        }
        return linkedHashSet;
    }

    public List<PolicyOperation> remove(String string) {
        return this.entries.remove(string);
    }

    public JSONObject toJSONObject() {
        JSONObject jSONObject = new JSONObject();
        for (MetadataPolicyEntry metadataPolicyEntry : this.entrySet()) {
            JSONObject jSONObject2 = metadataPolicyEntry.toJSONObject();
            if (jSONObject2 == null) continue;
            jSONObject.put(metadataPolicyEntry.getKey(), metadataPolicyEntry.toJSONObject());
        }
        return jSONObject;
    }

    @Override
    public String toJSONString() {
        return this.toJSONObject().toJSONString();
    }

    public String toString() {
        return this.toJSONString();
    }

    public static MetadataPolicy combine(List<MetadataPolicy> list) throws PolicyViolationException {
        return MetadataPolicy.combine(list, MetadataPolicyEntry.DEFAULT_POLICY_COMBINATION_VALIDATOR);
    }

    public static MetadataPolicy combine(List<MetadataPolicy> list, PolicyOperationCombinationValidator policyOperationCombinationValidator) throws PolicyViolationException {
        MetadataPolicy metadataPolicy = new MetadataPolicy();
        for (MetadataPolicy metadataPolicy2 : list) {
            for (MetadataPolicyEntry metadataPolicyEntry : metadataPolicy2.entrySet()) {
                MetadataPolicyEntry metadataPolicyEntry2 = metadataPolicy.getEntry(metadataPolicyEntry.getParameterName());
                if (metadataPolicyEntry2 == null) {
                    metadataPolicy.put(metadataPolicyEntry);
                    continue;
                }
                metadataPolicy.put(metadataPolicyEntry2.combine(metadataPolicyEntry, policyOperationCombinationValidator));
            }
        }
        return metadataPolicy;
    }

    public static MetadataPolicy parse(JSONObject jSONObject) throws ParseException, PolicyViolationException {
        return MetadataPolicy.parse(jSONObject, MetadataPolicyEntry.DEFAULT_POLICY_OPERATION_FACTORY, MetadataPolicyEntry.DEFAULT_POLICY_COMBINATION_VALIDATOR);
    }

    public static MetadataPolicy parse(JSONObject jSONObject, PolicyOperationFactory policyOperationFactory, PolicyOperationCombinationValidator policyOperationCombinationValidator) throws ParseException, PolicyViolationException {
        MetadataPolicy metadataPolicy = new MetadataPolicy();
        for (String string : jSONObject.keySet()) {
            JSONObject jSONObject2 = JSONObjectUtils.getJSONObject(jSONObject, string);
            metadataPolicy.put(MetadataPolicyEntry.parse(string, jSONObject2, policyOperationFactory, policyOperationCombinationValidator));
        }
        return metadataPolicy;
    }

    public static MetadataPolicy parse(String string) throws ParseException, PolicyViolationException {
        return MetadataPolicy.parse(string, MetadataPolicyEntry.DEFAULT_POLICY_OPERATION_FACTORY, MetadataPolicyEntry.DEFAULT_POLICY_COMBINATION_VALIDATOR);
    }

    public static MetadataPolicy parse(String string, PolicyOperationFactory policyOperationFactory, PolicyOperationCombinationValidator policyOperationCombinationValidator) throws ParseException, PolicyViolationException {
        return MetadataPolicy.parse(JSONObjectUtils.parse(string), policyOperationFactory, policyOperationCombinationValidator);
    }
}

