/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.federation.entities;

import java.net.URI;
import java.util.LinkedList;
import java.util.List;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jwt.SignedJWT;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.ParseException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.CollectionUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.JSONArrayUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.JSONObjectUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.federation.entities.EntityID;
import macromedia.jdbc.sqlserver.externals.net.minidev.json.JSONArray;
import macromedia.jdbc.sqlserver.externals.net.minidev.json.JSONAware;
import macromedia.jdbc.sqlserver.externals.net.minidev.json.JSONObject;

public class FederationEntityMetadata
implements JSONAware {
    private final URI federationAPIEndpoint;
    private EntityID trustAnchorID;
    private String name;
    private List<String> contacts;
    private URI policyURI;
    private URI homepageURI;
    private List<SignedJWT> trustMarks;

    public FederationEntityMetadata(URI uRI) {
        this.federationAPIEndpoint = uRI;
    }

    public URI getFederationAPIEndpointURI() {
        return this.federationAPIEndpoint;
    }

    public EntityID getTrustAnchorID() {
        return this.trustAnchorID;
    }

    public void setTrustAnchorID(EntityID entityID) {
        this.trustAnchorID = entityID;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public List<String> getContacts() {
        return this.contacts;
    }

    public void setContacts(List<String> list) {
        this.contacts = list;
    }

    public URI getPolicyURI() {
        return this.policyURI;
    }

    public void setPolicyURI(URI uRI) {
        this.policyURI = uRI;
    }

    public URI getHomepageURI() {
        return this.homepageURI;
    }

    public void setHomepageURI(URI uRI) {
        this.homepageURI = uRI;
    }

    public List<SignedJWT> getTrustMarks() {
        return this.trustMarks;
    }

    public void setTrustMarks(List<SignedJWT> list) {
        this.trustMarks = list;
    }

    public JSONObject toJSONObject() {
        JSONObject jSONObject = new JSONObject();
        if (this.getFederationAPIEndpointURI() != null) {
            jSONObject.put("federation_api_endpoint", this.getFederationAPIEndpointURI().toString());
        }
        if (this.getTrustAnchorID() != null) {
            jSONObject.put("trust_anchor_id", this.getTrustAnchorID().getValue());
        }
        if (this.getName() != null) {
            jSONObject.put("name", this.getName());
        }
        if (this.getContacts() != null) {
            jSONObject.put("contacts", this.getContacts());
        }
        if (this.getPolicyURI() != null) {
            jSONObject.put("policy_uri", this.getPolicyURI().toString());
        }
        if (this.getHomepageURI() != null) {
            jSONObject.put("homepage_uri", this.getHomepageURI().toString());
        }
        if (CollectionUtils.isNotEmpty(this.trustMarks)) {
            JSONArray jSONArray = new JSONArray();
            for (SignedJWT signedJWT : this.trustMarks) {
                jSONArray.add(signedJWT.serialize());
            }
            jSONObject.put("trust_marks", jSONArray);
        }
        return jSONObject;
    }

    @Override
    public String toJSONString() {
        return this.toJSONObject().toJSONString();
    }

    public static FederationEntityMetadata parse(JSONObject jSONObject) throws ParseException {
        URI uRI = JSONObjectUtils.getURI(jSONObject, "federation_api_endpoint", null);
        FederationEntityMetadata federationEntityMetadata = new FederationEntityMetadata(uRI);
        if (jSONObject.get("trust_anchor_id") != null) {
            federationEntityMetadata.setTrustAnchorID(new EntityID(JSONObjectUtils.getString(jSONObject, "trust_anchor_id")));
        }
        federationEntityMetadata.setName(JSONObjectUtils.getString(jSONObject, "name", null));
        federationEntityMetadata.setContacts(JSONObjectUtils.getStringList(jSONObject, "contacts", null));
        federationEntityMetadata.setPolicyURI(JSONObjectUtils.getURI(jSONObject, "policy_uri", null));
        federationEntityMetadata.setHomepageURI(JSONObjectUtils.getURI(jSONObject, "homepage_uri", null));
        JSONArray jSONArray = JSONObjectUtils.getJSONArray(jSONObject, "trust_marks", null);
        LinkedList<SignedJWT> linkedList = null;
        if (CollectionUtils.isNotEmpty(jSONArray)) {
            linkedList = new LinkedList<SignedJWT>();
            for (String string : JSONArrayUtils.toStringList(jSONArray)) {
                try {
                    linkedList.add(SignedJWT.parse(string));
                }
                catch (java.text.ParseException parseException) {
                    throw new ParseException("Invalid trust mark JWT: " + parseException.getMessage());
                }
            }
        }
        federationEntityMetadata.setTrustMarks(linkedList);
        return federationEntityMetadata;
    }

    public static FederationEntityMetadata parse(String string) throws ParseException {
        return FederationEntityMetadata.parse(JSONObjectUtils.parse(string));
    }
}

