/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.federation.entities;

import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.JWKSet;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jwt.JWTClaimsSet;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.ParseException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.as.AuthorizationServerMetadata;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.client.ClientMetadata;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.id.Identifier;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.id.Issuer;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.id.Subject;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.JSONObjectUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.MapUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.claims.CommonClaimsSet;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.federation.entities.EntityID;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.federation.entities.FederationEntityMetadata;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.federation.entities.FederationMetadataType;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.federation.policy.MetadataPolicy;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.federation.policy.language.PolicyViolationException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.federation.trust.constraints.TrustChainConstraints;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.op.OIDCProviderMetadata;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.rp.OIDCClientMetadata;
import macromedia.jdbc.sqlserver.externals.net.minidev.json.JSONObject;

public class EntityStatementClaimsSet
extends CommonClaimsSet {
    public static final String EXP_CLAIM_NAME = "exp";
    public static final String JWKS_CLAIM_NAME = "jwks";
    public static final String AUTHORITY_HINTS_CLAIM_NAME = "authority_hints";
    public static final String METADATA_CLAIM_NAME = "metadata";
    public static final String METADATA_POLICY_CLAIM_NAME = "metadata_policy";
    public static final String TRUST_ANCHOR_ID_CLAIM_NAME = "trust_anchor_id";
    public static final String CONSTRAINTS_CLAIM_NAME = "constraints";
    public static final String CRITICAL_CLAIM_NAME = "crit";
    public static final String POLICY_LANGUAGE_CRITICAL_CLAIM_NAME = "policy_language_crit";

    public EntityStatementClaimsSet(Issuer issuer, Subject subject, Date date, Date date2, JWKSet jWKSet) {
        this(new EntityID(issuer.getValue()), new EntityID(subject.getValue()), date, date2, jWKSet);
    }

    public EntityStatementClaimsSet(EntityID entityID, EntityID entityID2, Date date, Date date2, JWKSet jWKSet) {
        this.setClaim("iss", entityID.getValue());
        this.setClaim("sub", entityID2.getValue());
        this.setDateClaim("iat", date);
        this.setDateClaim(EXP_CLAIM_NAME, date2);
        if (jWKSet != null) {
            this.setClaim(JWKS_CLAIM_NAME, new JSONObject(jWKSet.toJSONObject(true)));
        }
    }

    public EntityStatementClaimsSet(JWTClaimsSet jWTClaimsSet) throws ParseException {
        super(JSONObjectUtils.toJSONObject(jWTClaimsSet));
        this.validateRequiredClaimsPresence();
    }

    public void validateRequiredClaimsPresence() throws ParseException {
        if (this.getIssuer() == null) {
            throw new ParseException("Missing iss (issuer) claim");
        }
        EntityID.parse(this.getIssuer());
        if (this.getSubject() == null) {
            throw new ParseException("Missing sub (subject) claim");
        }
        EntityID.parse(this.getSubject());
        if (this.getIssueTime() == null) {
            throw new ParseException("Missing iat (issued-at) claim");
        }
        if (this.getExpirationTime() == null) {
            throw new ParseException("Missing exp (expiration) claim");
        }
        if (this.isSelfStatement() && this.getJWKSet() == null) {
            throw new ParseException("Missing jwks (JWK set) claim");
        }
        if (this.isSelfStatement() && !this.hasMetadata()) {
            throw new ParseException("Missing required metadata claim for self-statement");
        }
        List<String> list = this.getCriticalExtensionClaims();
        if (list != null) {
            for (String string : list) {
                if (this.getClaim(string) != null) continue;
                throw new ParseException("Missing critical " + string + " claim");
            }
        }
    }

    public boolean isSelfStatement() {
        Issuer issuer = this.getIssuer();
        Subject subject = this.getSubject();
        return issuer != null && subject != null && issuer.getValue().equals(subject.getValue());
    }

    public EntityID getIssuerEntityID() {
        return new EntityID(this.getIssuer().getValue());
    }

    public EntityID getSubjectEntityID() {
        return new EntityID(this.getSubject().getValue());
    }

    public Date getExpirationTime() {
        return this.getDateClaim(EXP_CLAIM_NAME);
    }

    public JWKSet getJWKSet() {
        JSONObject jSONObject = this.getJSONObjectClaim(JWKS_CLAIM_NAME);
        if (jSONObject == null) {
            return null;
        }
        try {
            return JWKSet.parse(jSONObject);
        }
        catch (java.text.ParseException parseException) {
            return null;
        }
    }

    public List<EntityID> getAuthorityHints() {
        List<String> list = this.getStringListClaim(AUTHORITY_HINTS_CLAIM_NAME);
        if (list == null) {
            return null;
        }
        LinkedList<EntityID> linkedList = new LinkedList<EntityID>();
        for (String string : list) {
            linkedList.add(new EntityID(string));
        }
        return linkedList;
    }

    public void setAuthorityHints(List<EntityID> list) {
        if (list != null) {
            this.setClaim(AUTHORITY_HINTS_CLAIM_NAME, Identifier.toStringList(list));
        } else {
            this.setClaim(AUTHORITY_HINTS_CLAIM_NAME, null);
        }
    }

    public boolean hasMetadata() {
        JSONObject jSONObject = this.getJSONObjectClaim(METADATA_CLAIM_NAME);
        if (MapUtils.isEmpty(jSONObject)) {
            return false;
        }
        if (jSONObject.get(FederationMetadataType.OPENID_RELYING_PARTY.getValue()) != null) {
            return true;
        }
        if (jSONObject.get(FederationMetadataType.OPENID_PROVIDER.getValue()) != null) {
            return true;
        }
        if (jSONObject.get(FederationMetadataType.OAUTH_AUTHORIZATION_SERVER.getValue()) != null) {
            return true;
        }
        if (jSONObject.get(FederationMetadataType.OAUTH_CLIENT.getValue()) != null) {
            return true;
        }
        if (jSONObject.get(FederationMetadataType.OAUTH_RESOURCE.getValue()) != null) {
            return true;
        }
        return jSONObject.get(FederationMetadataType.FEDERATION_ENTITY.getValue()) != null;
    }

    public JSONObject getMetadata(FederationMetadataType federationMetadataType) {
        JSONObject jSONObject = this.getJSONObjectClaim(METADATA_CLAIM_NAME);
        if (jSONObject == null) {
            return null;
        }
        try {
            return JSONObjectUtils.getJSONObject(jSONObject, federationMetadataType.getValue(), null);
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    public void setMetadata(FederationMetadataType federationMetadataType, JSONObject jSONObject) {
        JSONObject jSONObject2 = this.getJSONObjectClaim(METADATA_CLAIM_NAME);
        if (jSONObject2 == null) {
            if (jSONObject == null) {
                return;
            }
            jSONObject2 = new JSONObject();
        }
        jSONObject2.put(federationMetadataType.getValue(), jSONObject);
        this.setClaim(METADATA_CLAIM_NAME, jSONObject2);
    }

    public OIDCClientMetadata getRPMetadata() {
        JSONObject jSONObject = this.getMetadata(FederationMetadataType.OPENID_RELYING_PARTY);
        if (jSONObject == null) {
            return null;
        }
        try {
            return OIDCClientMetadata.parse(jSONObject);
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    public void setRPMetadata(OIDCClientMetadata oIDCClientMetadata) {
        JSONObject jSONObject = oIDCClientMetadata != null ? oIDCClientMetadata.toJSONObject() : null;
        this.setMetadata(FederationMetadataType.OPENID_RELYING_PARTY, jSONObject);
    }

    public OIDCProviderMetadata getOPMetadata() {
        JSONObject jSONObject = this.getMetadata(FederationMetadataType.OPENID_PROVIDER);
        if (jSONObject == null) {
            return null;
        }
        try {
            return OIDCProviderMetadata.parse(jSONObject);
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    public void setOPMetadata(OIDCProviderMetadata oIDCProviderMetadata) {
        JSONObject jSONObject = oIDCProviderMetadata != null ? oIDCProviderMetadata.toJSONObject() : null;
        this.setMetadata(FederationMetadataType.OPENID_PROVIDER, jSONObject);
    }

    public ClientMetadata getOAuthClientMetadata() {
        JSONObject jSONObject = this.getMetadata(FederationMetadataType.OAUTH_CLIENT);
        if (jSONObject == null) {
            return null;
        }
        try {
            return ClientMetadata.parse(jSONObject);
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    public void setOAuthClientMetadata(ClientMetadata clientMetadata) {
        JSONObject jSONObject = clientMetadata != null ? clientMetadata.toJSONObject() : null;
        this.setMetadata(FederationMetadataType.OAUTH_CLIENT, jSONObject);
    }

    public AuthorizationServerMetadata getASMetadata() {
        JSONObject jSONObject = this.getMetadata(FederationMetadataType.OAUTH_AUTHORIZATION_SERVER);
        if (jSONObject == null) {
            return null;
        }
        try {
            return AuthorizationServerMetadata.parse(jSONObject);
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    public void setASMetadata(AuthorizationServerMetadata authorizationServerMetadata) {
        JSONObject jSONObject = authorizationServerMetadata != null ? authorizationServerMetadata.toJSONObject() : null;
        this.setMetadata(FederationMetadataType.OAUTH_AUTHORIZATION_SERVER, jSONObject);
    }

    public FederationEntityMetadata getFederationEntityMetadata() {
        JSONObject jSONObject = this.getMetadata(FederationMetadataType.FEDERATION_ENTITY);
        if (jSONObject == null) {
            return null;
        }
        try {
            return FederationEntityMetadata.parse(jSONObject);
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    public void setFederationEntityMetadata(FederationEntityMetadata federationEntityMetadata) {
        JSONObject jSONObject = federationEntityMetadata != null ? federationEntityMetadata.toJSONObject() : null;
        this.setMetadata(FederationMetadataType.FEDERATION_ENTITY, jSONObject);
    }

    public JSONObject getMetadataPolicyJSONObject() {
        return this.getJSONObjectClaim(METADATA_POLICY_CLAIM_NAME);
    }

    public void setMetadataPolicyJSONObject(JSONObject jSONObject) {
        this.setClaim(METADATA_POLICY_CLAIM_NAME, jSONObject);
    }

    public MetadataPolicy getMetadataPolicy(FederationMetadataType federationMetadataType) throws PolicyViolationException {
        JSONObject jSONObject = this.getMetadataPolicyJSONObject();
        if (jSONObject == null) {
            return null;
        }
        try {
            JSONObject jSONObject2 = JSONObjectUtils.getJSONObject(jSONObject, federationMetadataType.getValue(), null);
            if (jSONObject2 == null) {
                return null;
            }
            return MetadataPolicy.parse(jSONObject2);
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    public void setMetadataPolicy(FederationMetadataType federationMetadataType, MetadataPolicy metadataPolicy) {
        JSONObject jSONObject = this.getMetadataPolicyJSONObject();
        if (jSONObject == null) {
            if (metadataPolicy == null) {
                return;
            }
            jSONObject = new JSONObject();
        }
        if (metadataPolicy != null) {
            jSONObject.put(federationMetadataType.getValue(), metadataPolicy.toJSONObject());
        } else {
            jSONObject.remove(federationMetadataType.getValue());
        }
        if (jSONObject.isEmpty()) {
            jSONObject = null;
        }
        this.setMetadataPolicyJSONObject(jSONObject);
    }

    public EntityID getTrustAnchorID() {
        String string = this.getStringClaim(TRUST_ANCHOR_ID_CLAIM_NAME);
        try {
            return EntityID.parse(string);
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    public void setTrustAnchorID(EntityID entityID) {
        if (entityID != null) {
            this.setClaim(TRUST_ANCHOR_ID_CLAIM_NAME, entityID.getValue());
        } else {
            this.setClaim(TRUST_ANCHOR_ID_CLAIM_NAME, null);
        }
    }

    public TrustChainConstraints getConstraints() {
        JSONObject jSONObject = this.getJSONObjectClaim(CONSTRAINTS_CLAIM_NAME);
        if (jSONObject == null) {
            return null;
        }
        try {
            return TrustChainConstraints.parse(jSONObject);
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    public void setConstraints(TrustChainConstraints trustChainConstraints) {
        if (trustChainConstraints != null) {
            this.setClaim(CONSTRAINTS_CLAIM_NAME, trustChainConstraints.toJSONObject());
        } else {
            this.setClaim(CONSTRAINTS_CLAIM_NAME, null);
        }
    }

    public List<String> getCriticalExtensionClaims() {
        return this.getStringListClaim(CRITICAL_CLAIM_NAME);
    }

    public void setCriticalExtensionClaims(List<String> list) {
        if (list != null && list.isEmpty()) {
            throw new IllegalArgumentException("The critical extension claim names must not be empty");
        }
        this.setClaim(CRITICAL_CLAIM_NAME, list);
    }

    public List<String> getCriticalPolicyExtensions() {
        return this.getStringListClaim(POLICY_LANGUAGE_CRITICAL_CLAIM_NAME);
    }

    public void setCriticalPolicyExtensions(List<String> list) {
        if (list != null && list.isEmpty()) {
            throw new IllegalArgumentException("The critical policy extension names must not be empty");
        }
        this.setClaim(POLICY_LANGUAGE_CRITICAL_CLAIM_NAME, list);
    }
}

