/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.federation.api;

import java.net.URI;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.ParseException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.http.HTTPRequest;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.MultivaluedMapUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.StringUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.federation.api.FederationAPIRequest;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.federation.api.OperationType;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.federation.entities.EntityID;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.federation.entities.FederationMetadataType;
import macromedia.jdbc.sqlserver.externals.net.jcip.annotations.Immutable;

@Immutable
public class TrustNegotiationRequest
extends FederationAPIRequest {
    private final EntityID respondent;
    private final EntityID peer;
    private final FederationMetadataType metadataType;
    private final EntityID anchor;

    public TrustNegotiationRequest(URI uRI, EntityID entityID, EntityID entityID2, FederationMetadataType federationMetadataType, EntityID entityID3) {
        super(uRI, OperationType.RESOLVE_METADATA);
        if (entityID == null) {
            throw new IllegalArgumentException("The respondent must not be null");
        }
        this.respondent = entityID;
        if (entityID2 == null) {
            throw new IllegalArgumentException("The peer must not be null");
        }
        this.peer = entityID2;
        if (federationMetadataType == null) {
            throw new IllegalArgumentException("The metadata type must not be null");
        }
        this.metadataType = federationMetadataType;
        if (entityID3 == null) {
            throw new IllegalArgumentException("The anchor must not be null");
        }
        this.anchor = entityID3;
    }

    public EntityID getRespondent() {
        return this.respondent;
    }

    public EntityID getPeer() {
        return this.peer;
    }

    public FederationMetadataType getMetadataType() {
        return this.metadataType;
    }

    public EntityID getTrustAnchor() {
        return this.anchor;
    }

    @Override
    public Map<String, List<String>> toParameters() {
        LinkedHashMap<String, List<String>> linkedHashMap = new LinkedHashMap<String, List<String>>();
        linkedHashMap.put("operation", Collections.singletonList(this.getOperationType().getValue()));
        linkedHashMap.put("respondent", Collections.singletonList(this.getRespondent().getValue()));
        linkedHashMap.put("peer", Collections.singletonList(this.getPeer().getValue()));
        linkedHashMap.put("type", Collections.singletonList(this.getMetadataType().getValue()));
        linkedHashMap.put("anchor", Collections.singletonList(this.getTrustAnchor().getValue()));
        return linkedHashMap;
    }

    public static TrustNegotiationRequest parse(Map<String, List<String>> map) throws ParseException {
        String string = MultivaluedMapUtils.getFirstValue(map, "operation");
        if (StringUtils.isBlank(string)) {
            throw new ParseException("Missing operation type");
        }
        if (!OperationType.RESOLVE_METADATA.getValue().equals(string)) {
            throw new ParseException("The operation type must be " + OperationType.RESOLVE_METADATA);
        }
        string = MultivaluedMapUtils.getFirstValue(map, "respondent");
        if (StringUtils.isBlank(string)) {
            throw new ParseException("Missing respondent");
        }
        EntityID entityID = new EntityID(string);
        string = MultivaluedMapUtils.getFirstValue(map, "peer");
        if (StringUtils.isBlank(string)) {
            throw new ParseException("Missing peer");
        }
        EntityID entityID2 = new EntityID(string);
        string = MultivaluedMapUtils.getFirstValue(map, "type");
        if (StringUtils.isBlank(string)) {
            throw new ParseException("Missing metadata type");
        }
        FederationMetadataType federationMetadataType = new FederationMetadataType(string);
        string = MultivaluedMapUtils.getFirstValue(map, "anchor");
        if (StringUtils.isBlank(string)) {
            throw new ParseException("Missing anchor");
        }
        EntityID entityID3 = new EntityID(string);
        return new TrustNegotiationRequest(null, entityID, entityID2, federationMetadataType, entityID3);
    }

    public static TrustNegotiationRequest parse(HTTPRequest hTTPRequest) throws ParseException {
        hTTPRequest.ensureMethod(HTTPRequest.Method.GET);
        TrustNegotiationRequest trustNegotiationRequest = TrustNegotiationRequest.parse(hTTPRequest.getQueryParameters());
        return new TrustNegotiationRequest(hTTPRequest.getURI(), trustNegotiationRequest.respondent, trustNegotiationRequest.getPeer(), trustNegotiationRequest.getMetadataType(), trustNegotiationRequest.getTrustAnchor());
    }
}

