/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.federation.api;

import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.ParseException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.http.HTTPRequest;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.id.Audience;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.id.Issuer;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.id.Subject;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.MultivaluedMapUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.federation.api.FederationAPIRequest;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.federation.api.OperationType;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.federation.entities.EntityID;
import macromedia.jdbc.sqlserver.externals.net.jcip.annotations.Immutable;

@Immutable
public class FetchEntityStatementRequest
extends FederationAPIRequest {
    private final Issuer issuer;
    private final Subject subject;
    private final Audience audience;

    public FetchEntityStatementRequest(URI uRI, Issuer issuer, Subject subject, Audience audience) {
        super(uRI, OperationType.FETCH);
        if (issuer == null) {
            throw new IllegalArgumentException("The issuer must not be null");
        }
        this.issuer = issuer;
        this.subject = subject;
        this.audience = audience;
    }

    public FetchEntityStatementRequest(URI uRI, EntityID entityID, EntityID entityID2, EntityID entityID3) {
        this(uRI, new Issuer(entityID.getValue()), entityID2 != null ? new Subject(entityID2.getValue()) : null, entityID3 != null ? new Audience(entityID3.getValue()) : null);
    }

    public Issuer getIssuer() {
        return this.issuer;
    }

    public EntityID getIssuerEntityID() {
        return new EntityID(this.getIssuer().getValue());
    }

    public Subject getSubject() {
        return this.subject;
    }

    public EntityID getSubjectEntityID() {
        return this.getSubject() != null ? new EntityID(this.getSubject().getValue()) : null;
    }

    public Audience getAudience() {
        return this.audience;
    }

    public EntityID getAudienceEntityID() {
        return this.getAudience() != null ? new EntityID(this.getAudience().getValue()) : null;
    }

    @Override
    public Map<String, List<String>> toParameters() {
        HashMap<String, List<String>> hashMap = new HashMap<String, List<String>>();
        hashMap.put("iss", Collections.singletonList(this.getIssuer().getValue()));
        if (this.getSubject() != null) {
            hashMap.put("sub", Collections.singletonList(this.getSubject().getValue()));
        }
        if (this.getAudience() != null) {
            hashMap.put("aud", Collections.singletonList(this.getAudience().getValue()));
        }
        return hashMap;
    }

    public static FetchEntityStatementRequest parse(Map<String, List<String>> map) throws ParseException {
        String string = MultivaluedMapUtils.getFirstValue(map, "operation");
        if (string != null && !string.equalsIgnoreCase(OperationType.FETCH.getValue())) {
            throw new ParseException("The operation type must be fetch or unspecified");
        }
        string = MultivaluedMapUtils.getFirstValue(map, "iss");
        if (string == null) {
            throw new ParseException("Missing iss (issuer) parameter");
        }
        Issuer issuer = new Issuer(string);
        string = MultivaluedMapUtils.getFirstValue(map, "sub");
        Subject subject = null;
        if (string != null) {
            subject = new Subject(string);
        }
        string = MultivaluedMapUtils.getFirstValue(map, "aud");
        Audience audience = null;
        if (string != null) {
            audience = new Audience(string);
        }
        return new FetchEntityStatementRequest(null, issuer, subject, audience);
    }

    public static FetchEntityStatementRequest parse(HTTPRequest hTTPRequest) throws ParseException {
        hTTPRequest.ensureMethod(HTTPRequest.Method.GET);
        FetchEntityStatementRequest fetchEntityStatementRequest = FetchEntityStatementRequest.parse(hTTPRequest.getQueryParameters());
        return new FetchEntityStatementRequest(hTTPRequest.getURI(), fetchEntityStatementRequest.getIssuer(), fetchEntityStatementRequest.getSubject(), fetchEntityStatementRequest.getAudience());
    }
}

