/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.assurance.evidences.attachment;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Objects;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.util.Base64;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.ParseException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.JSONObjectUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.assurance.evidences.attachment.HashAlgorithm;
import macromedia.jdbc.sqlserver.externals.net.jcip.annotations.Immutable;
import macromedia.jdbc.sqlserver.externals.net.minidev.json.JSONObject;

@Immutable
public final class Digest {
    private final HashAlgorithm alg;
    private final Base64 value;

    public Digest(HashAlgorithm hashAlgorithm, Base64 base64) {
        Objects.requireNonNull(hashAlgorithm);
        this.alg = hashAlgorithm;
        Objects.requireNonNull(base64);
        this.value = base64;
    }

    public HashAlgorithm getHashAlgorithm() {
        return this.alg;
    }

    public Base64 getValue() {
        return this.value;
    }

    public boolean matches(Base64 base64) throws NoSuchAlgorithmException {
        Digest digest = Digest.compute(this.getHashAlgorithm(), base64);
        return this.equals(digest);
    }

    public JSONObject toJSONObject() {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("alg", this.getHashAlgorithm().getValue());
        jSONObject.put("value", this.getValue().toString());
        return jSONObject;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Digest)) {
            return false;
        }
        Digest digest = (Digest)object;
        return this.alg.equals(digest.alg) && this.getValue().equals(digest.getValue());
    }

    public int hashCode() {
        return Objects.hash(this.alg, this.getValue());
    }

    public static Digest compute(HashAlgorithm hashAlgorithm, Base64 base64) throws NoSuchAlgorithmException {
        return Digest.compute(hashAlgorithm, base64.decode());
    }

    public static Digest compute(HashAlgorithm hashAlgorithm, byte[] byArray) throws NoSuchAlgorithmException {
        MessageDigest messageDigest = MessageDigest.getInstance(hashAlgorithm.getValue().toUpperCase());
        byte[] byArray2 = messageDigest.digest(byArray);
        return new Digest(hashAlgorithm, Base64.encode(byArray2));
    }

    public static Digest parse(JSONObject jSONObject) throws ParseException {
        HashAlgorithm hashAlgorithm = new HashAlgorithm(JSONObjectUtils.getString(jSONObject, "alg"));
        Base64 base64 = new Base64(JSONObjectUtils.getString(jSONObject, "value"));
        return new Digest(hashAlgorithm, base64);
    }
}

