/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.assurance.evidences;

import java.util.List;
import java.util.Objects;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.ParseException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.id.Issuer;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.JSONObjectUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.date.DateWithTimeZoneOffset;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.assurance.evidences.IdentityEvidence;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.assurance.evidences.IdentityEvidenceType;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.assurance.evidences.SerialNumber;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.assurance.evidences.SignatureType;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.assurance.evidences.attachment.Attachment;
import macromedia.jdbc.sqlserver.externals.net.minidev.json.JSONObject;

public class ElectronicSignatureEvidence
extends IdentityEvidence {
    private final SignatureType signatureType;
    private final Issuer issuer;
    private final SerialNumber certificateSerialNumber;
    private final DateWithTimeZoneOffset createdAt;

    public ElectronicSignatureEvidence(SignatureType signatureType, Issuer issuer, SerialNumber serialNumber, DateWithTimeZoneOffset dateWithTimeZoneOffset, List<Attachment> list) {
        super(IdentityEvidenceType.ELECTRONIC_SIGNATURE, list);
        Objects.requireNonNull(signatureType);
        this.signatureType = signatureType;
        this.issuer = issuer;
        this.certificateSerialNumber = serialNumber;
        this.createdAt = dateWithTimeZoneOffset;
    }

    public SignatureType getSignatureType() {
        return this.signatureType;
    }

    public Issuer getIssuer() {
        return this.issuer;
    }

    public SerialNumber getCertificateSerialNumber() {
        return this.certificateSerialNumber;
    }

    public DateWithTimeZoneOffset getCreationTime() {
        return this.createdAt;
    }

    @Override
    public JSONObject toJSONObject() {
        JSONObject jSONObject = super.toJSONObject();
        jSONObject.put("signature_type", this.getSignatureType().getValue());
        if (this.getIssuer() != null) {
            jSONObject.put("issuer", this.getIssuer().getValue());
        }
        if (this.getCertificateSerialNumber() != null) {
            jSONObject.put("serial_number", this.getCertificateSerialNumber().getValue());
        }
        if (this.getCreationTime() != null) {
            jSONObject.put("created_at", this.getCreationTime().toISO8601String());
        }
        return jSONObject;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ElectronicSignatureEvidence)) {
            return false;
        }
        ElectronicSignatureEvidence electronicSignatureEvidence = (ElectronicSignatureEvidence)object;
        return this.getSignatureType().equals(electronicSignatureEvidence.getSignatureType()) && Objects.equals(this.getIssuer(), electronicSignatureEvidence.getIssuer()) && Objects.equals(this.getCertificateSerialNumber(), electronicSignatureEvidence.getCertificateSerialNumber()) && Objects.equals(this.createdAt, electronicSignatureEvidence.createdAt);
    }

    public int hashCode() {
        return Objects.hash(this.getSignatureType(), this.getIssuer(), this.getCertificateSerialNumber(), this.createdAt);
    }

    public static ElectronicSignatureEvidence parse(JSONObject jSONObject) throws ParseException {
        ElectronicSignatureEvidence.ensureType(IdentityEvidenceType.ELECTRONIC_SIGNATURE, jSONObject);
        SignatureType signatureType = new SignatureType(JSONObjectUtils.getString(jSONObject, "signature_type"));
        Issuer issuer = null;
        if (jSONObject.get("issuer") != null) {
            issuer = new Issuer(JSONObjectUtils.getString(jSONObject, "issuer"));
        }
        SerialNumber serialNumber = null;
        if (jSONObject.get("serial_number") != null) {
            serialNumber = new SerialNumber(JSONObjectUtils.getString(jSONObject, "serial_number", null));
        }
        DateWithTimeZoneOffset dateWithTimeZoneOffset = null;
        if (jSONObject.get("created_at") != null) {
            dateWithTimeZoneOffset = DateWithTimeZoneOffset.parseISO8601String(JSONObjectUtils.getString(jSONObject, "created_at"));
        }
        List<Attachment> list = null;
        if (jSONObject.get("attachments") != null) {
            list = Attachment.parseList(JSONObjectUtils.getJSONArray(jSONObject, "attachments"));
        }
        return new ElectronicSignatureEvidence(signatureType, issuer, serialNumber, dateWithTimeZoneOffset, list);
    }
}

