/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.assurance.claims;

import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.ParseException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.JSONObjectUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.assurance.IdentityVerification;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.claims.ClaimsSet;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.claims.PersonClaims;
import macromedia.jdbc.sqlserver.externals.net.minidev.json.JSONAware;
import macromedia.jdbc.sqlserver.externals.net.minidev.json.JSONObject;

public class VerifiedClaimsSet
implements JSONAware {
    public static final String VERIFICATION_ELEMENT = "verification";
    public static final String CLAIMS_ELEMENT = "claims";
    private final IdentityVerification identityVerification;
    private final ClaimsSet claimsSet;

    public VerifiedClaimsSet(IdentityVerification identityVerification, ClaimsSet claimsSet) {
        if (identityVerification == null) {
            throw new IllegalArgumentException("The verification must not be null");
        }
        this.identityVerification = identityVerification;
        if (claimsSet == null) {
            throw new IllegalArgumentException("The claims must not be null");
        }
        this.claimsSet = claimsSet;
    }

    public IdentityVerification getVerification() {
        return this.identityVerification;
    }

    public PersonClaims getClaimsSet() {
        return new PersonClaims(this.claimsSet.toJSONObject());
    }

    public JSONObject toJSONObject() {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put(VERIFICATION_ELEMENT, this.identityVerification.toJSONObject());
        jSONObject.put(CLAIMS_ELEMENT, this.claimsSet.toJSONObject());
        return jSONObject;
    }

    @Override
    public String toJSONString() {
        return this.toJSONObject().toJSONString();
    }

    public static VerifiedClaimsSet parse(JSONObject jSONObject) throws ParseException {
        return new VerifiedClaimsSet(IdentityVerification.parse(JSONObjectUtils.getJSONObject(jSONObject, VERIFICATION_ELEMENT)), new PersonClaims(JSONObjectUtils.getJSONObject(jSONObject, CLAIMS_ELEMENT)));
    }
}

