/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.common.contenttype.ContentType;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.ErrorObject;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.ErrorResponse;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.ParseException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.http.HTTPResponse;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.token.AccessTokenType;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.token.BearerTokenError;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.token.DPoPTokenError;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.token.TokenSchemeError;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.StringUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.UserInfoResponse;
import macromedia.jdbc.sqlserver.externals.net.jcip.annotations.Immutable;

@Immutable
public class UserInfoErrorResponse
extends UserInfoResponse
implements ErrorResponse {
    private final ErrorObject error;

    public static Set<BearerTokenError> getStandardErrors() {
        HashSet<BearerTokenError> hashSet = new HashSet<BearerTokenError>();
        hashSet.add(BearerTokenError.MISSING_TOKEN);
        hashSet.add(BearerTokenError.INVALID_REQUEST);
        hashSet.add(BearerTokenError.INVALID_TOKEN);
        hashSet.add(BearerTokenError.INSUFFICIENT_SCOPE);
        return Collections.unmodifiableSet(hashSet);
    }

    private UserInfoErrorResponse() {
        this.error = null;
    }

    public UserInfoErrorResponse(BearerTokenError bearerTokenError) {
        this((ErrorObject)bearerTokenError);
    }

    public UserInfoErrorResponse(DPoPTokenError dPoPTokenError) {
        this((ErrorObject)dPoPTokenError);
    }

    public UserInfoErrorResponse(ErrorObject errorObject) {
        if (errorObject == null) {
            throw new IllegalArgumentException("The error must not be null");
        }
        this.error = errorObject;
    }

    @Override
    public boolean indicatesSuccess() {
        return false;
    }

    @Override
    public ErrorObject getErrorObject() {
        return this.error;
    }

    @Override
    public HTTPResponse toHTTPResponse() {
        HTTPResponse hTTPResponse = this.error != null && this.error.getHTTPStatusCode() > 0 ? new HTTPResponse(this.error.getHTTPStatusCode()) : new HTTPResponse(400);
        if (this.error instanceof TokenSchemeError) {
            hTTPResponse.setWWWAuthenticate(((TokenSchemeError)this.error).toWWWAuthenticateHeader());
        } else if (this.error != null) {
            hTTPResponse.setEntityContentType(ContentType.APPLICATION_JSON);
            hTTPResponse.setContent(this.error.toJSONObject().toJSONString());
        }
        return hTTPResponse;
    }

    public static UserInfoErrorResponse parse(String string) throws ParseException {
        BearerTokenError bearerTokenError = BearerTokenError.parse(string);
        return new UserInfoErrorResponse(bearerTokenError);
    }

    public static UserInfoErrorResponse parse(HTTPResponse hTTPResponse) throws ParseException {
        hTTPResponse.ensureStatusCodeNotOK();
        String string = hTTPResponse.getWWWAuthenticate();
        if (StringUtils.isNotBlank(string)) {
            if (string.toLowerCase().startsWith(AccessTokenType.BEARER.getValue().toLowerCase())) {
                try {
                    BearerTokenError bearerTokenError = BearerTokenError.parse(string);
                    return new UserInfoErrorResponse(new BearerTokenError(bearerTokenError.getCode(), bearerTokenError.getDescription(), hTTPResponse.getStatusCode(), bearerTokenError.getURI(), bearerTokenError.getRealm(), bearerTokenError.getScope()));
                }
                catch (ParseException parseException) {}
            } else if (string.toLowerCase().startsWith(AccessTokenType.DPOP.getValue().toLowerCase())) {
                try {
                    DPoPTokenError dPoPTokenError = DPoPTokenError.parse(string);
                    return new UserInfoErrorResponse(new DPoPTokenError(dPoPTokenError.getCode(), dPoPTokenError.getDescription(), hTTPResponse.getStatusCode(), dPoPTokenError.getURI(), dPoPTokenError.getRealm(), dPoPTokenError.getScope(), dPoPTokenError.getJWSAlgorithms()));
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
        }
        return new UserInfoErrorResponse(ErrorObject.parse(hTTPResponse));
    }
}

