/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jwt.JWT;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jwt.JWTParser;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.AbstractRequest;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.ParseException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.SerializeException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.http.HTTPRequest;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.id.State;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.MultivaluedMapUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.StringUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.URIUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.URLUtils;
import macromedia.jdbc.sqlserver.externals.net.jcip.annotations.Immutable;

@Immutable
public class LogoutRequest
extends AbstractRequest {
    private final JWT idTokenHint;
    private final URI postLogoutRedirectURI;
    private final State state;

    public LogoutRequest(URI uRI, JWT jWT, URI uRI2, State state) {
        super(uRI);
        this.idTokenHint = jWT;
        this.postLogoutRedirectURI = uRI2;
        if (uRI2 == null && state != null) {
            throw new IllegalArgumentException("The state parameter required a post-logout redirection URI");
        }
        this.state = state;
    }

    public LogoutRequest(URI uRI, JWT jWT) {
        this(uRI, jWT, null, null);
    }

    public LogoutRequest(URI uRI) {
        this(uRI, null, null, null);
    }

    public JWT getIDTokenHint() {
        return this.idTokenHint;
    }

    public URI getPostLogoutRedirectionURI() {
        return this.postLogoutRedirectURI;
    }

    public State getState() {
        return this.state;
    }

    public Map<String, List<String>> toParameters() {
        LinkedHashMap<String, List<String>> linkedHashMap = new LinkedHashMap<String, List<String>>();
        if (this.idTokenHint != null) {
            try {
                linkedHashMap.put("id_token_hint", Collections.singletonList(this.idTokenHint.serialize()));
            }
            catch (IllegalStateException illegalStateException) {
                throw new SerializeException("Couldn't serialize ID token: " + illegalStateException.getMessage(), illegalStateException);
            }
        }
        if (this.postLogoutRedirectURI != null) {
            linkedHashMap.put("post_logout_redirect_uri", Collections.singletonList(this.postLogoutRedirectURI.toString()));
        }
        if (this.state != null) {
            linkedHashMap.put("state", Collections.singletonList(this.state.getValue()));
        }
        return linkedHashMap;
    }

    public String toQueryString() {
        return URLUtils.serializeParameters(this.toParameters());
    }

    public URI toURI() {
        if (this.getEndpointURI() == null) {
            throw new SerializeException("The end-session endpoint URI is not specified");
        }
        HashMap<String, List<String>> hashMap = new HashMap<String, List<String>>(URLUtils.parseParameters(this.getEndpointURI().getQuery()));
        hashMap.putAll(this.toParameters());
        String string = URLUtils.serializeParameters(hashMap);
        if (StringUtils.isNotBlank(string)) {
            string = '?' + string;
        }
        try {
            return new URI(URIUtils.getBaseURI(this.getEndpointURI()) + string);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new SerializeException(uRISyntaxException.getMessage(), uRISyntaxException);
        }
    }

    @Override
    public HTTPRequest toHTTPRequest() {
        URL uRL;
        if (this.getEndpointURI() == null) {
            throw new SerializeException("The endpoint URI is not specified");
        }
        HashMap<String, List<String>> hashMap = new HashMap<String, List<String>>(URLUtils.parseParameters(this.getEndpointURI().getQuery()));
        hashMap.putAll(this.toParameters());
        try {
            uRL = URLUtils.getBaseURL(this.getEndpointURI().toURL());
        }
        catch (MalformedURLException malformedURLException) {
            throw new SerializeException(malformedURLException.getMessage(), malformedURLException);
        }
        HTTPRequest hTTPRequest = new HTTPRequest(HTTPRequest.Method.GET, uRL);
        hTTPRequest.setQuery(URLUtils.serializeParameters(hashMap));
        return hTTPRequest;
    }

    public static LogoutRequest parse(Map<String, List<String>> map) throws ParseException {
        return LogoutRequest.parse(null, map);
    }

    public static LogoutRequest parse(URI uRI, Map<String, List<String>> map) throws ParseException {
        String string = MultivaluedMapUtils.getFirstValue(map, "id_token_hint");
        JWT jWT = null;
        if (StringUtils.isNotBlank(string)) {
            try {
                jWT = JWTParser.parse(string);
            }
            catch (java.text.ParseException parseException) {
                throw new ParseException("Invalid ID token hint: " + parseException.getMessage(), parseException);
            }
        }
        string = MultivaluedMapUtils.getFirstValue(map, "post_logout_redirect_uri");
        URI uRI2 = null;
        if (StringUtils.isNotBlank(string)) {
            try {
                uRI2 = new URI(string);
            }
            catch (URISyntaxException uRISyntaxException) {
                throw new ParseException("Invalid \"post_logout_redirect_uri\" parameter: " + uRISyntaxException.getMessage(), uRISyntaxException);
            }
        }
        State state = null;
        string = MultivaluedMapUtils.getFirstValue(map, "state");
        if (uRI2 != null && StringUtils.isNotBlank(string)) {
            state = new State(string);
        }
        return new LogoutRequest(uRI, jWT, uRI2, state);
    }

    public static LogoutRequest parse(String string) throws ParseException {
        return LogoutRequest.parse(null, URLUtils.parseParameters(string));
    }

    public static LogoutRequest parse(URI uRI, String string) throws ParseException {
        return LogoutRequest.parse(uRI, URLUtils.parseParameters(string));
    }

    public static LogoutRequest parse(URI uRI) throws ParseException {
        return LogoutRequest.parse(URIUtils.getBaseURI(uRI), URLUtils.parseParameters(uRI.getRawQuery()));
    }

    public static LogoutRequest parse(HTTPRequest hTTPRequest) throws ParseException {
        String string = hTTPRequest.getQuery();
        if (string == null) {
            throw new ParseException("Missing URI query string");
        }
        return LogoutRequest.parse(URIUtils.getBaseURI(hTTPRequest.getURI()), string);
    }
}

