/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util;

import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.StringUtils;

public final class URLUtils {
    public static final String CHARSET = "utf-8";

    public static URL getBaseURL(URL uRL) {
        if (uRL == null) {
            return null;
        }
        try {
            return new URL(uRL.getProtocol(), uRL.getHost(), uRL.getPort(), uRL.getPath());
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    public static String serializeParameters(Map<String, List<String>> map) {
        if (map == null || map.isEmpty()) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (Map.Entry<String, List<String>> entry : map.entrySet()) {
            if (entry.getKey() == null || entry.getValue() == null) continue;
            for (String string : entry.getValue()) {
                if (string == null) {
                    string = "";
                }
                try {
                    String string2 = URLEncoder.encode(entry.getKey(), CHARSET);
                    String string3 = URLEncoder.encode(string, CHARSET);
                    if (stringBuilder.length() > 0) {
                        stringBuilder.append('&');
                    }
                    stringBuilder.append(string2);
                    stringBuilder.append('=');
                    stringBuilder.append(string3);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    throw new RuntimeException(unsupportedEncodingException.getMessage(), unsupportedEncodingException);
                }
            }
        }
        return stringBuilder.toString();
    }

    public static String serializeParametersAlt(Map<String, String[]> map) {
        if (map == null) {
            return URLUtils.serializeParameters(null);
        }
        HashMap<String, List<String>> hashMap = new HashMap<String, List<String>>();
        for (Map.Entry<String, String[]> entry : map.entrySet()) {
            if (entry.getValue() == null) {
                hashMap.put(entry.getKey(), null);
                continue;
            }
            hashMap.put(entry.getKey(), Arrays.asList((Object[])entry.getValue()));
        }
        return URLUtils.serializeParameters(hashMap);
    }

    public static Map<String, List<String>> parseParameters(String string) {
        HashMap<String, List<String>> hashMap = new HashMap<String, List<String>>();
        if (StringUtils.isBlank(string)) {
            return hashMap;
        }
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string.trim(), "&");
            while (stringTokenizer.hasMoreTokens()) {
                String string2;
                String string3 = stringTokenizer.nextToken();
                String[] stringArray = string3.split("=", 2);
                String string4 = URLDecoder.decode(stringArray[0], CHARSET);
                String string5 = string2 = stringArray.length > 1 ? URLDecoder.decode(stringArray[1], CHARSET) : "";
                if (hashMap.containsKey(string4)) {
                    LinkedList<String> linkedList = new LinkedList<String>((Collection)hashMap.get(string4));
                    linkedList.add(string2);
                    hashMap.put(string4, Collections.unmodifiableList(linkedList));
                    continue;
                }
                hashMap.put(string4, Collections.singletonList(string2));
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return hashMap;
    }

    private URLUtils() {
    }
}

