/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.StringUtils;

public final class URIUtils {
    public static URI getBaseURI(URI uRI) {
        if (uRI == null) {
            return null;
        }
        try {
            return new URI(uRI.getScheme(), null, uRI.getHost(), uRI.getPort(), uRI.getPath(), null, null);
        }
        catch (URISyntaxException uRISyntaxException) {
            return null;
        }
    }

    public static URI prependPath(URI uRI, String string) {
        if (uRI == null) {
            return null;
        }
        if (StringUtils.isBlank(string)) {
            return uRI;
        }
        String string2 = uRI.getPath();
        if (string2 == null || string2.isEmpty() || string2.equals("/")) {
            string2 = null;
        }
        String string3 = URIUtils.joinPathComponents(string, string2);
        string3 = URIUtils.prependLeadingSlashIfMissing(string3);
        try {
            return new URI(uRI.getScheme(), null, uRI.getHost(), uRI.getPort(), string3, uRI.getQuery(), uRI.getFragment());
        }
        catch (URISyntaxException uRISyntaxException) {
            return null;
        }
    }

    public static String prependLeadingSlashIfMissing(String string) {
        if (string == null) {
            return null;
        }
        if (string.startsWith("/")) {
            return string;
        }
        return "/" + string;
    }

    public static String stripLeadingSlashIfPresent(String string) {
        if (StringUtils.isBlank(string)) {
            return string;
        }
        if (string.startsWith("/")) {
            String string2 = string;
            while (string2.startsWith("/")) {
                string2 = string2.substring(1);
            }
            return string2;
        }
        return string;
    }

    public static String joinPathComponents(String string, String string2) {
        if (string == null && string2 == null) {
            return null;
        }
        if (string == null || string.isEmpty()) {
            return string2;
        }
        if (string2 == null || string2.isEmpty()) {
            return string;
        }
        if (string.endsWith("/") && !string2.startsWith("/")) {
            return string + string2;
        }
        if (!string.endsWith("/") && string2.startsWith("/")) {
            return string + string2;
        }
        if (string.endsWith("/") && string2.startsWith("/")) {
            return string + URIUtils.stripLeadingSlashIfPresent(string2);
        }
        return string + "/" + string2;
    }

    public static URI stripQueryString(URI uRI) {
        if (uRI == null) {
            return null;
        }
        try {
            return new URI(uRI.getScheme(), null, uRI.getHost(), uRI.getPort(), uRI.getPath(), null, uRI.getFragment());
        }
        catch (URISyntaxException uRISyntaxException) {
            return null;
        }
    }

    public static URI removeTrailingSlash(URI uRI) {
        if (uRI == null) {
            return null;
        }
        String string = uRI.toString();
        if (string.charAt(string.length() - 1) == '/') {
            return URI.create(string.substring(0, string.length() - 1));
        }
        return uRI;
    }

    public static void ensureSchemeIsHTTPS(URI uRI) {
        if (uRI == null) {
            return;
        }
        if (uRI.getScheme() == null || !"https".equalsIgnoreCase(uRI.getScheme())) {
            throw new IllegalArgumentException("The URI scheme must be https");
        }
    }

    public static void ensureSchemeIsHTTPSorHTTP(URI uRI) {
        if (uRI == null) {
            return;
        }
        if (uRI.getScheme() == null || !Arrays.asList("http", "https").contains(uRI.getScheme().toLowerCase())) {
            throw new IllegalArgumentException("The URI scheme must be https or http");
        }
    }

    public static void ensureSchemeIsNotProhibited(URI uRI, Set<String> set) {
        if (uRI == null || uRI.getScheme() == null || set == null || set.isEmpty()) {
            return;
        }
        if (set.contains(uRI.getScheme().toLowerCase())) {
            throw new IllegalArgumentException("The URI scheme " + uRI.getScheme() + " is prohibited");
        }
    }

    public static List<String> toStringList(Collection<URI> collection) {
        return URIUtils.toStringList(collection, true);
    }

    public static List<String> toStringList(Collection<URI> collection, boolean bl2) {
        if (collection == null) {
            return null;
        }
        if (collection.isEmpty()) {
            return Collections.emptyList();
        }
        LinkedList<String> linkedList = new LinkedList<String>();
        for (URI uRI : collection) {
            if (uRI != null) {
                linkedList.add(uRI.toString());
                continue;
            }
            if (bl2) continue;
            linkedList.add(null);
        }
        return linkedList;
    }

    private URIUtils() {
    }
}

