/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.token;

import java.net.URI;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JWSAlgorithm;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.ParseException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.Scope;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.token.AccessTokenType;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.token.TokenSchemeError;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.CollectionUtils;
import macromedia.jdbc.sqlserver.externals.net.jcip.annotations.Immutable;

@Immutable
public class DPoPTokenError
extends TokenSchemeError {
    private static final long serialVersionUID = 7399517620661603486L;
    static final Pattern ALGS_PATTERN = Pattern.compile("algs=\"([^\"]+)");
    public static final DPoPTokenError MISSING_TOKEN = new DPoPTokenError(null, null, 401);
    public static final DPoPTokenError INVALID_REQUEST = new DPoPTokenError("invalid_request", "Invalid request", 400);
    public static final DPoPTokenError INVALID_TOKEN = new DPoPTokenError("invalid_token", "Invalid access token", 401);
    public static final DPoPTokenError INSUFFICIENT_SCOPE = new DPoPTokenError("insufficient_scope", "Insufficient scope", 403);
    public static final DPoPTokenError INVALID_DPOP_PROOF = new DPoPTokenError("invalid_dpop_proof", "Invalid DPoP proof", 401);
    private final Set<JWSAlgorithm> jwsAlgs;

    public DPoPTokenError(String string, String string2) {
        this(string, string2, 0, null, null, null);
    }

    public DPoPTokenError(String string, String string2, int n2) {
        this(string, string2, n2, null, null, null);
    }

    public DPoPTokenError(String string, String string2, int n2, URI uRI, String string3, Scope scope) {
        this(string, string2, n2, uRI, string3, scope, null);
    }

    public DPoPTokenError(String string, String string2, int n2, URI uRI, String string3, Scope scope, Set<JWSAlgorithm> set) {
        super(AccessTokenType.DPOP, string, string2, n2, uRI, string3, scope);
        this.jwsAlgs = set;
    }

    @Override
    public DPoPTokenError setDescription(String string) {
        return new DPoPTokenError(this.getCode(), string, this.getHTTPStatusCode(), this.getURI(), this.getRealm(), this.getScope(), this.getJWSAlgorithms());
    }

    @Override
    public DPoPTokenError appendDescription(String string) {
        String string2 = this.getDescription() != null ? this.getDescription() + string : string;
        return new DPoPTokenError(this.getCode(), string2, this.getHTTPStatusCode(), this.getURI(), this.getRealm(), this.getScope(), this.getJWSAlgorithms());
    }

    @Override
    public DPoPTokenError setHTTPStatusCode(int n2) {
        return new DPoPTokenError(this.getCode(), this.getDescription(), n2, this.getURI(), this.getRealm(), this.getScope(), this.getJWSAlgorithms());
    }

    @Override
    public DPoPTokenError setURI(URI uRI) {
        return new DPoPTokenError(this.getCode(), this.getDescription(), this.getHTTPStatusCode(), uRI, this.getRealm(), this.getScope(), this.getJWSAlgorithms());
    }

    @Override
    public DPoPTokenError setRealm(String string) {
        return new DPoPTokenError(this.getCode(), this.getDescription(), this.getHTTPStatusCode(), this.getURI(), string, this.getScope(), this.getJWSAlgorithms());
    }

    @Override
    public DPoPTokenError setScope(Scope scope) {
        return new DPoPTokenError(this.getCode(), this.getDescription(), this.getHTTPStatusCode(), this.getURI(), this.getRealm(), scope, this.getJWSAlgorithms());
    }

    public Set<JWSAlgorithm> getJWSAlgorithms() {
        return this.jwsAlgs;
    }

    public DPoPTokenError setJWSAlgorithms(Set<JWSAlgorithm> set) {
        return new DPoPTokenError(this.getCode(), this.getDescription(), this.getHTTPStatusCode(), this.getURI(), this.getRealm(), this.getScope(), set);
    }

    @Override
    public String toWWWAuthenticateHeader() {
        String string = super.toWWWAuthenticateHeader();
        if (CollectionUtils.isEmpty(this.getJWSAlgorithms())) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder(string);
        if (string.contains("=")) {
            stringBuilder.append(',');
        }
        stringBuilder.append(" algs=\"");
        String string2 = "";
        for (JWSAlgorithm jWSAlgorithm : this.getJWSAlgorithms()) {
            stringBuilder.append(string2);
            string2 = " ";
            stringBuilder.append(jWSAlgorithm.getName());
        }
        stringBuilder.append("\"");
        return stringBuilder.toString();
    }

    public static DPoPTokenError parse(String string) throws ParseException {
        TokenSchemeError tokenSchemeError = TokenSchemeError.parse(string, AccessTokenType.DPOP);
        HashSet<JWSAlgorithm> hashSet = null;
        Matcher matcher = ALGS_PATTERN.matcher(string);
        if (matcher.find()) {
            String string2 = matcher.group(1);
            hashSet = new HashSet<JWSAlgorithm>();
            for (String string3 : string2.split("\\s+")) {
                hashSet.add(JWSAlgorithm.parse(string3));
            }
        }
        return new DPoPTokenError(tokenSchemeError.getCode(), tokenSchemeError.getDescription(), tokenSchemeError.getHTTPStatusCode(), tokenSchemeError.getURI(), tokenSchemeError.getRealm(), tokenSchemeError.getScope(), hashSet);
    }
}

