/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.token;

import java.util.List;
import java.util.Map;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.ParseException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.Scope;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.token.AccessTokenType;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.token.BearerTokenError;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.token.DPoPTokenError;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.token.TokenSchemeError;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.token.TokenTypeURI;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.JSONObjectUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.MultivaluedMapUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.StringUtils;
import macromedia.jdbc.sqlserver.externals.net.minidev.json.JSONObject;

class AccessTokenUtils {
    static void parseAndEnsureType(JSONObject jSONObject, AccessTokenType accessTokenType) throws ParseException {
        if (!new AccessTokenType(JSONObjectUtils.getString(jSONObject, "token_type")).equals(accessTokenType)) {
            throw new ParseException("Token type must be " + accessTokenType);
        }
    }

    static String parseValue(JSONObject jSONObject) throws ParseException {
        return JSONObjectUtils.getString(jSONObject, "access_token");
    }

    static long parseLifetime(JSONObject jSONObject) throws ParseException {
        if (jSONObject.containsKey("expires_in")) {
            if (jSONObject.get("expires_in") instanceof Number) {
                return JSONObjectUtils.getLong(jSONObject, "expires_in");
            }
            String string = JSONObjectUtils.getString(jSONObject, "expires_in");
            try {
                return Long.parseLong(string);
            }
            catch (NumberFormatException numberFormatException) {
                throw new ParseException("Invalid expires_in parameter, must be integer");
            }
        }
        return 0L;
    }

    static Scope parseScope(JSONObject jSONObject) throws ParseException {
        return Scope.parse(JSONObjectUtils.getString(jSONObject, "scope", null));
    }

    static TokenTypeURI parseIssuedTokenType(JSONObject jSONObject) throws ParseException {
        String string = JSONObjectUtils.getString(jSONObject, "issued_token_type", null);
        if (string == null) {
            return null;
        }
        try {
            return TokenTypeURI.parse(string);
        }
        catch (ParseException parseException) {
            throw new ParseException("Invalid issued_token_type parameter: " + parseException.getMessage());
        }
    }

    private static void ensureSupported(AccessTokenType accessTokenType) {
        if (!AccessTokenType.BEARER.equals(accessTokenType) && !AccessTokenType.DPOP.equals(accessTokenType)) {
            throw new IllegalArgumentException("Unsupported access token type, must be Bearer or DPoP: " + accessTokenType);
        }
    }

    static String parseValueFromHeader(String string, AccessTokenType accessTokenType) throws ParseException {
        AccessTokenUtils.ensureSupported(accessTokenType);
        if (StringUtils.isBlank(string)) {
            TokenSchemeError tokenSchemeError = BearerTokenError.MISSING_TOKEN;
            if (AccessTokenType.DPOP.equals(accessTokenType)) {
                tokenSchemeError = DPoPTokenError.MISSING_TOKEN;
            }
            throw new ParseException("Missing HTTP Authorization header", tokenSchemeError);
        }
        String[] stringArray = string.split("\\s", 2);
        if (stringArray.length != 2) {
            TokenSchemeError tokenSchemeError = BearerTokenError.INVALID_REQUEST;
            if (AccessTokenType.DPOP.equals(accessTokenType)) {
                tokenSchemeError = DPoPTokenError.INVALID_REQUEST;
            }
            throw new ParseException("Invalid HTTP Authorization header value", tokenSchemeError);
        }
        if (!stringArray[0].equals(accessTokenType.getValue())) {
            TokenSchemeError tokenSchemeError = BearerTokenError.INVALID_REQUEST;
            if (AccessTokenType.DPOP.equals(accessTokenType)) {
                tokenSchemeError = DPoPTokenError.INVALID_TOKEN;
            }
            throw new ParseException("Token type must be Bearer", tokenSchemeError);
        }
        if (StringUtils.isBlank(stringArray[1])) {
            TokenSchemeError tokenSchemeError = BearerTokenError.INVALID_REQUEST;
            if (AccessTokenType.DPOP.equals(accessTokenType)) {
                tokenSchemeError = DPoPTokenError.INVALID_REQUEST;
            }
            throw new ParseException("The token value must not be null or empty string", tokenSchemeError);
        }
        return stringArray[1];
    }

    static String parseValueFromQueryParameters(Map<String, List<String>> map, AccessTokenType accessTokenType) throws ParseException {
        AccessTokenUtils.ensureSupported(accessTokenType);
        if (!map.containsKey("access_token")) {
            TokenSchemeError tokenSchemeError = BearerTokenError.MISSING_TOKEN;
            if (AccessTokenType.DPOP.equals(accessTokenType)) {
                tokenSchemeError = DPoPTokenError.MISSING_TOKEN;
            }
            throw new ParseException("Missing access token parameter", tokenSchemeError);
        }
        String string = MultivaluedMapUtils.getFirstValue(map, "access_token");
        if (StringUtils.isBlank(string)) {
            TokenSchemeError tokenSchemeError = BearerTokenError.INVALID_REQUEST;
            if (AccessTokenType.DPOP.equals(accessTokenType)) {
                tokenSchemeError = DPoPTokenError.INVALID_REQUEST;
            }
            throw new ParseException("Blank / empty access token", tokenSchemeError);
        }
        return string;
    }

    static String parseValueFromQueryParameters(Map<String, List<String>> map) throws ParseException {
        if (!map.containsKey("access_token")) {
            throw new ParseException("Missing access token parameter");
        }
        String string = MultivaluedMapUtils.getFirstValue(map, "access_token");
        if (StringUtils.isBlank(string)) {
            throw new ParseException("Blank / empty access token");
        }
        return string;
    }

    static AccessTokenType determineAccessTokenTypeFromAuthorizationHeader(String string) throws ParseException {
        if (StringUtils.isNotBlank(string)) {
            if (string.toLowerCase().startsWith(AccessTokenType.BEARER.getValue().toLowerCase() + " ")) {
                return AccessTokenType.BEARER;
            }
            if (string.toLowerCase().startsWith(AccessTokenType.DPOP.getValue().toLowerCase() + " ")) {
                return AccessTokenType.DPOP;
            }
        }
        throw new ParseException("Couldn't determine access token type from Authorization header");
    }

    private AccessTokenUtils() {
    }
}

