/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.id;

import java.net.URI;
import java.net.URISyntaxException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.id.Identifier;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.StringUtils;
import macromedia.jdbc.sqlserver.externals.net.jcip.annotations.Immutable;

@Immutable
public final class Issuer
extends Identifier {
    private static final long serialVersionUID = -8033463330193076151L;

    public static boolean isValid(String string) {
        if (string == null) {
            return false;
        }
        try {
            return Issuer.isValid(new URI(string));
        }
        catch (URISyntaxException uRISyntaxException) {
            return false;
        }
    }

    public static boolean isValid(Issuer issuer) {
        if (issuer == null) {
            return false;
        }
        try {
            return Issuer.isValid(new URI(issuer.getValue()));
        }
        catch (URISyntaxException uRISyntaxException) {
            return false;
        }
    }

    public static boolean isValid(URI uRI) {
        if (uRI == null) {
            return false;
        }
        if (uRI.getScheme() == null || !uRI.getScheme().equalsIgnoreCase("https")) {
            return false;
        }
        if (uRI.getRawQuery() != null) {
            return false;
        }
        return uRI.getRawFragment() == null;
    }

    public Issuer(String string) {
        super(string);
    }

    public Issuer(URI uRI) {
        super(uRI.toString());
    }

    public Issuer(Identifier identifier) {
        super(identifier.getValue());
    }

    public boolean isValid() {
        return Issuer.isValid(this);
    }

    @Override
    public boolean equals(Object object) {
        return object instanceof Issuer && this.toString().equals(object.toString());
    }

    public static Issuer parse(String string) {
        if (StringUtils.isBlank(string)) {
            return null;
        }
        return new Issuer(string);
    }
}

