/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.http;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.common.contenttype.ContentType;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.ParseException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.ContentTypeUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.MultivaluedMapUtils;

abstract class HTTPMessage {
    private final Map<String, List<String>> headers = new TreeMap<String, List<String>>(String.CASE_INSENSITIVE_ORDER);
    private String clientIPAddress;

    HTTPMessage() {
    }

    public ContentType getEntityContentType() {
        String string = this.getHeaderValue("Content-Type");
        if (string == null) {
            return null;
        }
        try {
            return ContentType.parse(string);
        }
        catch (java.text.ParseException parseException) {
            return null;
        }
    }

    public void setEntityContentType(ContentType contentType) {
        this.setHeader("Content-Type", contentType != null ? contentType.toString() : null);
    }

    public void setContentType(String string) throws ParseException {
        try {
            this.setHeader("Content-Type", string != null ? ContentType.parse(string).toString() : null);
        }
        catch (java.text.ParseException parseException) {
            throw new ParseException("Invalid Content-Type value: " + parseException.getMessage());
        }
    }

    public void ensureEntityContentType() throws ParseException {
        if (this.getEntityContentType() == null) {
            throw new ParseException("Missing HTTP Content-Type header");
        }
    }

    public void ensureEntityContentType(ContentType contentType) throws ParseException {
        ContentTypeUtils.ensureContentType(contentType, this.getEntityContentType());
    }

    public String getHeaderValue(String string) {
        return MultivaluedMapUtils.getFirstValue(this.headers, string);
    }

    public List<String> getHeaderValues(String string) {
        return this.headers.get(string);
    }

    public void setHeader(String string, String ... stringArray) {
        if (stringArray != null && stringArray.length > 0) {
            this.headers.put(string, Arrays.asList(stringArray));
        } else {
            this.headers.remove(string);
        }
    }

    public Map<String, List<String>> getHeaderMap() {
        return this.headers;
    }

    public String getClientIPAddress() {
        return this.clientIPAddress;
    }

    public void setClientIPAddress(String string) {
        this.clientIPAddress = string;
    }
}

