/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.assertions.saml2;

import java.util.Date;
import java.util.Set;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jwt.proc.ClockSkewAware;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jwt.util.DateUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.assertions.saml2.BadSAML2AssertionException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.assertions.saml2.SAML2AssertionDetails;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.id.Audience;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.CollectionUtils;
import macromedia.jdbc.sqlserver.externals.net.jcip.annotations.Immutable;

@Immutable
public class SAML2AssertionDetailsVerifier
implements ClockSkewAware {
    public static final int DEFAULT_MAX_CLOCK_SKEW_SECONDS = 60;
    private static final BadSAML2AssertionException EXPIRED_SAML2_ASSERTION_EXCEPTION = new BadSAML2AssertionException("Expired SAML 2.0 assertion");
    private static final BadSAML2AssertionException SAML2_ASSERTION_BEFORE_USE_EXCEPTION = new BadSAML2AssertionException("SAML 2.0 assertion before use time");
    private final Set<Audience> expectedAudience;
    private final BadSAML2AssertionException unexpectedAudienceException;
    private int maxClockSkewSeconds = 60;

    public SAML2AssertionDetailsVerifier(Set<Audience> set) {
        if (CollectionUtils.isEmpty(set)) {
            throw new IllegalArgumentException("The expected audience set must not be null or empty");
        }
        this.expectedAudience = set;
        this.unexpectedAudienceException = new BadSAML2AssertionException("Invalid SAML 2.0 audience, expected " + set);
    }

    public Set<Audience> getExpectedAudience() {
        return this.expectedAudience;
    }

    @Override
    public int getMaxClockSkew() {
        return this.maxClockSkewSeconds;
    }

    @Override
    public void setMaxClockSkew(int n2) {
        this.maxClockSkewSeconds = n2;
    }

    public void verify(SAML2AssertionDetails sAML2AssertionDetails) throws BadSAML2AssertionException {
        if (!Audience.matchesAny(this.expectedAudience, sAML2AssertionDetails.getAudience())) {
            throw this.unexpectedAudienceException;
        }
        Date date = new Date();
        if (!DateUtils.isAfter(sAML2AssertionDetails.getExpirationTime(), date, this.maxClockSkewSeconds)) {
            throw EXPIRED_SAML2_ASSERTION_EXCEPTION;
        }
        if (sAML2AssertionDetails.getNotBeforeTime() != null && !DateUtils.isBefore(sAML2AssertionDetails.getNotBeforeTime(), date, this.maxClockSkewSeconds)) {
            throw SAML2_ASSERTION_BEFORE_USE_EXCEPTION;
        }
    }
}

