/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk;

import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.common.contenttype.ContentType;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.AbstractOptionallyAuthenticatedRequest;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.AuthorizationRequest;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.OAuth2Error;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.ParseException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.SerializeException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.auth.ClientAuthentication;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.auth.ClientSecretBasic;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.http.HTTPRequest;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.MultivaluedMapUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.StringUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.URLUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.AuthenticationRequest;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.op.AuthenticationRequestDetector;
import macromedia.jdbc.sqlserver.externals.net.jcip.annotations.Immutable;

@Immutable
public class PushedAuthorizationRequest
extends AbstractOptionallyAuthenticatedRequest {
    private final AuthorizationRequest authzRequest;

    public PushedAuthorizationRequest(URI uRI, ClientAuthentication clientAuthentication, AuthorizationRequest authorizationRequest) {
        super(uRI, clientAuthentication);
        if (clientAuthentication == null) {
            throw new IllegalArgumentException("The client authentication must not be null");
        }
        if (authorizationRequest == null) {
            throw new IllegalArgumentException("The authorization request must not be null");
        }
        if (authorizationRequest.getRequestURI() != null) {
            throw new IllegalArgumentException("Authorization request_uri parameter not allowed");
        }
        this.authzRequest = authorizationRequest;
    }

    public PushedAuthorizationRequest(URI uRI, AuthorizationRequest authorizationRequest) {
        super(uRI, null);
        if (authorizationRequest == null) {
            throw new IllegalArgumentException("The authorization request must not be null");
        }
        if (authorizationRequest.getRequestURI() != null) {
            throw new IllegalArgumentException("Authorization request_uri parameter not allowed");
        }
        this.authzRequest = authorizationRequest;
    }

    public AuthorizationRequest getAuthorizationRequest() {
        return this.authzRequest;
    }

    @Override
    public HTTPRequest toHTTPRequest() {
        if (this.getEndpointURI() == null) {
            throw new SerializeException("The endpoint URI is not specified");
        }
        HTTPRequest hTTPRequest = new HTTPRequest(HTTPRequest.Method.POST, this.getEndpointURI());
        hTTPRequest.setEntityContentType(ContentType.APPLICATION_URLENCODED);
        if (this.getClientAuthentication() != null) {
            this.getClientAuthentication().applyTo(hTTPRequest);
        }
        Map<String, List<String>> map = hTTPRequest.getQueryParameters();
        map.putAll(this.authzRequest.toParameters());
        hTTPRequest.setQuery(URLUtils.serializeParameters(map));
        return hTTPRequest;
    }

    public static PushedAuthorizationRequest parse(HTTPRequest hTTPRequest) throws ParseException {
        AuthorizationRequest authorizationRequest;
        ClientAuthentication clientAuthentication;
        URI uRI = hTTPRequest.getURI();
        hTTPRequest.ensureMethod(HTTPRequest.Method.POST);
        hTTPRequest.ensureEntityContentType(ContentType.APPLICATION_URLENCODED);
        try {
            clientAuthentication = ClientAuthentication.parse(hTTPRequest);
        }
        catch (ParseException parseException) {
            throw new ParseException(parseException.getMessage(), OAuth2Error.INVALID_REQUEST.appendDescription(": " + parseException.getMessage()));
        }
        Map<String, List<String>> map = hTTPRequest.getQueryParameters();
        if (clientAuthentication instanceof ClientSecretBasic && (StringUtils.isNotBlank(MultivaluedMapUtils.getFirstValue(map, "client_assertion")) || StringUtils.isNotBlank(MultivaluedMapUtils.getFirstValue(map, "client_assertion_type")))) {
            String string = "Multiple conflicting client authentication methods found: Basic and JWT assertion";
            throw new ParseException(string, OAuth2Error.INVALID_REQUEST.appendDescription(": " + string));
        }
        if (!map.containsKey("client_id") && clientAuthentication != null) {
            map.put("client_id", Collections.singletonList(clientAuthentication.getClientID().getValue()));
        }
        if ((authorizationRequest = AuthenticationRequestDetector.isLikelyOpenID(map) ? AuthenticationRequest.parse(map) : AuthorizationRequest.parse(map)).getRequestURI() != null) {
            String string = "Authorization request_uri parameter not allowed";
            throw new ParseException(string, OAuth2Error.INVALID_REQUEST.appendDescription(": " + string));
        }
        if (clientAuthentication != null) {
            return new PushedAuthorizationRequest(uRI, clientAuthentication, authorizationRequest);
        }
        return new PushedAuthorizationRequest(uRI, authorizationRequest);
    }
}

