/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk;

import java.util.List;
import java.util.Map;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.AuthorizationCodeGrant;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.ClientCredentialsGrant;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.GrantType;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.JWTBearerGrant;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.OAuth2Error;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.ParseException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.RefreshTokenGrant;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.ResourceOwnerPasswordCredentialsGrant;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.SAML2BearerGrant;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.ciba.CIBAGrant;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.device.DeviceCodeGrant;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.tokenexchange.TokenExchangeGrant;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.MultivaluedMapUtils;

public abstract class AuthorizationGrant {
    private final GrantType type;

    protected AuthorizationGrant(GrantType grantType) {
        if (grantType == null) {
            throw new IllegalArgumentException("The grant type must not be null");
        }
        this.type = grantType;
    }

    public GrantType getType() {
        return this.type;
    }

    public abstract Map<String, List<String>> toParameters();

    public static AuthorizationGrant parse(Map<String, List<String>> map) throws ParseException {
        GrantType grantType;
        String string = MultivaluedMapUtils.getFirstValue(map, "grant_type");
        if (string == null) {
            String string2 = "Missing grant_type parameter";
            throw new ParseException(string2, OAuth2Error.INVALID_REQUEST.appendDescription(": " + string2));
        }
        try {
            grantType = GrantType.parse(string);
        }
        catch (ParseException parseException) {
            String string3 = "Invalid grant type: " + parseException.getMessage();
            throw new ParseException(string3, OAuth2Error.UNSUPPORTED_GRANT_TYPE.appendDescription(": " + string3));
        }
        if (grantType.equals(GrantType.AUTHORIZATION_CODE)) {
            return AuthorizationCodeGrant.parse(map);
        }
        if (grantType.equals(GrantType.REFRESH_TOKEN)) {
            return RefreshTokenGrant.parse(map);
        }
        if (grantType.equals(GrantType.PASSWORD)) {
            return ResourceOwnerPasswordCredentialsGrant.parse(map);
        }
        if (grantType.equals(GrantType.CLIENT_CREDENTIALS)) {
            return ClientCredentialsGrant.parse(map);
        }
        if (grantType.equals(GrantType.JWT_BEARER)) {
            return JWTBearerGrant.parse(map);
        }
        if (grantType.equals(GrantType.SAML2_BEARER)) {
            return SAML2BearerGrant.parse(map);
        }
        if (grantType.equals(GrantType.DEVICE_CODE)) {
            return DeviceCodeGrant.parse(map);
        }
        if (grantType.equals(GrantType.CIBA)) {
            return CIBAGrant.parse(map);
        }
        if (grantType.equals(GrantType.TOKEN_EXCHANGE)) {
            return TokenExchangeGrant.parse(map);
        }
        throw new ParseException("Invalid or unsupported grant type: " + grantType, OAuth2Error.UNSUPPORTED_GRANT_TYPE);
    }
}

