/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.jwt.proc;

import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.SequencedCollection;
import java.util.Set;
import java.util.TreeSet;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.proc.SecurityContext;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jwt.JWTClaimsSet;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jwt.proc.BadJWTException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jwt.proc.ClockSkewAware;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jwt.proc.JWTClaimsSetVerifier;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jwt.util.DateUtils;
import macromedia.jdbc.sqlserver.externals.net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class DefaultJWTClaimsVerifier<C extends SecurityContext>
implements ClockSkewAware,
JWTClaimsSetVerifier<C> {
    public static final int DEFAULT_MAX_CLOCK_SKEW_SECONDS = 60;
    private int maxClockSkew = 60;
    private final Set<String> acceptedAudienceValues;
    private final JWTClaimsSet exactMatchClaims;
    private final Set<String> requiredClaims;
    private final Set<String> prohibitedClaims;

    @Deprecated
    public DefaultJWTClaimsVerifier() {
        this(null, null, null, null);
    }

    public DefaultJWTClaimsVerifier(JWTClaimsSet jWTClaimsSet, Set<String> set) {
        this(null, jWTClaimsSet, set, null);
    }

    public DefaultJWTClaimsVerifier(String string, JWTClaimsSet jWTClaimsSet, Set<String> set) {
        this(string != null ? Collections.singleton(string) : null, jWTClaimsSet, set, null);
    }

    public DefaultJWTClaimsVerifier(Set<String> set, JWTClaimsSet jWTClaimsSet, Set<String> set2, Set<String> set3) {
        this.acceptedAudienceValues = set != null ? Collections.unmodifiableSet(set) : null;
        this.exactMatchClaims = jWTClaimsSet != null ? jWTClaimsSet : new JWTClaimsSet.Builder().build();
        HashSet<String> hashSet = new HashSet<String>(this.exactMatchClaims.getClaims().keySet());
        if (this.acceptedAudienceValues != null && !this.acceptedAudienceValues.contains(null)) {
            hashSet.add("aud");
        }
        if (set2 != null) {
            hashSet.addAll(set2);
        }
        this.requiredClaims = Collections.unmodifiableSet(hashSet);
        this.prohibitedClaims = set3 != null ? Collections.unmodifiableSet(set3) : Collections.emptySet();
    }

    public Set<String> getAcceptedAudienceValues() {
        return this.acceptedAudienceValues;
    }

    public JWTClaimsSet getExactMatchClaims() {
        return this.exactMatchClaims;
    }

    public Set<String> getRequiredClaims() {
        return this.requiredClaims;
    }

    public Set<String> getProhibitedClaims() {
        return this.prohibitedClaims;
    }

    @Override
    public int getMaxClockSkew() {
        return this.maxClockSkew;
    }

    @Override
    public void setMaxClockSkew(int n2) {
        this.maxClockSkew = n2;
    }

    @Override
    public void verify(JWTClaimsSet jWTClaimsSet, C c2) throws BadJWTException {
        SequencedCollection<String> sequencedCollection;
        if (this.acceptedAudienceValues != null) {
            sequencedCollection = jWTClaimsSet.getAudience();
            if (sequencedCollection != null && !sequencedCollection.isEmpty()) {
                boolean bl2 = false;
                for (String string : sequencedCollection) {
                    if (!this.acceptedAudienceValues.contains(string)) continue;
                    bl2 = true;
                    break;
                }
                if (!bl2) {
                    throw new BadJWTException("JWT audience rejected: " + sequencedCollection);
                }
            } else if (!this.acceptedAudienceValues.contains(null)) {
                throw new BadJWTException("JWT missing required audience");
            }
        }
        if (!jWTClaimsSet.getClaims().keySet().containsAll(this.requiredClaims)) {
            sequencedCollection = new TreeSet<String>(this.requiredClaims);
            sequencedCollection.removeAll(jWTClaimsSet.getClaims().keySet());
            throw new BadJWTException("JWT missing required claims: " + sequencedCollection);
        }
        sequencedCollection = new TreeSet();
        for (String string : this.prohibitedClaims) {
            if (!jWTClaimsSet.getClaims().containsKey(string)) continue;
            sequencedCollection.add(string);
        }
        if (!sequencedCollection.isEmpty()) {
            throw new BadJWTException("JWT has prohibited claims: " + sequencedCollection);
        }
        for (String string : this.exactMatchClaims.getClaims().keySet()) {
            Object object;
            Object object2 = jWTClaimsSet.getClaim(string);
            if (object2.equals(object = this.exactMatchClaims.getClaim(string))) continue;
            throw new BadJWTException("JWT " + string + " claim has value " + object2 + ", must be " + object);
        }
        Date date = this.currentTime();
        if (date != null) {
            Date date2 = jWTClaimsSet.getExpirationTime();
            if (date2 != null && !DateUtils.isAfter(date2, date, this.maxClockSkew)) {
                throw new BadJWTException("Expired JWT");
            }
            Date date3 = jWTClaimsSet.getNotBeforeTime();
            if (date3 != null && !DateUtils.isBefore(date3, date, this.maxClockSkew)) {
                throw new BadJWTException("JWT before use time");
            }
        }
    }

    protected Date currentTime() {
        return new Date();
    }
}

