/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.jwt;

import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.Payload;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.util.JSONArrayUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.util.JSONObjectUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jwt.JWTClaimsSetTransformer;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jwt.util.DateUtils;
import macromedia.jdbc.sqlserver.externals.net.jcip.annotations.Immutable;

@Immutable
public final class JWTClaimsSet
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Set<String> REGISTERED_CLAIM_NAMES;
    private final Map<String, Object> claims = new LinkedHashMap<String, Object>();

    private JWTClaimsSet(Map<String, Object> map) {
        this.claims.putAll(map);
    }

    public static Set<String> getRegisteredNames() {
        return REGISTERED_CLAIM_NAMES;
    }

    public String getIssuer() {
        try {
            return this.getStringClaim("iss");
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    public String getSubject() {
        try {
            return this.getStringClaim("sub");
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    public List<String> getAudience() {
        List<String> list;
        Object object = this.getClaim("aud");
        if (object instanceof String) {
            return Collections.singletonList((String)object);
        }
        try {
            list = this.getStringListClaim("aud");
        }
        catch (ParseException parseException) {
            return Collections.emptyList();
        }
        return list != null ? list : Collections.emptyList();
    }

    public Date getExpirationTime() {
        try {
            return this.getDateClaim("exp");
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    public Date getNotBeforeTime() {
        try {
            return this.getDateClaim("nbf");
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    public Date getIssueTime() {
        try {
            return this.getDateClaim("iat");
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    public String getJWTID() {
        try {
            return this.getStringClaim("jti");
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    public Object getClaim(String string) {
        return this.claims.get(string);
    }

    public String getStringClaim(String string) throws ParseException {
        Object object = this.getClaim(string);
        if (object == null || object instanceof String) {
            return (String)object;
        }
        throw new ParseException("The " + string + " claim is not a String", 0);
    }

    public String[] getStringArrayClaim(String string) throws ParseException {
        List list;
        Object object = this.getClaim(string);
        if (object == null) {
            return null;
        }
        try {
            list = (List)this.getClaim(string);
        }
        catch (ClassCastException classCastException) {
            throw new ParseException("The " + string + " claim is not a list / JSON array", 0);
        }
        String[] stringArray = new String[list.size()];
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            try {
                stringArray[i2] = (String)list.get(i2);
                continue;
            }
            catch (ClassCastException classCastException) {
                throw new ParseException("The " + string + " claim is not a list / JSON array of strings", 0);
            }
        }
        return stringArray;
    }

    public List<String> getStringListClaim(String string) throws ParseException {
        String[] stringArray = this.getStringArrayClaim(string);
        if (stringArray == null) {
            return null;
        }
        return Collections.unmodifiableList(Arrays.asList(stringArray));
    }

    public URI getURIClaim(String string) throws ParseException {
        String string2 = this.getStringClaim(string);
        if (string2 == null) {
            return null;
        }
        try {
            return new URI(string2);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new ParseException("The \"" + string + "\" claim is not a URI: " + uRISyntaxException.getMessage(), 0);
        }
    }

    public Boolean getBooleanClaim(String string) throws ParseException {
        Object object = this.getClaim(string);
        if (object == null || object instanceof Boolean) {
            return (Boolean)object;
        }
        throw new ParseException("The \"" + string + "\" claim is not a Boolean", 0);
    }

    public Integer getIntegerClaim(String string) throws ParseException {
        Object object = this.getClaim(string);
        if (object == null) {
            return null;
        }
        if (object instanceof Number) {
            return ((Number)object).intValue();
        }
        throw new ParseException("The \"" + string + "\" claim is not an Integer", 0);
    }

    public Long getLongClaim(String string) throws ParseException {
        Object object = this.getClaim(string);
        if (object == null) {
            return null;
        }
        if (object instanceof Number) {
            return ((Number)object).longValue();
        }
        throw new ParseException("The \"" + string + "\" claim is not a Number", 0);
    }

    public Date getDateClaim(String string) throws ParseException {
        Object object = this.getClaim(string);
        if (object == null) {
            return null;
        }
        if (object instanceof Date) {
            return (Date)object;
        }
        if (object instanceof Number) {
            return DateUtils.fromSecondsSinceEpoch(((Number)object).longValue());
        }
        throw new ParseException("The \"" + string + "\" claim is not a Date", 0);
    }

    public Float getFloatClaim(String string) throws ParseException {
        Object object = this.getClaim(string);
        if (object == null) {
            return null;
        }
        if (object instanceof Number) {
            return Float.valueOf(((Number)object).floatValue());
        }
        throw new ParseException("The \"" + string + "\" claim is not a Float", 0);
    }

    public Double getDoubleClaim(String string) throws ParseException {
        Object object = this.getClaim(string);
        if (object == null) {
            return null;
        }
        if (object instanceof Number) {
            return ((Number)object).doubleValue();
        }
        throw new ParseException("The \"" + string + "\" claim is not a Double", 0);
    }

    public Map<String, Object> getJSONObjectClaim(String string) throws ParseException {
        Object object = this.getClaim(string);
        if (object == null) {
            return null;
        }
        if (object instanceof Map) {
            Map<String, Object> map = JSONObjectUtils.newJSONObject();
            Map map2 = (Map)object;
            for (Map.Entry entry : map2.entrySet()) {
                if (!(entry.getKey() instanceof String)) continue;
                map.put((String)entry.getKey(), entry.getValue());
            }
            return map;
        }
        throw new ParseException("The \"" + string + "\" claim is not a JSON object or Map", 0);
    }

    public Map<String, Object> getClaims() {
        return Collections.unmodifiableMap(this.claims);
    }

    public Payload toPayload() {
        return new Payload(this.toJSONObject());
    }

    public Map<String, Object> toJSONObject() {
        return this.toJSONObject(false);
    }

    public Map<String, Object> toJSONObject(boolean bl2) {
        Map<String, Object> map = JSONObjectUtils.newJSONObject();
        for (Map.Entry<String, Object> entry : this.claims.entrySet()) {
            List<String> list;
            if (entry.getValue() instanceof Date) {
                list = (Date)entry.getValue();
                map.put(entry.getKey(), DateUtils.toSecondsSinceEpoch((Date)((Object)list)));
                continue;
            }
            if ("aud".equals(entry.getKey())) {
                list = this.getAudience();
                if (list != null && !list.isEmpty()) {
                    if (list.size() == 1) {
                        map.put("aud", list.get(0));
                        continue;
                    }
                    List<Object> list2 = JSONArrayUtils.newJSONArray();
                    list2.addAll((Collection<Object>)list);
                    map.put("aud", list2);
                    continue;
                }
                if (!bl2) continue;
                map.put("aud", null);
                continue;
            }
            if (entry.getValue() != null) {
                map.put(entry.getKey(), entry.getValue());
                continue;
            }
            if (!bl2) continue;
            map.put(entry.getKey(), null);
        }
        return map;
    }

    public String toString() {
        return JSONObjectUtils.toJSONString(this.toJSONObject());
    }

    public String toString(boolean bl2) {
        return JSONObjectUtils.toJSONString(this.toJSONObject(bl2));
    }

    public <T> T toType(JWTClaimsSetTransformer<T> jWTClaimsSetTransformer) {
        return jWTClaimsSetTransformer.transform(this);
    }

    public static JWTClaimsSet parse(Map<String, Object> map) throws ParseException {
        Builder builder = new Builder();
        Iterator<String> iterator = map.keySet().iterator();
        block18: while (iterator.hasNext()) {
            String string;
            switch (string = iterator.next()) {
                case "iss": {
                    builder.issuer(JSONObjectUtils.getString(map, "iss"));
                    continue block18;
                }
                case "sub": {
                    builder.subject(JSONObjectUtils.getString(map, "sub"));
                    continue block18;
                }
                case "aud": {
                    Object object = map.get("aud");
                    if (object instanceof String) {
                        ArrayList<String> arrayList = new ArrayList<String>();
                        arrayList.add(JSONObjectUtils.getString(map, "aud"));
                        builder.audience(arrayList);
                        continue block18;
                    }
                    if (object instanceof List) {
                        builder.audience(JSONObjectUtils.getStringList(map, "aud"));
                        continue block18;
                    }
                    if (object != null) continue block18;
                    builder.audience((String)null);
                    continue block18;
                }
                case "exp": {
                    builder.expirationTime(new Date(JSONObjectUtils.getLong(map, "exp") * 1000L));
                    continue block18;
                }
                case "nbf": {
                    builder.notBeforeTime(new Date(JSONObjectUtils.getLong(map, "nbf") * 1000L));
                    continue block18;
                }
                case "iat": {
                    builder.issueTime(new Date(JSONObjectUtils.getLong(map, "iat") * 1000L));
                    continue block18;
                }
                case "jti": {
                    builder.jwtID(JSONObjectUtils.getString(map, "jti"));
                    continue block18;
                }
            }
            builder.claim(string, map.get(string));
        }
        return builder.build();
    }

    public static JWTClaimsSet parse(String string) throws ParseException {
        return JWTClaimsSet.parse(JSONObjectUtils.parse(string));
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof JWTClaimsSet)) {
            return false;
        }
        JWTClaimsSet jWTClaimsSet = (JWTClaimsSet)object;
        return Objects.equals(this.claims, jWTClaimsSet.claims);
    }

    public int hashCode() {
        return Objects.hash(this.claims);
    }

    static {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("iss");
        hashSet.add("sub");
        hashSet.add("aud");
        hashSet.add("exp");
        hashSet.add("nbf");
        hashSet.add("iat");
        hashSet.add("jti");
        REGISTERED_CLAIM_NAMES = Collections.unmodifiableSet(hashSet);
    }

    public static class Builder {
        private final Map<String, Object> claims = new LinkedHashMap<String, Object>();

        public Builder() {
        }

        public Builder(JWTClaimsSet jWTClaimsSet) {
            this.claims.putAll(jWTClaimsSet.claims);
        }

        public Builder issuer(String string) {
            this.claims.put("iss", string);
            return this;
        }

        public Builder subject(String string) {
            this.claims.put("sub", string);
            return this;
        }

        public Builder audience(List<String> list) {
            this.claims.put("aud", list);
            return this;
        }

        public Builder audience(String string) {
            if (string == null) {
                this.claims.put("aud", null);
            } else {
                this.claims.put("aud", Collections.singletonList(string));
            }
            return this;
        }

        public Builder expirationTime(Date date) {
            this.claims.put("exp", date);
            return this;
        }

        public Builder notBeforeTime(Date date) {
            this.claims.put("nbf", date);
            return this;
        }

        public Builder issueTime(Date date) {
            this.claims.put("iat", date);
            return this;
        }

        public Builder jwtID(String string) {
            this.claims.put("jti", string);
            return this;
        }

        public Builder claim(String string, Object object) {
            this.claims.put(string, object);
            return this;
        }

        public Map<String, Object> getClaims() {
            return Collections.unmodifiableMap(this.claims);
        }

        public JWTClaimsSet build() {
            return new JWTClaimsSet(this.claims);
        }
    }
}

