/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.util;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.shaded.json.JSONObject;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.shaded.json.parser.JSONParser;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.shaded.json.parser.ParseException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.util.Base64URL;

public class JSONObjectUtils {
    public static Map<String, Object> parse(String string) throws java.text.ParseException {
        return JSONObjectUtils.parse(string, -1);
    }

    public static Map<String, Object> parse(String string, int n2) throws java.text.ParseException {
        Object object;
        if (n2 >= 0 && string.length() > n2) {
            throw new java.text.ParseException("The parsed string is longer than the max accepted size of " + n2 + " characters", 0);
        }
        try {
            object = new JSONParser(640).parse(string);
        }
        catch (ParseException parseException) {
            throw new java.text.ParseException("Invalid JSON: " + parseException.getMessage(), 0);
        }
        catch (Exception exception) {
            throw new java.text.ParseException("Unexpected exception: " + exception.getMessage(), 0);
        }
        catch (StackOverflowError stackOverflowError) {
            throw new java.text.ParseException("Excessive JSON object and / or array nesting", 0);
        }
        if (object instanceof JSONObject) {
            return (JSONObject)object;
        }
        throw new java.text.ParseException("JSON entity is not an object", 0);
    }

    @Deprecated
    public static Map<String, Object> parseJSONObject(String string) throws java.text.ParseException {
        return JSONObjectUtils.parse(string);
    }

    private static <T> T getGeneric(Map<String, Object> map, String string, Class<T> clazz) throws java.text.ParseException {
        if (map.get(string) == null) {
            return null;
        }
        Object object = map.get(string);
        if (!clazz.isAssignableFrom(object.getClass())) {
            throw new java.text.ParseException("Unexpected type of JSON object member with key " + string + "", 0);
        }
        Object object2 = object;
        return (T)object2;
    }

    public static boolean getBoolean(Map<String, Object> map, String string) throws java.text.ParseException {
        Boolean bl2 = JSONObjectUtils.getGeneric(map, string, Boolean.class);
        if (bl2 == null) {
            throw new java.text.ParseException("JSON object member with key " + string + " is missing or null", 0);
        }
        return bl2;
    }

    public static int getInt(Map<String, Object> map, String string) throws java.text.ParseException {
        Number number = JSONObjectUtils.getGeneric(map, string, Number.class);
        if (number == null) {
            throw new java.text.ParseException("JSON object member with key " + string + " is missing or null", 0);
        }
        return number.intValue();
    }

    public static long getLong(Map<String, Object> map, String string) throws java.text.ParseException {
        Number number = JSONObjectUtils.getGeneric(map, string, Number.class);
        if (number == null) {
            throw new java.text.ParseException("JSON object member with key " + string + " is missing or null", 0);
        }
        return number.longValue();
    }

    public static float getFloat(Map<String, Object> map, String string) throws java.text.ParseException {
        Number number = JSONObjectUtils.getGeneric(map, string, Number.class);
        if (number == null) {
            throw new java.text.ParseException("JSON object member with key " + string + " is missing or null", 0);
        }
        return number.floatValue();
    }

    public static double getDouble(Map<String, Object> map, String string) throws java.text.ParseException {
        Number number = JSONObjectUtils.getGeneric(map, string, Number.class);
        if (number == null) {
            throw new java.text.ParseException("JSON object member with key " + string + " is missing or null", 0);
        }
        return number.doubleValue();
    }

    public static String getString(Map<String, Object> map, String string) throws java.text.ParseException {
        return JSONObjectUtils.getGeneric(map, string, String.class);
    }

    public static URI getURI(Map<String, Object> map, String string) throws java.text.ParseException {
        String string2 = JSONObjectUtils.getString(map, string);
        if (string2 == null) {
            return null;
        }
        try {
            return new URI(string2);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new java.text.ParseException(uRISyntaxException.getMessage(), 0);
        }
    }

    public static List<Object> getJSONArray(Map<String, Object> map, String string) throws java.text.ParseException {
        List list = JSONObjectUtils.getGeneric(map, string, List.class);
        return list;
    }

    public static String[] getStringArray(Map<String, Object> map, String string) throws java.text.ParseException {
        List<Object> list = JSONObjectUtils.getJSONArray(map, string);
        if (list == null) {
            return null;
        }
        try {
            return list.toArray(new String[0]);
        }
        catch (ArrayStoreException arrayStoreException) {
            throw new java.text.ParseException("JSON object member with key \"" + string + "\" is not an array of strings", 0);
        }
    }

    public static Map<String, Object>[] getJSONObjectArray(Map<String, Object> map, String string) throws java.text.ParseException {
        List<Object> list = JSONObjectUtils.getJSONArray(map, string);
        if (list == null) {
            return null;
        }
        try {
            return list.toArray(new HashMap[0]);
        }
        catch (ArrayStoreException arrayStoreException) {
            throw new java.text.ParseException("JSON object member with key \"" + string + "\" is not an array of JSON objects", 0);
        }
    }

    public static List<String> getStringList(Map<String, Object> map, String string) throws java.text.ParseException {
        String[] stringArray = JSONObjectUtils.getStringArray(map, string);
        if (stringArray == null) {
            return null;
        }
        return Arrays.asList(stringArray);
    }

    public static Map<String, Object> getJSONObject(Map<String, Object> map, String string) throws java.text.ParseException {
        Map map2 = JSONObjectUtils.getGeneric(map, string, Map.class);
        if (map2 == null) {
            return null;
        }
        for (Object k2 : map2.keySet()) {
            if (k2 instanceof String) continue;
            throw new java.text.ParseException("JSON object member with key " + string + " not a JSON object", 0);
        }
        Map map3 = map2;
        return map3;
    }

    public static Base64URL getBase64URL(Map<String, Object> map, String string) throws java.text.ParseException {
        String string2 = JSONObjectUtils.getString(map, string);
        if (string2 == null) {
            return null;
        }
        return new Base64URL(string2);
    }

    public static String toJSONString(Map<String, ?> map) {
        return JSONObject.toJSONString(map);
    }

    public static Map<String, Object> newJSONObject() {
        return new HashMap<String, Object>();
    }

    private JSONObjectUtils() {
    }
}

