/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.shaded.json;

import java.io.IOException;

class JStylerObj {
    public static final MPSimple MP_SIMPLE = new MPSimple();
    public static final MPTrue MP_TRUE = new MPTrue();
    public static final MPAgressive MP_AGGRESIVE = new MPAgressive();
    public static final EscapeLT ESCAPE_LT = new EscapeLT();
    public static final Escape4Web ESCAPE4Web = new Escape4Web();

    JStylerObj() {
    }

    public static boolean isSpace(char c2) {
        return c2 == '\r' || c2 == '\n' || c2 == '\t' || c2 == ' ';
    }

    public static boolean isSpecialChar(char c2) {
        return c2 == '\b' || c2 == '\f' || c2 == '\n';
    }

    public static boolean isSpecialOpen(char c2) {
        return c2 == '{' || c2 == '[' || c2 == ',' || c2 == ':';
    }

    public static boolean isSpecialClose(char c2) {
        return c2 == '}' || c2 == ']' || c2 == ',' || c2 == ':';
    }

    public static boolean isSpecial(char c2) {
        return c2 == '{' || c2 == '[' || c2 == ',' || c2 == '}' || c2 == ']' || c2 == ':' || c2 == '\'' || c2 == '\"';
    }

    public static boolean isUnicode(char c2) {
        return c2 >= '\u0000' && c2 <= '\u001f' || c2 >= '\u007f' && c2 <= '\u009f' || c2 >= '\u2000' && c2 <= '\u20ff';
    }

    public static boolean isKeyword(String string) {
        if (string.length() < 3) {
            return false;
        }
        char c2 = string.charAt(0);
        if (c2 == 'n') {
            return string.equals("null");
        }
        if (c2 == 't') {
            return string.equals("true");
        }
        if (c2 == 'f') {
            return string.equals("false");
        }
        if (c2 == 'N') {
            return string.equals("NaN");
        }
        return false;
    }

    private static class Escape4Web
    implements StringProtector {
        private Escape4Web() {
        }

        @Override
        public void escape(String string, Appendable appendable) {
            try {
                int n2 = string.length();
                block12: for (int i2 = 0; i2 < n2; ++i2) {
                    char c2 = string.charAt(i2);
                    switch (c2) {
                        case '\"': {
                            appendable.append("\\\"");
                            continue block12;
                        }
                        case '\\': {
                            appendable.append("\\\\");
                            continue block12;
                        }
                        case '\b': {
                            appendable.append("\\b");
                            continue block12;
                        }
                        case '\f': {
                            appendable.append("\\f");
                            continue block12;
                        }
                        case '\n': {
                            appendable.append("\\n");
                            continue block12;
                        }
                        case '\r': {
                            appendable.append("\\r");
                            continue block12;
                        }
                        case '\t': {
                            appendable.append("\\t");
                            continue block12;
                        }
                        case '/': {
                            appendable.append("\\/");
                            continue block12;
                        }
                        default: {
                            if (c2 >= '\u0000' && c2 <= '\u001f' || c2 >= '\u007f' && c2 <= '\u009f' || c2 >= '\u2000' && c2 <= '\u20ff') {
                                appendable.append("\\u");
                                String string2 = "0123456789ABCDEF";
                                appendable.append(string2.charAt(c2 >> 12 & 0xF));
                                appendable.append(string2.charAt(c2 >> 8 & 0xF));
                                appendable.append(string2.charAt(c2 >> 4 & 0xF));
                                appendable.append(string2.charAt(c2 >> 0 & 0xF));
                                continue block12;
                            }
                            appendable.append(c2);
                        }
                    }
                }
            }
            catch (IOException iOException) {
                throw new RuntimeException("Impossible Error");
            }
        }
    }

    private static class EscapeLT
    implements StringProtector {
        private EscapeLT() {
        }

        @Override
        public void escape(String string, Appendable appendable) {
            try {
                int n2 = string.length();
                block11: for (int i2 = 0; i2 < n2; ++i2) {
                    char c2 = string.charAt(i2);
                    switch (c2) {
                        case '\"': {
                            appendable.append("\\\"");
                            continue block11;
                        }
                        case '\\': {
                            appendable.append("\\\\");
                            continue block11;
                        }
                        case '\b': {
                            appendable.append("\\b");
                            continue block11;
                        }
                        case '\f': {
                            appendable.append("\\f");
                            continue block11;
                        }
                        case '\n': {
                            appendable.append("\\n");
                            continue block11;
                        }
                        case '\r': {
                            appendable.append("\\r");
                            continue block11;
                        }
                        case '\t': {
                            appendable.append("\\t");
                            continue block11;
                        }
                        default: {
                            if (c2 >= '\u0000' && c2 <= '\u001f' || c2 >= '\u007f' && c2 <= '\u009f' || c2 >= '\u2000' && c2 <= '\u20ff') {
                                appendable.append("\\u");
                                String string2 = "0123456789ABCDEF";
                                appendable.append(string2.charAt(c2 >> 12 & 0xF));
                                appendable.append(string2.charAt(c2 >> 8 & 0xF));
                                appendable.append(string2.charAt(c2 >> 4 & 0xF));
                                appendable.append(string2.charAt(c2 >> 0 & 0xF));
                                continue block11;
                            }
                            appendable.append(c2);
                        }
                    }
                }
            }
            catch (IOException iOException) {
                throw new RuntimeException("Impossible Exception");
            }
        }
    }

    public static interface StringProtector {
        public void escape(String var1, Appendable var2);
    }

    private static class MPAgressive
    implements MustProtect {
        private MPAgressive() {
        }

        @Override
        public boolean mustBeProtect(String string) {
            int n2;
            if (string == null) {
                return false;
            }
            int n3 = string.length();
            if (n3 == 0) {
                return true;
            }
            if (string.trim() != string) {
                return true;
            }
            char c2 = string.charAt(0);
            if (JStylerObj.isSpecial(c2) || JStylerObj.isUnicode(c2)) {
                return true;
            }
            for (n2 = 1; n2 < n3; ++n2) {
                c2 = string.charAt(n2);
                if (!JStylerObj.isSpecialClose(c2) && !JStylerObj.isUnicode(c2)) continue;
                return true;
            }
            if (JStylerObj.isKeyword(string)) {
                return true;
            }
            c2 = string.charAt(0);
            if (c2 >= '0' && c2 <= '9' || c2 == '-') {
                for (n2 = 1; n2 < n3 && (c2 = string.charAt(n2)) >= '0' && c2 <= '9'; ++n2) {
                }
                if (n2 == n3) {
                    return true;
                }
                if (c2 == '.') {
                    ++n2;
                }
                while (n2 < n3 && (c2 = string.charAt(n2)) >= '0' && c2 <= '9') {
                    ++n2;
                }
                if (n2 == n3) {
                    return true;
                }
                if (c2 == 'E' || c2 == 'e') {
                    if (++n2 == n3) {
                        return false;
                    }
                    c2 = string.charAt(n2);
                    if (c2 == '+' || c2 == '-') {
                        c2 = string.charAt(++n2);
                    }
                }
                if (n2 == n3) {
                    return false;
                }
                while (n2 < n3 && (c2 = string.charAt(n2)) >= '0' && c2 <= '9') {
                    ++n2;
                }
                return n2 == n3;
            }
            return false;
        }
    }

    private static class MPSimple
    implements MustProtect {
        private MPSimple() {
        }

        @Override
        public boolean mustBeProtect(String string) {
            if (string == null) {
                return false;
            }
            int n2 = string.length();
            if (n2 == 0) {
                return true;
            }
            if (string.trim() != string) {
                return true;
            }
            char c2 = string.charAt(0);
            if (c2 >= '0' && c2 <= '9' || c2 == '-') {
                return true;
            }
            for (int i2 = 0; i2 < n2; ++i2) {
                c2 = string.charAt(i2);
                if (JStylerObj.isSpace(c2)) {
                    return true;
                }
                if (JStylerObj.isSpecial(c2)) {
                    return true;
                }
                if (JStylerObj.isSpecialChar(c2)) {
                    return true;
                }
                if (!JStylerObj.isUnicode(c2)) continue;
                return true;
            }
            return JStylerObj.isKeyword(string);
        }
    }

    private static class MPTrue
    implements MustProtect {
        private MPTrue() {
        }

        @Override
        public boolean mustBeProtect(String string) {
            return true;
        }
    }

    public static interface MustProtect {
        public boolean mustBeProtect(String var1);
    }
}

