/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.proc;

import java.security.Key;
import java.security.PublicKey;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.crypto.SecretKey;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JWSAlgorithm;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JWSHeader;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.KeySourceException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.JWK;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.JWKMatcher;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.JWKSelector;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.KeyConverter;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.source.JWKSource;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.proc.AbstractJWKSelectorWithSource;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.proc.JWSKeySelector;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.proc.SecurityContext;
import macromedia.jdbc.sqlserver.externals.net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class JWSVerificationKeySelector<C extends SecurityContext>
extends AbstractJWKSelectorWithSource<C>
implements JWSKeySelector<C> {
    private final Set<JWSAlgorithm> jwsAlgs;
    private final boolean singleJwsAlgConstructorWasCalled;

    public JWSVerificationKeySelector(JWSAlgorithm jWSAlgorithm, JWKSource<C> jWKSource) {
        super(jWKSource);
        if (jWSAlgorithm == null) {
            throw new IllegalArgumentException("The JWS algorithm must not be null");
        }
        this.jwsAlgs = Collections.singleton(jWSAlgorithm);
        this.singleJwsAlgConstructorWasCalled = true;
    }

    public JWSVerificationKeySelector(Set<JWSAlgorithm> set, JWKSource<C> jWKSource) {
        super(jWKSource);
        if (set == null || set.isEmpty()) {
            throw new IllegalArgumentException("The JWS algorithms must not be null or empty");
        }
        this.jwsAlgs = Collections.unmodifiableSet(set);
        this.singleJwsAlgConstructorWasCalled = false;
    }

    public boolean isAllowed(JWSAlgorithm jWSAlgorithm) {
        return this.jwsAlgs.contains(jWSAlgorithm);
    }

    @Deprecated
    public JWSAlgorithm getExpectedJWSAlgorithm() {
        if (this.singleJwsAlgConstructorWasCalled) {
            return this.jwsAlgs.iterator().next();
        }
        throw new UnsupportedOperationException("Since this class was constructed with multiple algorithms, the behavior of this method is undefined.");
    }

    protected JWKMatcher createJWKMatcher(JWSHeader jWSHeader) {
        if (!this.isAllowed(jWSHeader.getAlgorithm())) {
            return null;
        }
        return JWKMatcher.forJWSHeader(jWSHeader);
    }

    @Override
    public List<Key> selectJWSKeys(JWSHeader jWSHeader, C c2) throws KeySourceException {
        if (!this.jwsAlgs.contains(jWSHeader.getAlgorithm())) {
            return Collections.emptyList();
        }
        JWKMatcher jWKMatcher = this.createJWKMatcher(jWSHeader);
        if (jWKMatcher == null) {
            return Collections.emptyList();
        }
        List<JWK> list = this.getJWKSource().get(new JWKSelector(jWKMatcher), c2);
        LinkedList<Key> linkedList = new LinkedList<Key>();
        for (Key key : KeyConverter.toJavaKeys(list)) {
            if (!(key instanceof PublicKey) && !(key instanceof SecretKey)) continue;
            linkedList.add(key);
        }
        return linkedList;
    }
}

