/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.gen;

import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.interfaces.RSAPublicKey;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JOSEException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.RSAKey;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.gen.JWKGenerator;

public class RSAKeyGenerator
extends JWKGenerator<RSAKey> {
    public static final int MIN_KEY_SIZE_BITS = 2048;
    private final int size;

    public RSAKeyGenerator(int n2) {
        this(n2, false);
    }

    public RSAKeyGenerator(int n2, boolean bl2) {
        if (!bl2 && n2 < 2048) {
            throw new IllegalArgumentException("The key size must be at least 2048 bits");
        }
        this.size = n2;
    }

    @Override
    public RSAKey generate() throws JOSEException {
        KeyPairGenerator keyPairGenerator;
        try {
            keyPairGenerator = this.keyStore != null ? KeyPairGenerator.getInstance("RSA", this.keyStore.getProvider()) : KeyPairGenerator.getInstance("RSA");
            keyPairGenerator.initialize(this.size);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new JOSEException(noSuchAlgorithmException.getMessage(), noSuchAlgorithmException);
        }
        KeyPair keyPair = keyPairGenerator.generateKeyPair();
        RSAKey.Builder builder = new RSAKey.Builder((RSAPublicKey)keyPair.getPublic()).privateKey(keyPair.getPrivate()).keyUse(this.use).keyOperations(this.ops).algorithm(this.alg).keyStore(this.keyStore);
        if (this.x5tKid) {
            builder.keyIDFromThumbprint();
        } else {
            builder.keyID(this.kid);
        }
        return builder.build();
    }
}

