/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk;

import java.io.Reader;
import java.io.StringReader;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.RSAPublicKeySpec;
import java.util.ArrayList;
import java.util.List;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JOSEException;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.openssl.PEMException;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;

class PEMEncodedKeyParser {
    private static final JcaPEMKeyConverter pemConverter = new JcaPEMKeyConverter();

    private PEMEncodedKeyParser() {
    }

    static List<KeyPair> parseKeys(String string) throws JOSEException {
        StringReader stringReader = new StringReader(string);
        PEMParser pEMParser = new PEMParser((Reader)stringReader);
        ArrayList<KeyPair> arrayList = new ArrayList<KeyPair>();
        try {
            Object object;
            do {
                if ((object = pEMParser.readObject()) instanceof SubjectPublicKeyInfo) {
                    arrayList.add(PEMEncodedKeyParser.toKeyPair((SubjectPublicKeyInfo)object));
                    continue;
                }
                if (object instanceof X509CertificateHolder) {
                    arrayList.add(PEMEncodedKeyParser.toKeyPair((X509CertificateHolder)object));
                    continue;
                }
                if (object instanceof PEMKeyPair) {
                    arrayList.add(PEMEncodedKeyParser.toKeyPair((PEMKeyPair)object));
                    continue;
                }
                if (!(object instanceof PrivateKeyInfo)) continue;
                arrayList.add(PEMEncodedKeyParser.toKeyPair((PrivateKeyInfo)object));
            } while (object != null);
            return arrayList;
        }
        catch (Exception exception) {
            throw new JOSEException(exception.getMessage(), exception);
        }
    }

    private static KeyPair toKeyPair(SubjectPublicKeyInfo subjectPublicKeyInfo) throws PEMException {
        return new KeyPair(pemConverter.getPublicKey(subjectPublicKeyInfo), null);
    }

    private static KeyPair toKeyPair(X509CertificateHolder x509CertificateHolder) throws PEMException {
        SubjectPublicKeyInfo subjectPublicKeyInfo = x509CertificateHolder.getSubjectPublicKeyInfo();
        return new KeyPair(pemConverter.getPublicKey(subjectPublicKeyInfo), null);
    }

    private static KeyPair toKeyPair(PEMKeyPair pEMKeyPair) throws PEMException {
        return pemConverter.getKeyPair(pEMKeyPair);
    }

    private static KeyPair toKeyPair(PrivateKeyInfo privateKeyInfo) throws PEMException, NoSuchAlgorithmException, InvalidKeySpecException {
        PrivateKey privateKey = pemConverter.getPrivateKey(privateKeyInfo);
        if (privateKey instanceof RSAPrivateCrtKey) {
            RSAPublicKeySpec rSAPublicKeySpec = new RSAPublicKeySpec(((RSAPrivateCrtKey)privateKey).getModulus(), ((RSAPrivateCrtKey)privateKey).getPublicExponent());
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            PublicKey publicKey = keyFactory.generatePublic(rSAPublicKeySpec);
            return new KeyPair(publicKey, privateKey);
        }
        return new KeyPair(null, privateKey);
    }
}

