/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk;

import java.net.URI;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.Algorithm;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JOSEException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.AsymmetricJWK;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.Curve;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.CurveBasedJWK;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.JWK;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.JWKMetadata;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.KeyOperation;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.KeyType;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.KeyUse;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.ThumbprintUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.util.Base64;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.util.Base64URL;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.util.ByteUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.util.JSONObjectUtils;
import macromedia.jdbc.sqlserver.externals.net.jcip.annotations.Immutable;

@Immutable
public class OctetKeyPair
extends JWK
implements AsymmetricJWK,
CurveBasedJWK {
    private static final long serialVersionUID = 1L;
    public static final Set<Curve> SUPPORTED_CURVES = Collections.unmodifiableSet(new HashSet<Curve>(Arrays.asList(Curve.Ed25519, Curve.Ed448, Curve.X25519, Curve.X448)));
    private final Curve crv;
    private final Base64URL x;
    private final byte[] decodedX;
    private final Base64URL d;
    private final byte[] decodedD;

    public OctetKeyPair(Curve curve, Base64URL base64URL, KeyUse keyUse, Set<KeyOperation> set, Algorithm algorithm, String string, URI uRI, Base64URL base64URL2, Base64URL base64URL3, List<Base64> list, KeyStore keyStore) {
        super(KeyType.OKP, keyUse, set, algorithm, string, uRI, base64URL2, base64URL3, list, keyStore);
        if (curve == null) {
            throw new IllegalArgumentException("The curve must not be null");
        }
        if (!SUPPORTED_CURVES.contains(curve)) {
            throw new IllegalArgumentException("Unknown / unsupported curve: " + curve);
        }
        this.crv = curve;
        if (base64URL == null) {
            throw new IllegalArgumentException("The 'x' parameter must not be null");
        }
        this.x = base64URL;
        this.decodedX = base64URL.decode();
        this.d = null;
        this.decodedD = null;
    }

    public OctetKeyPair(Curve curve, Base64URL base64URL, Base64URL base64URL2, KeyUse keyUse, Set<KeyOperation> set, Algorithm algorithm, String string, URI uRI, Base64URL base64URL3, Base64URL base64URL4, List<Base64> list, KeyStore keyStore) {
        super(KeyType.OKP, keyUse, set, algorithm, string, uRI, base64URL3, base64URL4, list, keyStore);
        if (curve == null) {
            throw new IllegalArgumentException("The curve must not be null");
        }
        if (!SUPPORTED_CURVES.contains(curve)) {
            throw new IllegalArgumentException("Unknown / unsupported curve: " + curve);
        }
        this.crv = curve;
        if (base64URL == null) {
            throw new IllegalArgumentException("The 'x' parameter must not be null");
        }
        this.x = base64URL;
        this.decodedX = base64URL.decode();
        if (base64URL2 == null) {
            throw new IllegalArgumentException("The 'd' parameter must not be null");
        }
        this.d = base64URL2;
        this.decodedD = base64URL2.decode();
    }

    @Override
    public Curve getCurve() {
        return this.crv;
    }

    public Base64URL getX() {
        return this.x;
    }

    public byte[] getDecodedX() {
        return (byte[])this.decodedX.clone();
    }

    public Base64URL getD() {
        return this.d;
    }

    public byte[] getDecodedD() {
        return this.decodedD == null ? null : (byte[])this.decodedD.clone();
    }

    @Override
    public PublicKey toPublicKey() throws JOSEException {
        throw new JOSEException("Export to java.security.PublicKey not supported");
    }

    @Override
    public PrivateKey toPrivateKey() throws JOSEException {
        throw new JOSEException("Export to java.security.PrivateKey not supported");
    }

    @Override
    public KeyPair toKeyPair() throws JOSEException {
        throw new JOSEException("Export to java.security.KeyPair not supported");
    }

    @Override
    public boolean matches(X509Certificate x509Certificate) {
        return false;
    }

    @Override
    public LinkedHashMap<String, ?> getRequiredParams() {
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        linkedHashMap.put("crv", this.crv.toString());
        linkedHashMap.put("kty", this.getKeyType().getValue());
        linkedHashMap.put("x", this.x.toString());
        return linkedHashMap;
    }

    @Override
    public boolean isPrivate() {
        return this.d != null;
    }

    @Override
    public OctetKeyPair toPublicJWK() {
        return new OctetKeyPair(this.getCurve(), this.getX(), this.getKeyUse(), this.getKeyOperations(), this.getAlgorithm(), this.getKeyID(), this.getX509CertURL(), this.getX509CertThumbprint(), this.getX509CertSHA256Thumbprint(), this.getX509CertChain(), this.getKeyStore());
    }

    @Override
    public Map<String, Object> toJSONObject() {
        Map<String, Object> map = super.toJSONObject();
        map.put("crv", this.crv.toString());
        map.put("x", this.x.toString());
        if (this.d != null) {
            map.put("d", this.d.toString());
        }
        return map;
    }

    @Override
    public int size() {
        return ByteUtils.bitLength(this.x.decode());
    }

    public static OctetKeyPair parse(String string) throws ParseException {
        return OctetKeyPair.parse(JSONObjectUtils.parse(string));
    }

    public static OctetKeyPair parse(Map<String, Object> map) throws ParseException {
        Curve curve;
        if (!KeyType.OKP.equals(JWKMetadata.parseKeyType(map))) {
            throw new ParseException("The key type kty must be " + KeyType.OKP.getValue(), 0);
        }
        try {
            curve = Curve.parse(JSONObjectUtils.getString(map, "crv"));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new ParseException(illegalArgumentException.getMessage(), 0);
        }
        Base64URL base64URL = JSONObjectUtils.getBase64URL(map, "x");
        Base64URL base64URL2 = JSONObjectUtils.getBase64URL(map, "d");
        try {
            if (base64URL2 == null) {
                return new OctetKeyPair(curve, base64URL, JWKMetadata.parseKeyUse(map), JWKMetadata.parseKeyOperations(map), JWKMetadata.parseAlgorithm(map), JWKMetadata.parseKeyID(map), JWKMetadata.parseX509CertURL(map), JWKMetadata.parseX509CertThumbprint(map), JWKMetadata.parseX509CertSHA256Thumbprint(map), JWKMetadata.parseX509CertChain(map), null);
            }
            return new OctetKeyPair(curve, base64URL, base64URL2, JWKMetadata.parseKeyUse(map), JWKMetadata.parseKeyOperations(map), JWKMetadata.parseAlgorithm(map), JWKMetadata.parseKeyID(map), JWKMetadata.parseX509CertURL(map), JWKMetadata.parseX509CertThumbprint(map), JWKMetadata.parseX509CertSHA256Thumbprint(map), JWKMetadata.parseX509CertChain(map), null);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new ParseException(illegalArgumentException.getMessage(), 0);
        }
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof OctetKeyPair)) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        OctetKeyPair octetKeyPair = (OctetKeyPair)object;
        return Objects.equals(this.crv, octetKeyPair.crv) && Objects.equals(this.x, octetKeyPair.x) && Arrays.equals(this.decodedX, octetKeyPair.decodedX) && Objects.equals(this.d, octetKeyPair.d) && Arrays.equals(this.decodedD, octetKeyPair.decodedD);
    }

    @Override
    public int hashCode() {
        int n2 = Objects.hash(super.hashCode(), this.crv, this.x, this.d);
        n2 = 31 * n2 + Arrays.hashCode(this.decodedX);
        n2 = 31 * n2 + Arrays.hashCode(this.decodedD);
        return n2;
    }

    public static class Builder {
        private final Curve crv;
        private final Base64URL x;
        private Base64URL d;
        private KeyUse use;
        private Set<KeyOperation> ops;
        private Algorithm alg;
        private String kid;
        private URI x5u;
        @Deprecated
        private Base64URL x5t;
        private Base64URL x5t256;
        private List<Base64> x5c;
        private KeyStore ks;

        public Builder(Curve curve, Base64URL base64URL) {
            if (curve == null) {
                throw new IllegalArgumentException("The curve must not be null");
            }
            this.crv = curve;
            if (base64URL == null) {
                throw new IllegalArgumentException("The 'x' coordinate must not be null");
            }
            this.x = base64URL;
        }

        public Builder(OctetKeyPair octetKeyPair) {
            this.crv = octetKeyPair.crv;
            this.x = octetKeyPair.x;
            this.d = octetKeyPair.d;
            this.use = octetKeyPair.getKeyUse();
            this.ops = octetKeyPair.getKeyOperations();
            this.alg = octetKeyPair.getAlgorithm();
            this.kid = octetKeyPair.getKeyID();
            this.x5u = octetKeyPair.getX509CertURL();
            this.x5t = octetKeyPair.getX509CertThumbprint();
            this.x5t256 = octetKeyPair.getX509CertSHA256Thumbprint();
            this.x5c = octetKeyPair.getX509CertChain();
            this.ks = octetKeyPair.getKeyStore();
        }

        public Builder d(Base64URL base64URL) {
            this.d = base64URL;
            return this;
        }

        public Builder keyUse(KeyUse keyUse) {
            this.use = keyUse;
            return this;
        }

        public Builder keyOperations(Set<KeyOperation> set) {
            this.ops = set;
            return this;
        }

        public Builder algorithm(Algorithm algorithm) {
            this.alg = algorithm;
            return this;
        }

        public Builder keyID(String string) {
            this.kid = string;
            return this;
        }

        public Builder keyIDFromThumbprint() throws JOSEException {
            return this.keyIDFromThumbprint("SHA-256");
        }

        public Builder keyIDFromThumbprint(String string) throws JOSEException {
            LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
            linkedHashMap.put("crv", this.crv.toString());
            linkedHashMap.put("kty", KeyType.OKP.getValue());
            linkedHashMap.put("x", this.x.toString());
            this.kid = ThumbprintUtils.compute(string, linkedHashMap).toString();
            return this;
        }

        public Builder x509CertURL(URI uRI) {
            this.x5u = uRI;
            return this;
        }

        @Deprecated
        public Builder x509CertThumbprint(Base64URL base64URL) {
            this.x5t = base64URL;
            return this;
        }

        public Builder x509CertSHA256Thumbprint(Base64URL base64URL) {
            this.x5t256 = base64URL;
            return this;
        }

        public Builder x509CertChain(List<Base64> list) {
            this.x5c = list;
            return this;
        }

        public Builder keyStore(KeyStore keyStore) {
            this.ks = keyStore;
            return this;
        }

        public OctetKeyPair build() {
            try {
                if (this.d == null) {
                    return new OctetKeyPair(this.crv, this.x, this.use, this.ops, this.alg, this.kid, this.x5u, this.x5t, this.x5t256, this.x5c, this.ks);
                }
                return new OctetKeyPair(this.crv, this.x, this.d, this.use, this.ops, this.alg, this.kid, this.x5u, this.x5t, this.x5t256, this.x5c, this.ks);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new IllegalStateException(illegalArgumentException.getMessage(), illegalArgumentException);
            }
        }
    }
}

