/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.crypto.impl;

import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Signature;
import java.security.spec.MGF1ParameterSpec;
import java.security.spec.PSSParameterSpec;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JOSEException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JWSAlgorithm;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.crypto.impl.AlgorithmSupportMessage;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.crypto.impl.RSASSAProvider;

public class RSASSA {
    public static Signature getSignerAndVerifier(JWSAlgorithm jWSAlgorithm, Provider provider) throws JOSEException {
        Signature signature;
        if (jWSAlgorithm.equals(JWSAlgorithm.RS256) && (signature = RSASSA.getSignerAndVerifier("SHA256withRSA", provider)) != null) {
            return signature;
        }
        if (jWSAlgorithm.equals(JWSAlgorithm.RS384) && (signature = RSASSA.getSignerAndVerifier("SHA384withRSA", provider)) != null) {
            return signature;
        }
        if (jWSAlgorithm.equals(JWSAlgorithm.RS512) && (signature = RSASSA.getSignerAndVerifier("SHA512withRSA", provider)) != null) {
            return signature;
        }
        if (jWSAlgorithm.equals(JWSAlgorithm.PS256) && (signature = RSASSA.getSignerAndVerifier("RSASSA-PSS", provider, new PSSParameterSpec("SHA-256", "MGF1", MGF1ParameterSpec.SHA256, 32, 1))) != null) {
            return signature;
        }
        if (jWSAlgorithm.equals(JWSAlgorithm.PS256) && (signature = RSASSA.getSignerAndVerifier("SHA256withRSAandMGF1", provider)) != null) {
            return signature;
        }
        if (jWSAlgorithm.equals(JWSAlgorithm.PS384) && (signature = RSASSA.getSignerAndVerifier("RSASSA-PSS", provider, new PSSParameterSpec("SHA-384", "MGF1", MGF1ParameterSpec.SHA384, 48, 1))) != null) {
            return signature;
        }
        if (jWSAlgorithm.equals(JWSAlgorithm.PS384) && (signature = RSASSA.getSignerAndVerifier("SHA384withRSAandMGF1", provider)) != null) {
            return signature;
        }
        if (jWSAlgorithm.equals(JWSAlgorithm.PS512) && (signature = RSASSA.getSignerAndVerifier("RSASSA-PSS", provider, new PSSParameterSpec("SHA-512", "MGF1", MGF1ParameterSpec.SHA512, 64, 1))) != null) {
            return signature;
        }
        if (jWSAlgorithm.equals(JWSAlgorithm.PS512) && (signature = RSASSA.getSignerAndVerifier("SHA512withRSAandMGF1", provider)) != null) {
            return signature;
        }
        throw new JOSEException(AlgorithmSupportMessage.unsupportedJWSAlgorithm(jWSAlgorithm, RSASSAProvider.SUPPORTED_ALGORITHMS));
    }

    private static Signature getSignerAndVerifier(String string, Provider provider) throws JOSEException {
        return RSASSA.getSignerAndVerifier(string, provider, null);
    }

    private static Signature getSignerAndVerifier(String string, Provider provider, PSSParameterSpec pSSParameterSpec) throws JOSEException {
        Signature signature;
        try {
            signature = provider != null ? Signature.getInstance(string, provider) : Signature.getInstance(string);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            return null;
        }
        if (pSSParameterSpec != null) {
            try {
                signature.setParameter(pSSParameterSpec);
            }
            catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
                throw new JOSEException("Invalid RSASSA-PSS salt length parameter: " + invalidAlgorithmParameterException.getMessage(), invalidAlgorithmParameterException);
            }
        }
        return signature;
    }

    private RSASSA() {
    }
}

