/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.crypto.impl;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JOSEException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jca.JCAAware;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jca.JCAContext;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.util.Base64URL;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.util.ByteUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.util.IntegerUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.util.StandardCharset;
import macromedia.jdbc.sqlserver.externals.net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class ConcatKDF
implements JCAAware<JCAContext> {
    private final String jcaHashAlg;
    private final JCAContext jcaContext = new JCAContext();

    public ConcatKDF(String string) {
        if (string == null) {
            throw new IllegalArgumentException("The JCA hash algorithm must not be null");
        }
        this.jcaHashAlg = string;
    }

    public String getHashAlgorithm() {
        return this.jcaHashAlg;
    }

    @Override
    public JCAContext getJCAContext() {
        return this.jcaContext;
    }

    public SecretKey deriveKey(SecretKey secretKey, int n2, byte[] byArray) throws JOSEException {
        int n3;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        MessageDigest messageDigest = this.getMessageDigest();
        for (int i2 = 1; i2 <= ConcatKDF.computeDigestCycles(ByteUtils.safeBitLength(messageDigest.getDigestLength()), n2); ++i2) {
            byte[] byArray2 = IntegerUtils.toBytes(i2);
            messageDigest.update(byArray2);
            messageDigest.update(secretKey.getEncoded());
            if (byArray != null) {
                messageDigest.update(byArray);
            }
            try {
                byteArrayOutputStream.write(messageDigest.digest());
                continue;
            }
            catch (IOException iOException) {
                throw new JOSEException("Couldn't write derived key: " + iOException.getMessage(), iOException);
            }
        }
        byte[] byArray3 = byteArrayOutputStream.toByteArray();
        if (byArray3.length == (n3 = ByteUtils.byteLength(n2))) {
            return new SecretKeySpec(byArray3, "AES");
        }
        return new SecretKeySpec(ByteUtils.subArray(byArray3, 0, n3), "AES");
    }

    public SecretKey deriveKey(SecretKey secretKey, int n2, byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4, byte[] byArray5) throws JOSEException {
        byte[] byArray6 = ConcatKDF.composeOtherInfo(byArray, byArray2, byArray3, byArray4, byArray5);
        return this.deriveKey(secretKey, n2, byArray6);
    }

    public SecretKey deriveKey(SecretKey secretKey, int n2, byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4, byte[] byArray5, byte[] byArray6) throws JOSEException {
        byte[] byArray7 = ConcatKDF.composeOtherInfo(byArray, byArray2, byArray3, byArray4, byArray5, byArray6);
        return this.deriveKey(secretKey, n2, byArray7);
    }

    public static byte[] composeOtherInfo(byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4, byte[] byArray5) {
        return ByteUtils.concat(byArray, byArray2, byArray3, byArray4, byArray5);
    }

    public static byte[] composeOtherInfo(byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4, byte[] byArray5, byte[] byArray6) {
        return ByteUtils.concat(byArray, byArray2, byArray3, byArray4, byArray5, byArray6);
    }

    private MessageDigest getMessageDigest() throws JOSEException {
        Provider provider = this.getJCAContext().getProvider();
        try {
            if (provider == null) {
                return MessageDigest.getInstance(this.jcaHashAlg);
            }
            return MessageDigest.getInstance(this.jcaHashAlg, provider);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new JOSEException("Couldn't get message digest for KDF: " + noSuchAlgorithmException.getMessage(), noSuchAlgorithmException);
        }
    }

    public static int computeDigestCycles(int n2, int n3) {
        return (n3 + n2 - 1) / n2;
    }

    public static byte[] encodeNoData() {
        return new byte[0];
    }

    public static byte[] encodeIntData(int n2) {
        return IntegerUtils.toBytes(n2);
    }

    public static byte[] encodeStringData(String string) {
        byte[] byArray = string != null ? string.getBytes(StandardCharset.UTF_8) : null;
        return ConcatKDF.encodeDataWithLength(byArray);
    }

    public static byte[] encodeDataWithLength(byte[] byArray) {
        byte[] byArray2 = byArray != null ? byArray : new byte[]{};
        byte[] byArray3 = IntegerUtils.toBytes(byArray2.length);
        return ByteUtils.concat(byArray3, byArray2);
    }

    public static byte[] encodeDataWithLength(Base64URL base64URL) {
        byte[] byArray = base64URL != null ? base64URL.decode() : null;
        return ConcatKDF.encodeDataWithLength(byArray);
    }
}

