/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.crypto;

import com.google.crypto.tink.subtle.X25519;
import java.security.InvalidKeyException;
import java.util.Collections;
import java.util.Set;
import javax.crypto.SecretKey;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JOSEException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JWECryptoParts;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JWEEncrypter;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JWEHeader;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.crypto.impl.ECDH;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.crypto.impl.ECDHCryptoProvider;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.Curve;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.OctetKeyPair;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.util.Base64URL;
import macromedia.jdbc.sqlserver.externals.net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class X25519Encrypter
extends ECDHCryptoProvider
implements JWEEncrypter {
    private final OctetKeyPair publicKey;

    public X25519Encrypter(OctetKeyPair octetKeyPair) throws JOSEException {
        super(octetKeyPair.getCurve());
        if (!Curve.X25519.equals(octetKeyPair.getCurve())) {
            throw new JOSEException("X25519Encrypter only supports OctetKeyPairs with crv=X25519");
        }
        if (octetKeyPair.isPrivate()) {
            throw new JOSEException("X25519Encrypter requires a public key, use OctetKeyPair.toPublicJWK()");
        }
        this.publicKey = octetKeyPair;
    }

    @Override
    public Set<Curve> supportedEllipticCurves() {
        return Collections.singleton(Curve.X25519);
    }

    public OctetKeyPair getPublicKey() {
        return this.publicKey;
    }

    @Override
    public JWECryptoParts encrypt(JWEHeader jWEHeader, byte[] byArray) throws JOSEException {
        byte[] byArray2;
        byte[] byArray3 = X25519.generatePrivateKey();
        try {
            byArray2 = X25519.publicFromPrivate((byte[])byArray3);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new JOSEException(invalidKeyException.getMessage(), invalidKeyException);
        }
        OctetKeyPair octetKeyPair = new OctetKeyPair.Builder(this.getCurve(), Base64URL.encode(byArray2)).d(Base64URL.encode(byArray3)).build();
        OctetKeyPair octetKeyPair2 = octetKeyPair.toPublicJWK();
        JWEHeader jWEHeader2 = new JWEHeader.Builder(jWEHeader).ephemeralPublicKey(octetKeyPair2).build();
        SecretKey secretKey = ECDH.deriveSharedSecret(this.publicKey, octetKeyPair);
        return this.encryptWithZ(jWEHeader2, secretKey, byArray);
    }
}

