/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.crypto;

import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.EncryptionMethod;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JOSEException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JWEAlgorithm;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JWECryptoParts;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JWEEncrypter;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JWEHeader;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.KeyLengthException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.crypto.impl.AESCryptoProvider;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.crypto.impl.AESGCM;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.crypto.impl.AESGCMKW;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.crypto.impl.AESKW;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.crypto.impl.AlgorithmSupportMessage;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.crypto.impl.AuthenticatedCipherText;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.crypto.impl.ContentCryptoProvider;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.OctetSequenceKey;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.util.Base64URL;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.util.ByteUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.util.Container;
import macromedia.jdbc.sqlserver.externals.net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class AESEncrypter
extends AESCryptoProvider
implements JWEEncrypter {
    public AESEncrypter(SecretKey secretKey) throws KeyLengthException {
        super(secretKey);
    }

    public AESEncrypter(byte[] byArray) throws KeyLengthException {
        this(new SecretKeySpec(byArray, "AES"));
    }

    public AESEncrypter(OctetSequenceKey octetSequenceKey) throws KeyLengthException {
        this(octetSequenceKey.toSecretKey("AES"));
    }

    @Override
    public JWECryptoParts encrypt(JWEHeader jWEHeader, byte[] byArray) throws JOSEException {
        JWEHeader jWEHeader2;
        Base64URL base64URL;
        AlgFamily algFamily;
        JWEAlgorithm jWEAlgorithm = jWEHeader.getAlgorithm();
        if (jWEAlgorithm.equals(JWEAlgorithm.A128KW)) {
            if (ByteUtils.safeBitLength(this.getKey().getEncoded()) != 128) {
                throw new KeyLengthException("The Key Encryption Key (KEK) length must be 128 bits for A128KW encryption");
            }
            algFamily = AlgFamily.AESKW;
        } else if (jWEAlgorithm.equals(JWEAlgorithm.A192KW)) {
            if (ByteUtils.safeBitLength(this.getKey().getEncoded()) != 192) {
                throw new KeyLengthException("The Key Encryption Key (KEK) length must be 192 bits for A192KW encryption");
            }
            algFamily = AlgFamily.AESKW;
        } else if (jWEAlgorithm.equals(JWEAlgorithm.A256KW)) {
            if (ByteUtils.safeBitLength(this.getKey().getEncoded()) != 256) {
                throw new KeyLengthException("The Key Encryption Key (KEK) length must be 256 bits for A256KW encryption");
            }
            algFamily = AlgFamily.AESKW;
        } else if (jWEAlgorithm.equals(JWEAlgorithm.A128GCMKW)) {
            if (ByteUtils.safeBitLength(this.getKey().getEncoded()) != 128) {
                throw new KeyLengthException("The Key Encryption Key (KEK) length must be 128 bits for A128GCMKW encryption");
            }
            algFamily = AlgFamily.AESGCMKW;
        } else if (jWEAlgorithm.equals(JWEAlgorithm.A192GCMKW)) {
            if (ByteUtils.safeBitLength(this.getKey().getEncoded()) != 192) {
                throw new KeyLengthException("The Key Encryption Key (KEK) length must be 192 bits for A192GCMKW encryption");
            }
            algFamily = AlgFamily.AESGCMKW;
        } else if (jWEAlgorithm.equals(JWEAlgorithm.A256GCMKW)) {
            if (ByteUtils.safeBitLength(this.getKey().getEncoded()) != 256) {
                throw new KeyLengthException("The Key Encryption Key (KEK) length must be 256 bits for A256GCMKW encryption");
            }
            algFamily = AlgFamily.AESGCMKW;
        } else {
            throw new JOSEException(AlgorithmSupportMessage.unsupportedJWEAlgorithm(jWEAlgorithm, SUPPORTED_ALGORITHMS));
        }
        EncryptionMethod encryptionMethod = jWEHeader.getEncryptionMethod();
        SecretKey secretKey = ContentCryptoProvider.generateCEK(encryptionMethod, this.getJCAContext().getSecureRandom());
        if (AlgFamily.AESKW.equals((Object)algFamily)) {
            base64URL = Base64URL.encode(AESKW.wrapCEK(secretKey, this.getKey(), this.getJCAContext().getKeyEncryptionProvider()));
            jWEHeader2 = jWEHeader;
        } else if (AlgFamily.AESGCMKW.equals((Object)algFamily)) {
            Container<byte[]> container = new Container<byte[]>(AESGCM.generateIV(this.getJCAContext().getSecureRandom()));
            AuthenticatedCipherText authenticatedCipherText = AESGCMKW.encryptCEK(secretKey, container, this.getKey(), this.getJCAContext().getKeyEncryptionProvider());
            base64URL = Base64URL.encode(authenticatedCipherText.getCipherText());
            jWEHeader2 = new JWEHeader.Builder(jWEHeader).iv(Base64URL.encode(container.get())).authTag(Base64URL.encode(authenticatedCipherText.getAuthenticationTag())).build();
        } else {
            throw new JOSEException("Unexpected JWE algorithm: " + jWEAlgorithm);
        }
        return ContentCryptoProvider.encrypt(jWEHeader2, byArray, secretKey, base64URL, this.getJCAContext());
    }

    private static enum AlgFamily {
        AESKW,
        AESGCMKW;

    }
}

