/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.jose;

import java.text.ParseException;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.util.JSONObjectUtils;
import macromedia.jdbc.sqlserver.externals.net.jcip.annotations.Immutable;

@Immutable
public final class UnprotectedHeader {
    private final Map<String, Object> params;

    private UnprotectedHeader(Map<String, Object> map) {
        Objects.requireNonNull(map);
        this.params = map;
    }

    public String getKeyID() {
        return (String)this.params.get("kid");
    }

    public Object getParam(String string) {
        return this.params.get(string);
    }

    public Set<String> getIncludedParams() {
        return this.params.keySet();
    }

    public Map<String, Object> toJSONObject() {
        Map<String, Object> map = JSONObjectUtils.newJSONObject();
        map.putAll(this.params);
        return map;
    }

    public static UnprotectedHeader parse(Map<String, Object> map) throws ParseException {
        if (map == null) {
            return null;
        }
        Builder builder = new Builder();
        for (String string : map.keySet()) {
            builder = builder.param(string, map.get(string));
        }
        return builder.build();
    }

    public static class Builder {
        private final Map<String, Object> params = JSONObjectUtils.newJSONObject();

        public Builder keyID(String string) {
            this.params.put("kid", string);
            return this;
        }

        public Builder param(String string, Object object) {
            this.params.put(string, object);
            return this;
        }

        public UnprotectedHeader build() {
            return new UnprotectedHeader(this.params);
        }
    }
}

