/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.Proxy;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Scanner;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocketFactory;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.HttpMethod;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.HttpRequest;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.HttpResponse;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.IHttpClient;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.IHttpResponse;

class DefaultHttpClient
implements IHttpClient {
    private final Proxy proxy;
    private final SSLSocketFactory sslSocketFactory;
    public int DEFAULT_CONNECT_TIMEOUT = 10000;
    public int DEFAULT_READ_TIMEOUT = 15000;
    private int connectTimeout = this.DEFAULT_CONNECT_TIMEOUT;
    private int readTimeout = this.DEFAULT_READ_TIMEOUT;

    DefaultHttpClient(Proxy proxy, SSLSocketFactory sSLSocketFactory, Integer n2, Integer n3) {
        this.proxy = proxy;
        this.sslSocketFactory = sSLSocketFactory;
        if (n2 != null) {
            this.connectTimeout = n2;
        }
        if (n3 != null) {
            this.readTimeout = n3;
        }
    }

    @Override
    public IHttpResponse send(HttpRequest httpRequest) throws Exception {
        HttpResponse httpResponse = null;
        if (httpRequest.httpMethod() == HttpMethod.GET) {
            httpResponse = this.executeHttpGet(httpRequest);
        } else if (httpRequest.httpMethod() == HttpMethod.POST) {
            httpResponse = this.executeHttpPost(httpRequest);
        }
        return httpResponse;
    }

    private HttpResponse executeHttpGet(HttpRequest httpRequest) throws Exception {
        HttpsURLConnection httpsURLConnection = this.openConnection(httpRequest.url());
        this.configureAdditionalHeaders(httpsURLConnection, httpRequest);
        return this.readResponseFromConnection(httpsURLConnection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HttpResponse executeHttpPost(HttpRequest httpRequest) throws Exception {
        HttpsURLConnection httpsURLConnection = this.openConnection(httpRequest.url());
        this.configureAdditionalHeaders(httpsURLConnection, httpRequest);
        httpsURLConnection.setRequestMethod("POST");
        httpsURLConnection.setDoOutput(true);
        try (DataOutputStream dataOutputStream = null;){
            dataOutputStream = new DataOutputStream(httpsURLConnection.getOutputStream());
            dataOutputStream.writeBytes(httpRequest.body());
            dataOutputStream.flush();
            HttpResponse httpResponse = this.readResponseFromConnection(httpsURLConnection);
            return httpResponse;
        }
    }

    private HttpsURLConnection openConnection(URL uRL) throws IOException {
        HttpsURLConnection httpsURLConnection = this.proxy != null ? (HttpsURLConnection)uRL.openConnection(this.proxy) : (HttpsURLConnection)uRL.openConnection();
        if (this.sslSocketFactory != null) {
            httpsURLConnection.setSSLSocketFactory(this.sslSocketFactory);
        }
        httpsURLConnection.setConnectTimeout(this.connectTimeout);
        httpsURLConnection.setReadTimeout(this.readTimeout);
        return httpsURLConnection;
    }

    private void configureAdditionalHeaders(HttpsURLConnection httpsURLConnection, HttpRequest httpRequest) {
        if (httpRequest.headers() != null) {
            for (Map.Entry<String, String> entry : httpRequest.headers().entrySet()) {
                if (entry.getValue() == null) continue;
                httpsURLConnection.addRequestProperty(entry.getKey(), entry.getValue());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HttpResponse readResponseFromConnection(HttpsURLConnection httpsURLConnection) throws IOException {
        try (InputStream inputStream = null;){
            HttpResponse httpResponse = new HttpResponse();
            int n2 = httpsURLConnection.getResponseCode();
            httpResponse.statusCode(n2);
            if (n2 != 200) {
                inputStream = httpsURLConnection.getErrorStream();
                if (inputStream != null) {
                    httpResponse.addHeaders(httpsURLConnection.getHeaderFields());
                    httpResponse.body(this.inputStreamToString(inputStream));
                }
                HttpResponse httpResponse2 = httpResponse;
                return httpResponse2;
            }
            inputStream = httpsURLConnection.getInputStream();
            httpResponse.addHeaders(httpsURLConnection.getHeaderFields());
            httpResponse.body(this.inputStreamToString(inputStream));
            HttpResponse httpResponse3 = httpResponse;
            return httpResponse3;
        }
    }

    private String inputStreamToString(InputStream inputStream) {
        Scanner scanner = new Scanner(inputStream, StandardCharsets.UTF_8.name()).useDelimiter("\\A");
        return scanner.hasNext() ? scanner.next() : "";
    }
}

