/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j;

import java.awt.Desktop;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.AbstractClientApplicationBase;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.AcquireTokenByAuthorizationGrantSupplier;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.AuthenticationResult;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.AuthenticationResultSupplier;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.Authority;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.AuthorizationCodeParameters;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.AuthorizationCodeRequest;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.AuthorizationResponseHandler;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.AuthorizationResult;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.HttpListener;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.InteractiveRequest;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.MsalClientException;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.PublicApi;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.PublicClientApplication;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.RequestContext;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.StringHelper;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.SystemBrowserOptions;
import macromedia.jdbc.sqlserver.externals.org.slf4j.Logger;
import macromedia.jdbc.sqlserver.externals.org.slf4j.LoggerFactory;

class AcquireTokenByInteractiveFlowSupplier
extends AuthenticationResultSupplier {
    private static final Logger LOG = LoggerFactory.getLogger(AcquireTokenByAuthorizationGrantSupplier.class);
    private PublicClientApplication clientApplication;
    private InteractiveRequest interactiveRequest;
    private BlockingQueue<AuthorizationResult> authorizationResultQueue;
    private HttpListener httpListener;

    AcquireTokenByInteractiveFlowSupplier(PublicClientApplication publicClientApplication, InteractiveRequest interactiveRequest) {
        super(publicClientApplication, interactiveRequest);
        this.clientApplication = publicClientApplication;
        this.interactiveRequest = interactiveRequest;
    }

    @Override
    AuthenticationResult execute() throws Exception {
        AuthorizationResult authorizationResult = this.getAuthorizationResult();
        this.validateState(authorizationResult);
        return this.acquireTokenWithAuthorizationCode(authorizationResult);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AuthorizationResult getAuthorizationResult() {
        AuthorizationResult authorizationResult;
        try {
            SystemBrowserOptions systemBrowserOptions = this.interactiveRequest.interactiveRequestParameters().systemBrowserOptions();
            this.authorizationResultQueue = new LinkedBlockingQueue<AuthorizationResult>();
            AuthorizationResponseHandler authorizationResponseHandler = new AuthorizationResponseHandler(this.authorizationResultQueue, systemBrowserOptions);
            this.startHttpListener(authorizationResponseHandler);
            if (systemBrowserOptions != null && systemBrowserOptions.openBrowserAction() != null) {
                this.interactiveRequest.interactiveRequestParameters().systemBrowserOptions().openBrowserAction().openBrowser(this.interactiveRequest.authorizationUrl());
            } else {
                this.openDefaultSystemBrowser(this.interactiveRequest.authorizationUrl());
            }
            authorizationResult = this.getAuthorizationResultFromHttpListener();
        }
        finally {
            if (this.httpListener != null) {
                this.httpListener.stopListener();
            }
        }
        return authorizationResult;
    }

    private void validateState(AuthorizationResult authorizationResult) {
        if (StringHelper.isBlank(authorizationResult.state()) || !authorizationResult.state().equals(this.interactiveRequest.state())) {
            throw new MsalClientException("State returned in authorization result is blank or does not match state sent on outgoing request", "invalid_authorization_result");
        }
    }

    private void startHttpListener(AuthorizationResponseHandler authorizationResponseHandler) {
        int n2 = this.interactiveRequest.interactiveRequestParameters().redirectUri().getPort() == -1 ? 0 : this.interactiveRequest.interactiveRequestParameters().redirectUri().getPort();
        this.httpListener = new HttpListener();
        this.httpListener.startListener(n2, authorizationResponseHandler);
        if (n2 != this.httpListener.port()) {
            this.updateRedirectUrl();
        }
    }

    private void updateRedirectUrl() {
        try {
            URI uRI = new URI("http://localhost:" + this.httpListener.port());
            this.interactiveRequest.interactiveRequestParameters().redirectUri(uRI);
            LOG.debug("Redirect URI updated to" + uRI);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new MsalClientException("Error updating redirect URI. Not a valid URI format", "invalid_redirect_uri");
        }
    }

    private void openDefaultSystemBrowser(URL uRL) {
        try {
            if (!Desktop.isDesktopSupported() || !Desktop.getDesktop().isSupported(Desktop.Action.BROWSE)) {
                throw new MsalClientException("Unable to open default system browser", "desktop_browser_not_supported");
            }
            Desktop.getDesktop().browse(uRL.toURI());
            LOG.debug("Opened default system browser");
        }
        catch (IOException | URISyntaxException exception) {
            throw new MsalClientException(exception);
        }
    }

    private AuthorizationResult getAuthorizationResultFromHttpListener() {
        AuthorizationResult authorizationResult = null;
        try {
            LOG.debug("Listening for authorization result");
            long l2 = TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis()) + 120L;
            while (authorizationResult == null && !this.interactiveRequest.futureReference().get().isCancelled() && TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis()) < l2) {
                authorizationResult = this.authorizationResultQueue.poll(100L, TimeUnit.MILLISECONDS);
            }
        }
        catch (Exception exception) {
            throw new MsalClientException(exception);
        }
        if (authorizationResult == null || StringHelper.isBlank(authorizationResult.code())) {
            throw new MsalClientException("No Authorization code was returned from the server", "invalid_authorization_result");
        }
        return authorizationResult;
    }

    private AuthenticationResult acquireTokenWithAuthorizationCode(AuthorizationResult authorizationResult) throws Exception {
        AuthorizationCodeParameters authorizationCodeParameters = AuthorizationCodeParameters.builder(authorizationResult.code(), this.interactiveRequest.interactiveRequestParameters().redirectUri()).scopes(this.interactiveRequest.interactiveRequestParameters().scopes()).codeVerifier(this.interactiveRequest.verifier()).claims(this.interactiveRequest.interactiveRequestParameters().claims()).build();
        RequestContext requestContext = new RequestContext(this.clientApplication, PublicApi.ACQUIRE_TOKEN_BY_AUTHORIZATION_CODE, authorizationCodeParameters, this.interactiveRequest.requestContext().userIdentifier());
        AuthorizationCodeRequest authorizationCodeRequest = new AuthorizationCodeRequest(authorizationCodeParameters, (AbstractClientApplicationBase)this.clientApplication, requestContext);
        Authority authority = authorizationResult.environment() != null ? Authority.createAuthority(new URL(this.clientApplication.authenticationAuthority.canonicalAuthorityUrl.getProtocol(), authorizationResult.environment(), this.clientApplication.authenticationAuthority.canonicalAuthorityUrl.getFile())) : this.clientApplication.authenticationAuthority;
        AcquireTokenByAuthorizationGrantSupplier acquireTokenByAuthorizationGrantSupplier = new AcquireTokenByAuthorizationGrantSupplier(this.clientApplication, authorizationCodeRequest, authority);
        return acquireTokenByAuthorizationGrantSupplier.execute();
    }
}

