/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.AbstractClientApplicationBase;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.AbstractMsalAuthorizationGrant;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.AuthenticationResult;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.AuthenticationResultSupplier;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.Authority;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.AuthorityType;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.IntegratedWindowsAuthorizationGrant;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.InteractionRequiredCache;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.MsalClientException;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.MsalInteractionRequiredException;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.MsalRequest;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.OAuthAuthorizationGrant;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.PublicClientApplication;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.RefreshTokenRequest;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.SAML11BearerGrant;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.UserDiscoveryRequest;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.UserDiscoveryResponse;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.WSTrustRequest;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.WSTrustResponse;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.util.Base64URL;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.AuthorizationGrant;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.ResourceOwnerPasswordCredentialsGrant;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.SAML2BearerGrant;

class AcquireTokenByAuthorizationGrantSupplier
extends AuthenticationResultSupplier {
    private Authority requestAuthority;
    private MsalRequest msalRequest;

    AcquireTokenByAuthorizationGrantSupplier(AbstractClientApplicationBase abstractClientApplicationBase, MsalRequest msalRequest, Authority authority) {
        super(abstractClientApplicationBase, msalRequest);
        this.msalRequest = msalRequest;
        this.requestAuthority = authority;
    }

    @Override
    AuthenticationResult execute() throws Exception {
        Object object;
        AbstractMsalAuthorizationGrant abstractMsalAuthorizationGrant = this.msalRequest.msalAuthorizationGrant();
        if (this.IsUiRequiredCacheSupported() && (object = InteractionRequiredCache.getCachedInteractionRequiredException(((RefreshTokenRequest)this.msalRequest).getFullThumbprint())) != null) {
            throw object;
        }
        if (abstractMsalAuthorizationGrant instanceof OAuthAuthorizationGrant) {
            this.msalRequest.msalAuthorizationGrant = this.processPasswordGrant((OAuthAuthorizationGrant)abstractMsalAuthorizationGrant);
        }
        if (abstractMsalAuthorizationGrant instanceof IntegratedWindowsAuthorizationGrant) {
            object = (IntegratedWindowsAuthorizationGrant)abstractMsalAuthorizationGrant;
            this.msalRequest.msalAuthorizationGrant = new OAuthAuthorizationGrant(this.getAuthorizationGrantIntegrated(((IntegratedWindowsAuthorizationGrant)object).getUserName()), ((AbstractMsalAuthorizationGrant)object).getScopes(), ((AbstractMsalAuthorizationGrant)object).getClaims());
        }
        if (this.requestAuthority == null) {
            this.requestAuthority = this.clientApplication.authenticationAuthority;
        }
        if (this.requestAuthority.authorityType == AuthorityType.AAD) {
            this.requestAuthority = this.getAuthorityWithPrefNetworkHost(this.requestAuthority.authority());
        }
        try {
            return this.clientApplication.acquireTokenCommon(this.msalRequest, this.requestAuthority);
        }
        catch (MsalInteractionRequiredException msalInteractionRequiredException) {
            if (this.IsUiRequiredCacheSupported()) {
                InteractionRequiredCache.set(((RefreshTokenRequest)this.msalRequest).getFullThumbprint(), msalInteractionRequiredException);
            }
            throw msalInteractionRequiredException;
        }
    }

    private boolean IsUiRequiredCacheSupported() {
        return this.msalRequest instanceof RefreshTokenRequest && this.clientApplication instanceof PublicClientApplication;
    }

    private OAuthAuthorizationGrant processPasswordGrant(OAuthAuthorizationGrant oAuthAuthorizationGrant) throws Exception {
        if (!(oAuthAuthorizationGrant.getAuthorizationGrant() instanceof ResourceOwnerPasswordCredentialsGrant)) {
            return oAuthAuthorizationGrant;
        }
        if (this.msalRequest.application().authenticationAuthority.authorityType != AuthorityType.AAD) {
            return oAuthAuthorizationGrant;
        }
        ResourceOwnerPasswordCredentialsGrant resourceOwnerPasswordCredentialsGrant = (ResourceOwnerPasswordCredentialsGrant)oAuthAuthorizationGrant.getAuthorizationGrant();
        UserDiscoveryResponse userDiscoveryResponse = UserDiscoveryRequest.execute(this.clientApplication.authenticationAuthority.getUserRealmEndpoint(resourceOwnerPasswordCredentialsGrant.getUsername()), this.msalRequest.headers().getReadonlyHeaderMap(), this.msalRequest.requestContext(), this.clientApplication.getServiceBundle());
        if (userDiscoveryResponse.isAccountFederated()) {
            WSTrustResponse wSTrustResponse = WSTrustRequest.execute(userDiscoveryResponse.federationMetadataUrl(), resourceOwnerPasswordCredentialsGrant.getUsername(), resourceOwnerPasswordCredentialsGrant.getPassword().getValue(), userDiscoveryResponse.cloudAudienceUrn(), this.msalRequest.requestContext(), this.clientApplication.getServiceBundle(), this.clientApplication.logPii());
            AuthorizationGrant authorizationGrant = this.getSAMLAuthorizationGrant(wSTrustResponse);
            oAuthAuthorizationGrant = new OAuthAuthorizationGrant(authorizationGrant, oAuthAuthorizationGrant.getParameters());
        }
        return oAuthAuthorizationGrant;
    }

    private AuthorizationGrant getSAMLAuthorizationGrant(WSTrustResponse wSTrustResponse) throws UnsupportedEncodingException {
        SAML2BearerGrant sAML2BearerGrant = wSTrustResponse.isTokenSaml2() ? new SAML2BearerGrant(new Base64URL(Base64.getEncoder().encodeToString(wSTrustResponse.getToken().getBytes(StandardCharsets.UTF_8)))) : new SAML11BearerGrant(new Base64URL(Base64.getEncoder().encodeToString(wSTrustResponse.getToken().getBytes(StandardCharsets.UTF_8))));
        return sAML2BearerGrant;
    }

    private AuthorizationGrant getAuthorizationGrantIntegrated(String string) throws Exception {
        String string2 = this.clientApplication.authenticationAuthority.getUserRealmEndpoint(URLEncoder.encode(string, StandardCharsets.UTF_8.name()));
        UserDiscoveryResponse userDiscoveryResponse = UserDiscoveryRequest.execute(string2, this.msalRequest.headers().getReadonlyHeaderMap(), this.msalRequest.requestContext(), this.clientApplication.getServiceBundle());
        if (!userDiscoveryResponse.isAccountFederated() || !"WSTrust".equalsIgnoreCase(userDiscoveryResponse.federationProtocol())) {
            if (userDiscoveryResponse.isAccountManaged()) {
                throw new MsalClientException("Password is required for managed user", "password_required_for_managed_user");
            }
            throw new MsalClientException("User Realm request failed", "user_realm_discovery_failed");
        }
        String string3 = userDiscoveryResponse.federationMetadataUrl();
        String string4 = userDiscoveryResponse.cloudAudienceUrn();
        WSTrustResponse wSTrustResponse = WSTrustRequest.execute(string3, string4, this.msalRequest.requestContext(), this.clientApplication.getServiceBundle(), this.clientApplication.logPii());
        AuthorizationGrant authorizationGrant = this.getSAMLAuthorizationGrant(wSTrustResponse);
        return authorizationGrant;
    }
}

