/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.google.gson;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Iterator;
import java.util.NoSuchElementException;
import macromedia.jdbc.sqlserver.externals.com.google.gson.JsonElement;
import macromedia.jdbc.sqlserver.externals.com.google.gson.JsonIOException;
import macromedia.jdbc.sqlserver.externals.com.google.gson.JsonParseException;
import macromedia.jdbc.sqlserver.externals.com.google.gson.JsonSyntaxException;
import macromedia.jdbc.sqlserver.externals.com.google.gson.internal.Streams;
import macromedia.jdbc.sqlserver.externals.com.google.gson.stream.JsonReader;
import macromedia.jdbc.sqlserver.externals.com.google.gson.stream.JsonToken;
import macromedia.jdbc.sqlserver.externals.com.google.gson.stream.MalformedJsonException;

public final class JsonStreamParser
implements Iterator<JsonElement> {
    private final JsonReader parser;
    private final Object lock;

    public JsonStreamParser(String string) {
        this(new StringReader(string));
    }

    public JsonStreamParser(Reader reader) {
        this.parser = new JsonReader(reader);
        this.parser.setLenient(true);
        this.lock = new Object();
    }

    @Override
    public JsonElement next() throws JsonParseException {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        try {
            return Streams.parse(this.parser);
        }
        catch (StackOverflowError stackOverflowError) {
            throw new JsonParseException("Failed parsing JSON source to Json", stackOverflowError);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            throw new JsonParseException("Failed parsing JSON source to Json", outOfMemoryError);
        }
    }

    @Override
    public boolean hasNext() {
        Object object = this.lock;
        synchronized (object) {
            try {
                return this.parser.peek() != JsonToken.END_DOCUMENT;
            }
            catch (MalformedJsonException malformedJsonException) {
                throw new JsonSyntaxException(malformedJsonException);
            }
            catch (IOException iOException) {
                throw new JsonIOException(iOException);
            }
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

