/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.util;

import java.lang.reflect.InvocationTargetException;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.util.ClassUtil;

public class NativeImageUtil {
    private static final boolean RUNNING_IN_SVM = System.getProperty("org.graalvm.nativeimage.imagecode") != null;

    private NativeImageUtil() {
    }

    private static boolean isRunningInNativeImage() {
        return RUNNING_IN_SVM && "runtime".equals(System.getProperty("org.graalvm.nativeimage.imagecode"));
    }

    public static boolean isUnsupportedFeatureError(Throwable throwable) {
        if (!NativeImageUtil.isRunningInNativeImage()) {
            return false;
        }
        if (throwable instanceof InvocationTargetException) {
            throwable = throwable.getCause();
        }
        return throwable.getClass().getName().equals("com.oracle.svm.core.jdk.UnsupportedFeatureError");
    }

    public static boolean needsReflectionConfiguration(Class<?> clazz) {
        if (!NativeImageUtil.isRunningInNativeImage()) {
            return false;
        }
        return (clazz.getDeclaredFields().length == 0 || ClassUtil.isRecordType(clazz)) && clazz.getDeclaredMethods().length == 0 && clazz.getDeclaredConstructors().length == 0;
    }
}

