/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.node;

import java.io.IOException;
import java.io.Serializable;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.core.JsonGenerator;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.core.JsonParser;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.core.JsonPointer;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.core.JsonToken;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.core.ObjectCodec;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.JsonNode;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.SerializerProvider;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.node.ArrayNode;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.node.InternalNodeMapper;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.node.MissingNode;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.node.NodeSerialization;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.node.ObjectNode;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.node.TreeTraversingParser;

public abstract class BaseJsonNode
extends JsonNode
implements Serializable {
    private static final long serialVersionUID = 1L;

    Object writeReplace() {
        return NodeSerialization.from(this);
    }

    protected BaseJsonNode() {
    }

    @Override
    public final JsonNode findPath(String string) {
        JsonNode jsonNode = this.findValue(string);
        if (jsonNode == null) {
            return MissingNode.getInstance();
        }
        return jsonNode;
    }

    public abstract int hashCode();

    @Override
    public JsonNode required(String string) {
        return (JsonNode)this._reportRequiredViolation("Node of type `%s` has no fields", this.getClass().getSimpleName());
    }

    @Override
    public JsonNode required(int n2) {
        return (JsonNode)this._reportRequiredViolation("Node of type `%s` has no indexed values", this.getClass().getSimpleName());
    }

    @Override
    public JsonParser traverse() {
        return new TreeTraversingParser(this);
    }

    @Override
    public JsonParser traverse(ObjectCodec objectCodec) {
        return new TreeTraversingParser(this, objectCodec);
    }

    @Override
    public abstract JsonToken asToken();

    @Override
    public JsonParser.NumberType numberType() {
        return null;
    }

    @Override
    public ObjectNode withObject(JsonPointer jsonPointer, JsonNode.OverwriteMode overwriteMode, boolean bl2) {
        ObjectNode objectNode;
        if (jsonPointer.matches()) {
            if (this instanceof ObjectNode) {
                return (ObjectNode)this;
            }
            this._reportWrongNodeType("Can only call `withObject()` with empty JSON Pointer on `ObjectNode`, not `%s`", this.getClass().getName());
        }
        if ((objectNode = this._withObject(jsonPointer, jsonPointer, overwriteMode, bl2)) == null) {
            this._reportWrongNodeType("Cannot replace context node (of type `%s`) using `withObject()` with  JSON Pointer '%s'", this.getClass().getName(), jsonPointer);
        }
        return objectNode;
    }

    protected ObjectNode _withObject(JsonPointer jsonPointer, JsonPointer jsonPointer2, JsonNode.OverwriteMode overwriteMode, boolean bl2) {
        return null;
    }

    protected void _withXxxVerifyReplace(JsonPointer jsonPointer, JsonPointer jsonPointer2, JsonNode.OverwriteMode overwriteMode, boolean bl2, JsonNode jsonNode) {
        if (!this._withXxxMayReplace(jsonNode, overwriteMode)) {
            this._reportWrongNodeType("Cannot replace `JsonNode` of type `%s` for property \"%s\" in JSON Pointer \"%s\" (mode `OverwriteMode.%s`)", new Object[]{jsonNode.getClass().getName(), jsonPointer2.getMatchingProperty(), jsonPointer, overwriteMode});
        }
    }

    protected boolean _withXxxMayReplace(JsonNode jsonNode, JsonNode.OverwriteMode overwriteMode) {
        switch (overwriteMode) {
            case NONE: {
                return false;
            }
            case NULLS: {
                return jsonNode.isNull();
            }
            case SCALARS: {
                return !jsonNode.isContainerNode();
            }
        }
        return true;
    }

    @Override
    public ArrayNode withArray(JsonPointer jsonPointer, JsonNode.OverwriteMode overwriteMode, boolean bl2) {
        ArrayNode arrayNode;
        if (jsonPointer.matches()) {
            if (this instanceof ArrayNode) {
                return (ArrayNode)this;
            }
            this._reportWrongNodeType("Can only call `withArray()` with empty JSON Pointer on `ArrayNode`, not `%s`", this.getClass().getName());
        }
        if ((arrayNode = this._withArray(jsonPointer, jsonPointer, overwriteMode, bl2)) == null) {
            this._reportWrongNodeType("Cannot replace context node (of type `%s`) using `withArray()` with  JSON Pointer '%s'", this.getClass().getName(), jsonPointer);
        }
        return arrayNode;
    }

    protected ArrayNode _withArray(JsonPointer jsonPointer, JsonPointer jsonPointer2, JsonNode.OverwriteMode overwriteMode, boolean bl2) {
        return null;
    }

    @Override
    public abstract void serialize(JsonGenerator var1, SerializerProvider var2) throws IOException;

    @Override
    public abstract void serializeWithType(JsonGenerator var1, SerializerProvider var2, TypeSerializer var3) throws IOException;

    @Override
    public String toString() {
        return InternalNodeMapper.nodeToString(this);
    }

    @Override
    public String toPrettyString() {
        return InternalNodeMapper.nodeToPrettyString(this);
    }

    protected <T> T _reportWrongNodeType(String string, Object ... objectArray) {
        throw new UnsupportedOperationException(String.format(string, objectArray));
    }

    protected <T> T _reportWrongNodeOperation(String string, Object ... objectArray) {
        throw new UnsupportedOperationException(String.format(string, objectArray));
    }

    protected JsonPointer _jsonPointerIfValid(String string) {
        if (string.isEmpty() || string.charAt(0) == '/') {
            return JsonPointer.compile(string);
        }
        return null;
    }
}

