/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.introspect;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Modifier;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.JavaType;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.introspect.AnnotationMap;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.introspect.TypeResolutionContext;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.util.ClassUtil;

public final class AnnotatedField
extends AnnotatedMember
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected final transient Field _field;
    protected Serialization _serialization;

    public AnnotatedField(TypeResolutionContext typeResolutionContext, Field field, AnnotationMap annotationMap) {
        super(typeResolutionContext, annotationMap);
        this._field = field;
    }

    @Override
    public AnnotatedField withAnnotations(AnnotationMap annotationMap) {
        return new AnnotatedField(this._typeContext, this._field, annotationMap);
    }

    protected AnnotatedField(Serialization serialization) {
        super(null, null);
        this._field = null;
        this._serialization = serialization;
    }

    @Override
    public Field getAnnotated() {
        return this._field;
    }

    @Override
    public int getModifiers() {
        return this._field.getModifiers();
    }

    @Override
    public String getName() {
        return this._field.getName();
    }

    @Override
    public Class<?> getRawType() {
        return this._field.getType();
    }

    @Override
    public JavaType getType() {
        return this._typeContext.resolveType(this._field.getGenericType());
    }

    @Override
    public Class<?> getDeclaringClass() {
        return this._field.getDeclaringClass();
    }

    @Override
    public Member getMember() {
        return this._field;
    }

    @Override
    public void setValue(Object object, Object object2) throws IllegalArgumentException {
        try {
            this._field.set(object, object2);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IllegalArgumentException("Failed to setValue() for field " + this.getFullName() + ": " + illegalAccessException.getMessage(), illegalAccessException);
        }
    }

    @Override
    public Object getValue(Object object) throws IllegalArgumentException {
        try {
            return this._field.get(object);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IllegalArgumentException("Failed to getValue() for field " + this.getFullName() + ": " + illegalAccessException.getMessage(), illegalAccessException);
        }
    }

    public int getAnnotationCount() {
        return this._annotations.size();
    }

    public boolean isTransient() {
        return Modifier.isTransient(this.getModifiers());
    }

    @Override
    public int hashCode() {
        return this._field.getName().hashCode();
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!ClassUtil.hasClass(object, this.getClass())) {
            return false;
        }
        AnnotatedField annotatedField = (AnnotatedField)object;
        if (annotatedField._field == null) {
            return this._field == null;
        }
        return annotatedField._field.equals(this._field);
    }

    @Override
    public String toString() {
        return "[field " + this.getFullName() + "]";
    }

    Object writeReplace() {
        return new AnnotatedField(new Serialization(this._field));
    }

    Object readResolve() {
        Class<?> clazz = this._serialization.clazz;
        try {
            Field field = clazz.getDeclaredField(this._serialization.name);
            if (!field.isAccessible()) {
                ClassUtil.checkAndFixAccess(field, false);
            }
            return new AnnotatedField(null, field, null);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Could not find method '" + this._serialization.name + "' from Class '" + clazz.getName());
        }
    }

    private static final class Serialization
    implements Serializable {
        private static final long serialVersionUID = 1L;
        protected Class<?> clazz;
        protected String name;

        public Serialization(Field field) {
            this.clazz = field.getDeclaringClass();
            this.name = field.getName();
        }
    }
}

