/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.slbase;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import macromedia.jdbc.slbase.BaseBlob;
import macromedia.jdbc.slbase.BaseCharacterStreamWrapper;
import macromedia.jdbc.slbase.BaseClob;
import macromedia.jdbc.slbase.BaseConnection;
import macromedia.jdbc.slbase.BaseData;
import macromedia.jdbc.slbase.BaseInputStreamWrapper;
import macromedia.jdbc.slbase.BaseParameter;
import macromedia.jdbc.slbase.BasePreparedStatement;
import macromedia.jdbc.slbase.BaseTimestamp;

public final class BaseCallableStatement
extends BasePreparedStatement
implements CallableStatement {
    boolean lastGetWasNull = false;

    public BaseCallableStatement(BaseConnection baseConnection, String string, int n2, int n3) throws SQLException {
        super(baseConnection, string, n2, n3, false);
    }

    public int[] executeBatch() throws SQLException {
        if (this.currentParameters.anyOutputParamsRegistered()) {
            throw this.exceptions.getException(6092);
        }
        return super.executeBatch();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearParameters() throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            this.currentParameters.clearOutput(true);
            super.clearParameters();
        }
    }

    void preImplExecute() throws SQLException {
        this.currentParameters.clearOutput(false);
        super.preImplExecute();
    }

    public Array getArray(int n2) throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            String[] stringArray = new String[]{"CallableStatement.getArray"};
            throw this.exceptions.getException(6003, stringArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BigDecimal getBigDecimal(int n2) throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.state == 4 || this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            BaseParameter baseParameter = this.getAndValidateOutParameter(n2);
            this.lastGetWasNull = baseParameter.isNull();
            return baseParameter.getBigDecimal(this.exceptions);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BigDecimal getBigDecimal(int n2, int n3) throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.state == 4 || this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            BaseParameter baseParameter = this.getAndValidateOutParameter(n2);
            this.lastGetWasNull = baseParameter.isNull();
            return baseParameter.getBigDecimal(n3, this.exceptions);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Blob getBlob(int n2) throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.state == 4 || this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            BaseParameter baseParameter = this.getAndValidateOutParameter(n2);
            if (!(baseParameter.sqlType == 2004 || baseParameter.sqlType == -4 && this.connection.implConnection.enableXlobOnLongVarX())) {
                throw this.exceptions.getException(6008);
            }
            this.lastGetWasNull = baseParameter.isNull();
            return baseParameter.getBlob(this.connection, this.exceptions);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getBoolean(int n2) throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.state == 4 || this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            BaseParameter baseParameter = this.getAndValidateOutParameter(n2);
            this.lastGetWasNull = baseParameter.isNull();
            return baseParameter.getBoolean(this.exceptions);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte getByte(int n2) throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.state == 4 || this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            BaseParameter baseParameter = this.getAndValidateOutParameter(n2);
            this.lastGetWasNull = baseParameter.isNull();
            return baseParameter.getByte(this.exceptions);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getBytes(int n2) throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.state == 4 || this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            BaseParameter baseParameter = this.getAndValidateOutParameter(n2);
            this.lastGetWasNull = baseParameter.isNull();
            return baseParameter.getBytes(-1, baseParameter.getTransliterator(), this.exceptions);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Clob getClob(int n2) throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.state == 4 || this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            BaseParameter baseParameter = this.getAndValidateOutParameter(n2);
            if (!(baseParameter.sqlType == 2005 || baseParameter.sqlType == -10 || baseParameter.sqlType == -1 && this.connection.implConnection.enableXlobOnLongVarX())) {
                throw this.exceptions.getException(6008);
            }
            this.lastGetWasNull = baseParameter.isNull();
            return baseParameter.getClob(this.connection, this.exceptions);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Date getDate(int n2) throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.state == 4 || this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            BaseParameter baseParameter = this.getAndValidateOutParameter(n2);
            this.lastGetWasNull = baseParameter.isNull();
            return baseParameter.getDate(this.exceptions);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Date getDate(int n2, Calendar calendar) throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.state == 4 || this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            BaseParameter baseParameter = this.getAndValidateOutParameter(n2);
            this.lastGetWasNull = baseParameter.isNull();
            return baseParameter.getDate(calendar, this.exceptions);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getDouble(int n2) throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.state == 4 || this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            BaseParameter baseParameter = this.getAndValidateOutParameter(n2);
            this.lastGetWasNull = baseParameter.isNull();
            return baseParameter.getDouble(this.exceptions);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float getFloat(int n2) throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.state == 4 || this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            BaseParameter baseParameter = this.getAndValidateOutParameter(n2);
            this.lastGetWasNull = baseParameter.isNull();
            return baseParameter.getFloat(this.exceptions);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getInt(int n2) throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.state == 4 || this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            BaseParameter baseParameter = this.getAndValidateOutParameter(n2);
            this.lastGetWasNull = baseParameter.isNull();
            return baseParameter.getInteger(this.exceptions);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLong(int n2) throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.state == 4 || this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            BaseParameter baseParameter = this.getAndValidateOutParameter(n2);
            this.lastGetWasNull = baseParameter.isNull();
            return baseParameter.getLong(this.exceptions);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getObject(int n2) throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.state == 4 || this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            BaseParameter baseParameter = this.getAndValidateOutParameter(n2);
            this.lastGetWasNull = baseParameter.isNull();
            if (this.lastGetWasNull) {
                return null;
            }
            int n3 = BaseData.mapJDBCTypeToJavaObjectType(baseParameter.sqlType);
            return baseParameter.getObject(n3, -1, this.connection, this.exceptions);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getObject(int n2, Map map) throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            return this.getObject(n2);
        }
    }

    public Ref getRef(int n2) throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            String[] stringArray = new String[]{"CallableStatement.getRef"};
            throw this.exceptions.getException(6003, stringArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public short getShort(int n2) throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.state == 4 || this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            BaseParameter baseParameter = this.getAndValidateOutParameter(n2);
            this.lastGetWasNull = baseParameter.isNull();
            return baseParameter.getShort(this.exceptions);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getString(int n2) throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.state == 4 || this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            BaseParameter baseParameter = this.getAndValidateOutParameter(n2);
            this.lastGetWasNull = baseParameter.isNull();
            return baseParameter.getString(-1, this.exceptions);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Time getTime(int n2) throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.state == 4 || this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            BaseParameter baseParameter = this.getAndValidateOutParameter(n2);
            this.lastGetWasNull = baseParameter.isNull();
            return baseParameter.getTime(this.exceptions);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Time getTime(int n2, Calendar calendar) throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.state == 4 || this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            BaseParameter baseParameter = this.getAndValidateOutParameter(n2);
            this.lastGetWasNull = baseParameter.isNull();
            return baseParameter.getTime(calendar, this.exceptions);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Timestamp getTimestamp(int n2) throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.state == 4 || this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            BaseParameter baseParameter = this.getAndValidateOutParameter(n2);
            this.lastGetWasNull = baseParameter.isNull();
            if (this.lastGetWasNull) {
                return null;
            }
            return baseParameter.getTimestamp(this.exceptions).getTimestamp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Timestamp getTimestamp(int n2, Calendar calendar) throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.state == 4 || this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            BaseParameter baseParameter = this.getAndValidateOutParameter(n2);
            this.lastGetWasNull = baseParameter.isNull();
            if (this.lastGetWasNull) {
                return null;
            }
            return baseParameter.getTimestamp(calendar, this.exceptions).getTimestamp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerOutParameter(int n2, int n3) throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.state == 4 || this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            this.validateSqlType(n3);
            BaseParameter baseParameter = new BaseParameter(n3, 0, null, -1, this.connection);
            this.currentParameters.set(n2, 2, baseParameter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerOutParameter(int n2, int n3, int n4) throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.state == 4 || this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            this.validateSqlType(n3);
            BaseParameter baseParameter = new BaseParameter(n3, 0, null, n4, this.connection);
            this.currentParameters.set(n2, 2, baseParameter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerOutParameter(int n2, int n3, String string) throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            this.registerOutParameter(n2, n3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean wasNull() throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.state == 4 || this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            return this.lastGetWasNull;
        }
    }

    BaseParameter getAndValidateOutParameter(int n2) throws SQLException {
        BaseParameter baseParameter = this.currentParameters.get(n2, 2);
        if (baseParameter == null) {
            throw this.exceptions.getException(6010, "07009");
        }
        if (baseParameter.getType() == 0) {
            this.implStatement.getOutParameterData();
            if (baseParameter.getType() == 0) {
                this.closeCurrentResults(3, true);
                while (this.currentResultType != 1) {
                    if (this.currentResultType == 3) {
                        this.warnings.add(6084);
                    } else {
                        this.warnings.add(6083);
                    }
                    this.getNextResultType();
                }
                if (baseParameter.getType() == 0) {
                    throw this.exceptions.getException(6025);
                }
            }
        }
        return baseParameter;
    }

    BaseParameter getAndValidateOutParameter(String string) throws SQLException {
        BaseParameter baseParameter = this.currentParameters.get(string, 2);
        if (baseParameter == null) {
            throw this.exceptions.getException(6010, "07009");
        }
        if (baseParameter.getType() == 0) {
            this.implStatement.getOutParameterData();
            if (baseParameter.getType() == 0) {
                this.closeCurrentResults(3, true);
                while (this.currentResultType != 1) {
                    if (this.currentResultType == 3) {
                        this.warnings.add(6084);
                    } else {
                        this.warnings.add(6083);
                    }
                    this.getNextResultType();
                }
                if (baseParameter.getType() == 0) {
                    throw this.exceptions.getException(6025);
                }
            }
        }
        return baseParameter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerOutParameter(String string, int n2) throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.connection.getMetaData().supportsNamedParameters()) {
                if (this.state == 4 || this.connection.implConnection == null) {
                    throw this.exceptions.getException(6009);
                }
            } else {
                String[] stringArray = new String[]{"CallableStatement.registerOutParameter"};
                throw this.exceptions.getException(6003, stringArray);
            }
            this.validateSqlType(n2);
            BaseParameter baseParameter = new BaseParameter(n2, 0, null, -1, this.connection);
            this.currentParameters.set(string, 2, baseParameter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerOutParameter(String string, int n2, int n3) throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.connection.getMetaData().supportsNamedParameters()) {
                if (this.state == 4 || this.connection.implConnection == null) {
                    throw this.exceptions.getException(6009);
                }
            } else {
                String[] stringArray = new String[]{"CallableStatement.registerOutParameter"};
                throw this.exceptions.getException(6003, stringArray);
            }
            this.validateSqlType(n2);
            BaseParameter baseParameter = new BaseParameter(n2, 0, null, n3, this.connection);
            this.currentParameters.set(string, 2, baseParameter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerOutParameter(String string, int n2, String string2) throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            this.registerOutParameter(string, n2);
        }
    }

    public void setURL(String string, URL uRL) throws SQLException {
        String[] stringArray = new String[]{"CallableStatement.setURL"};
        throw this.exceptions.getException(6003, stringArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setNull(String string, int n2) throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.state == 4 || this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            if (!this.connection.getMetaData().supportsNamedParameters()) {
                String[] stringArray = new String[]{"CallableStatement.setNull"};
                throw this.exceptions.getException(6003, stringArray);
            }
            this.setObjectInternal(string, null, BaseData.mapJDBCTypeToJavaObjectType(n2), n2, -1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setBoolean(String string, boolean bl2) throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            BaseParameter baseParameter;
            if (this.state == 4 || this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            if (this.connection.getMetaData().supportsNamedParameters()) {
                baseParameter = this.currentParameters.getParameter(string);
                if (baseParameter.sqlType != -7) {
                    this.currentParameters.newParameterBindings = true;
                }
            } else {
                String[] stringArray = new String[]{"CallableStatement.setBoolean"};
                throw this.exceptions.getException(6003, stringArray);
            }
            baseParameter.setBoolean(bl2);
            baseParameter.sqlType = -7;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setByte(String string, byte by2) throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            BaseParameter baseParameter;
            if (this.state == 4 || this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            if (this.connection.getMetaData().supportsNamedParameters()) {
                baseParameter = this.currentParameters.getParameter(string);
                if (baseParameter.sqlType != -6) {
                    this.currentParameters.newParameterBindings = true;
                }
            } else {
                String[] stringArray = new String[]{"CallableStatement.setByte"};
                throw this.exceptions.getException(6003, stringArray);
            }
            baseParameter.setByte(by2);
            baseParameter.sqlType = -6;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setShort(String string, short s2) throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            BaseParameter baseParameter;
            if (this.state == 4 || this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            if (this.connection.getMetaData().supportsNamedParameters()) {
                baseParameter = this.currentParameters.getParameter(string);
                if (baseParameter.sqlType != 5) {
                    this.currentParameters.newParameterBindings = true;
                }
            } else {
                String[] stringArray = new String[]{"CallableStatement.setShort"};
                throw this.exceptions.getException(6003, stringArray);
            }
            baseParameter.setShort(s2);
            baseParameter.sqlType = 5;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setInt(String string, int n2) throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            BaseParameter baseParameter;
            if (this.state == 4 || this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            if (this.connection.getMetaData().supportsNamedParameters()) {
                baseParameter = this.currentParameters.getParameter(string);
                if (baseParameter.sqlType != 4) {
                    this.currentParameters.newParameterBindings = true;
                }
            } else {
                String[] stringArray = new String[]{"CallableStatement.setInt"};
                throw this.exceptions.getException(6003, stringArray);
            }
            baseParameter.setInteger(n2);
            baseParameter.sqlType = 4;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setLong(String string, long l2) throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            BaseParameter baseParameter;
            if (this.state == 4 || this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            if (this.connection.getMetaData().supportsNamedParameters()) {
                baseParameter = this.currentParameters.getParameter(string);
                if (baseParameter.sqlType != -5) {
                    this.currentParameters.newParameterBindings = true;
                }
            } else {
                String[] stringArray = new String[]{"CallableStatement.setLong"};
                throw this.exceptions.getException(6003, stringArray);
            }
            baseParameter.setLong(l2);
            baseParameter.sqlType = -5;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setFloat(String string, float f2) throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            BaseParameter baseParameter;
            if (this.state == 4 || this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            if (this.connection.getMetaData().supportsNamedParameters()) {
                baseParameter = this.currentParameters.getParameter(string);
                if (baseParameter.sqlType != 7) {
                    this.currentParameters.newParameterBindings = true;
                }
            } else {
                String[] stringArray = new String[]{"CallableStatement.setFloat"};
                throw this.exceptions.getException(6003, stringArray);
            }
            baseParameter.setFloat(f2);
            baseParameter.sqlType = 7;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setDouble(String string, double d2) throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            BaseParameter baseParameter;
            if (this.state == 4 || this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            if (this.connection.getMetaData().supportsNamedParameters()) {
                baseParameter = this.currentParameters.getParameter(string);
                if (baseParameter.sqlType != 8) {
                    this.currentParameters.newParameterBindings = true;
                }
            } else {
                String[] stringArray = new String[]{"CallableStatement.setDouble"};
                throw this.exceptions.getException(6003, stringArray);
            }
            baseParameter.setDouble(d2);
            baseParameter.sqlType = 8;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setBigDecimal(String string, BigDecimal bigDecimal) throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.state == 4 || this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            if (!this.connection.getMetaData().supportsNamedParameters()) {
                String[] stringArray = new String[]{"CallableStatement.setBigDecimal"};
                throw this.exceptions.getException(6003, stringArray);
            }
            this.setObjectInternal(string, bigDecimal, 8, 2, -1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setString(String string, String string2) throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.state == 4 || this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            if (!this.connection.getMetaData().supportsNamedParameters()) {
                String[] stringArray = new String[]{"CallableStatement.setString"};
                throw this.exceptions.getException(6003, stringArray);
            }
            this.setObjectInternal(string, string2, 10, 12, -1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setBytes(String string, byte[] byArray) throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.state == 4 || this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            if (!this.connection.getMetaData().supportsNamedParameters()) {
                String[] stringArray = new String[]{"CallableStatement.setBytes"};
                throw this.exceptions.getException(6003, stringArray);
            }
            this.setObjectInternal(string, byArray, 2, -3, -1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setDate(String string, Date date) throws SQLException {
        if (date != null) {
            date = (Date)date.clone();
        }
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.state == 4 || this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            if (!this.connection.getMetaData().supportsNamedParameters()) {
                String[] stringArray = new String[]{"CallableStatement.setDate"};
                throw this.exceptions.getException(6003, stringArray);
            }
            this.setObjectInternal(string, date, 11, 91, -1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setTime(String string, Time time) throws SQLException {
        if (time != null) {
            time = (Time)time.clone();
        }
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.state == 4 || this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            if (!this.connection.getMetaData().supportsNamedParameters()) {
                String[] stringArray = new String[]{"CallableStatement.setTime"};
                throw this.exceptions.getException(6003, stringArray);
            }
            this.setObjectInternal(string, time, 12, 92, -1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setTime(String string, Time time, Calendar calendar) throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.state == 4 || this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            if (!this.connection.getMetaData().supportsNamedParameters()) {
                String[] stringArray = new String[]{"CallableStatement.setTime"};
                throw this.exceptions.getException(6003, stringArray);
            }
            this.setObjectInternal(string, BaseData.applyCalender(time, calendar, true), 12, 92, -1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setTimestamp(String string, Timestamp timestamp) throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.state == 4 || this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            if (this.connection.getMetaData().supportsNamedParameters()) {
                if (timestamp == null) {
                    this.setObjectInternal(string, null, 13, 93, -1);
                } else {
                    this.setObjectInternal(string, new BaseTimestamp(timestamp, null), 13, 93, -1);
                }
            } else {
                String[] stringArray = new String[]{"CallableStatement.setTimestamp"};
                throw this.exceptions.getException(6003, stringArray);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setTimestamp(String string, Timestamp timestamp, Calendar calendar) throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.state == 4 || this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            if (this.connection.getMetaData().supportsNamedParameters()) {
                if (timestamp == null) {
                    this.setObjectInternal(string, null, 13, 93, -1);
                } else {
                    this.setObjectInternal(string, new BaseTimestamp(timestamp, calendar), 13, 93, -1);
                }
            } else {
                String[] stringArray = new String[]{"CallableStatement.setTimestamp"};
                throw this.exceptions.getException(6003, stringArray);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setAsciiStream(String string, InputStream inputStream, int n2) throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.state == 4 || this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            if (this.connection.getMetaData().supportsNamedParameters()) {
                if (inputStream != null) {
                    BaseInputStreamWrapper baseInputStreamWrapper = new BaseInputStreamWrapper(inputStream, n2, this.connection, this.exceptions);
                    baseInputStreamWrapper.setIsInputStream();
                    this.setObjectInternal(string, baseInputStreamWrapper, 15, -1, -1);
                } else {
                    this.setObjectInternal(string, null, 15, -1, -1);
                }
            } else {
                String[] stringArray = new String[]{"CallableStatement.setAsciiStream"};
                throw this.exceptions.getException(6003, stringArray);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setBinaryStream(String string, InputStream inputStream, int n2) throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.state == 4 || this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            if (this.connection.getMetaData().supportsNamedParameters()) {
                if (inputStream != null) {
                    BaseInputStreamWrapper baseInputStreamWrapper = new BaseInputStreamWrapper(inputStream, n2, this.connection, this.exceptions);
                    baseInputStreamWrapper.setIsInputStream();
                    this.setObjectInternal(string, baseInputStreamWrapper, 14, -4, -1);
                } else {
                    this.setObjectInternal(string, null, 14, -4, -1);
                }
            } else {
                String[] stringArray = new String[]{"CallableStatement.setBinaryStream"};
                throw this.exceptions.getException(6003, stringArray);
            }
        }
    }

    private final void setObjectInternal(String string, Object object, int n2, int n3, int n4) throws SQLException {
        BaseData baseData;
        this.validateSqlType(n3);
        if (n4 != -1 && (n3 == 3 || n3 == 2)) {
            baseData = new BaseData(n2, object, this.connection);
            object = baseData.getBigDecimal(n4, this.exceptions);
            n2 = 8;
            n4 = -1;
        }
        baseData = this.currentParameters.getParameter(string);
        if (((BaseParameter)baseData).sqlType != n3) {
            ((BaseParameter)baseData).sqlType = n3;
            this.currentParameters.newParameterBindings = true;
        }
        baseData.setData(n2, object);
        ((BaseParameter)baseData).scale = n4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setObject(String string, Object object, int n2, int n3) throws SQLException {
        Object object2 = this.synchronizer;
        synchronized (object2) {
            if (this.state == 4 || this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            if (this.connection.getMetaData().supportsNamedParameters()) {
                int n4 = BaseData.getJavaObjectType(object, n2);
                if (n4 == 0) {
                    throw this.exceptions.getException(6069);
                }
                if (!(n4 != 20 || object instanceof BaseClob && ((BaseClob)object).connection == this.connection)) {
                    this.setCharacterStream(string, ((Clob)object).getCharacterStream(), (int)((Clob)object).length());
                } else if (!(n4 != 19 || object instanceof BaseBlob && ((BaseBlob)object).connection == this.connection)) {
                    this.setBinaryStream(string, ((Blob)object).getBinaryStream(), (int)((Blob)object).length());
                } else {
                    if (n4 == 13) {
                        if (object != null) {
                            object = new BaseTimestamp((Timestamp)object, null);
                        }
                    } else {
                        object = this.wrapStreamFromSetObject(object);
                    }
                    this.setObjectInternal(string, object, n4, n2, n3);
                }
            } else {
                String[] stringArray = new String[]{"CallableStatement.setObject"};
                throw this.exceptions.getException(6003, stringArray);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setObject(String string, Object object, int n2) throws SQLException {
        Object object2 = this.synchronizer;
        synchronized (object2) {
            if (this.state == 4 || this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            if (this.connection.getMetaData().supportsNamedParameters()) {
                int n3 = BaseData.getJavaObjectType(object, n2);
                if (n3 == 0) {
                    throw this.exceptions.getException(6033);
                }
                if (!(n3 != 20 || object instanceof BaseClob && ((BaseClob)object).connection == this.connection)) {
                    this.setCharacterStream(string, ((Clob)object).getCharacterStream(), (int)((Clob)object).length());
                } else if (!(n3 != 19 || object instanceof BaseBlob && ((BaseBlob)object).connection == this.connection)) {
                    this.setBinaryStream(string, ((Blob)object).getBinaryStream(), (int)((Blob)object).length());
                } else {
                    if (n3 == 13) {
                        if (object != null) {
                            object = new BaseTimestamp((Timestamp)object, null);
                        }
                    } else {
                        object = this.wrapStreamFromSetObject(object);
                    }
                    this.setObjectInternal(string, object, n3, n2, -1);
                }
            } else {
                String[] stringArray = new String[]{"CallableStatement.setObject"};
                throw this.exceptions.getException(6003, stringArray);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setObject(String string, Object object) throws SQLException {
        Object object2 = this.synchronizer;
        synchronized (object2) {
            if (this.state == 4 || this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            if (this.connection.getMetaData().supportsNamedParameters()) {
                int n2 = BaseData.getJavaObjectType(object, 0);
                if (n2 == 0) {
                    throw this.exceptions.getException(6033);
                }
                if (!(n2 != 20 || object instanceof BaseClob && ((BaseClob)object).connection == this.connection)) {
                    this.setCharacterStream(string, ((Clob)object).getCharacterStream(), (int)((Clob)object).length());
                } else if (!(n2 != 19 || object instanceof BaseBlob && ((BaseBlob)object).connection == this.connection)) {
                    this.setBinaryStream(string, ((Blob)object).getBinaryStream(), (int)((Blob)object).length());
                } else {
                    object = n2 == 13 ? new BaseTimestamp((Timestamp)object, null) : this.wrapStreamFromSetObject(object);
                    this.setObjectInternal(string, object, n2, this.implStatement.implConnection.mapJavaTypeToSQLType(n2), -1);
                }
            } else {
                String[] stringArray = new String[]{"CallableStatement.setObject"};
                throw this.exceptions.getException(6003, stringArray);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setCharacterStream(String string, Reader reader, int n2) throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.state == 4 || this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            if (this.connection.getMetaData().supportsNamedParameters()) {
                if (reader != null) {
                    BaseCharacterStreamWrapper baseCharacterStreamWrapper = new BaseCharacterStreamWrapper(reader, n2, this.connection, this.exceptions);
                    baseCharacterStreamWrapper.setIsInputStream();
                    this.setObjectInternal(string, baseCharacterStreamWrapper, 18, -1, -1);
                } else {
                    this.setObjectInternal(string, null, 18, -1, -1);
                }
            } else {
                String[] stringArray = new String[]{"CallableStatement.setCharacterStream"};
                throw this.exceptions.getException(6003, stringArray);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setDate(String string, Date date, Calendar calendar) throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.state == 4 || this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            if (!this.connection.getMetaData().supportsNamedParameters()) {
                String[] stringArray = new String[]{"CallableStatement.setDate"};
                throw this.exceptions.getException(6003, stringArray);
            }
            this.setObjectInternal(string, BaseData.applyCalender(date, calendar, true), 11, 91, -1);
        }
    }

    public final void setNull(String string, int n2, String string2) throws SQLException {
        this.setNull(string, n2);
    }

    public String getString(String string) throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.state == 4 || this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            if (this.connection.getMetaData().supportsNamedParameters()) {
                BaseParameter baseParameter = this.getAndValidateOutParameter(string);
                this.lastGetWasNull = baseParameter.isNull();
                return baseParameter.getString(-1, this.exceptions);
            }
            String[] stringArray = new String[]{"CallableStatement.getString"};
            throw this.exceptions.getException(6003, stringArray);
        }
    }

    public boolean getBoolean(String string) throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.state == 4 || this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            if (this.connection.getMetaData().supportsNamedParameters()) {
                BaseParameter baseParameter = this.getAndValidateOutParameter(string);
                this.lastGetWasNull = baseParameter.isNull();
                return baseParameter.getBoolean(this.exceptions);
            }
            String[] stringArray = new String[]{"CallableStatement.getBoolean"};
            throw this.exceptions.getException(6003, stringArray);
        }
    }

    public byte getByte(String string) throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.state == 4 || this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            if (this.connection.getMetaData().supportsNamedParameters()) {
                BaseParameter baseParameter = this.getAndValidateOutParameter(string);
                this.lastGetWasNull = baseParameter.isNull();
                return baseParameter.getByte(this.exceptions);
            }
            String[] stringArray = new String[]{"CallableStatement.getByte"};
            throw this.exceptions.getException(6003, stringArray);
        }
    }

    public short getShort(String string) throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.state == 4 || this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            if (this.connection.getMetaData().supportsNamedParameters()) {
                BaseParameter baseParameter = this.getAndValidateOutParameter(string);
                this.lastGetWasNull = baseParameter.isNull();
                return baseParameter.getShort(this.exceptions);
            }
            String[] stringArray = new String[]{"CallableStatement.getShort"};
            throw this.exceptions.getException(6003, stringArray);
        }
    }

    public int getInt(String string) throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.state == 4 || this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            if (this.connection.getMetaData().supportsNamedParameters()) {
                BaseParameter baseParameter = this.getAndValidateOutParameter(string);
                this.lastGetWasNull = baseParameter.isNull();
                return baseParameter.getInteger(this.exceptions);
            }
            String[] stringArray = new String[]{"CallableStatement.getInt"};
            throw this.exceptions.getException(6003, stringArray);
        }
    }

    public long getLong(String string) throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.state == 4 || this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            if (this.connection.getMetaData().supportsNamedParameters()) {
                BaseParameter baseParameter = this.getAndValidateOutParameter(string);
                this.lastGetWasNull = baseParameter.isNull();
                return baseParameter.getLong(this.exceptions);
            }
            String[] stringArray = new String[]{"CallableStatement.getLong"};
            throw this.exceptions.getException(6003, stringArray);
        }
    }

    public float getFloat(String string) throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.state == 4 || this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            if (this.connection.getMetaData().supportsNamedParameters()) {
                BaseParameter baseParameter = this.getAndValidateOutParameter(string);
                this.lastGetWasNull = baseParameter.isNull();
                return baseParameter.getFloat(this.exceptions);
            }
            String[] stringArray = new String[]{"CallableStatement.getFloat"};
            throw this.exceptions.getException(6003, stringArray);
        }
    }

    public double getDouble(String string) throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.state == 4 || this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            if (this.connection.getMetaData().supportsNamedParameters()) {
                BaseParameter baseParameter = this.getAndValidateOutParameter(string);
                this.lastGetWasNull = baseParameter.isNull();
                return baseParameter.getDouble(this.exceptions);
            }
            String[] stringArray = new String[]{"CallableStatement.getDouble"};
            throw this.exceptions.getException(6003, stringArray);
        }
    }

    public byte[] getBytes(String string) throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.state == 4 || this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            if (this.connection.getMetaData().supportsNamedParameters()) {
                BaseParameter baseParameter = this.getAndValidateOutParameter(string);
                this.lastGetWasNull = baseParameter.isNull();
                return baseParameter.getBytes(-1, baseParameter.getTransliterator(), this.exceptions);
            }
            String[] stringArray = new String[]{"CallableStatement.getBytes"};
            throw this.exceptions.getException(6003, stringArray);
        }
    }

    public Date getDate(String string) throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.state == 4 || this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            if (this.connection.getMetaData().supportsNamedParameters()) {
                BaseParameter baseParameter = this.getAndValidateOutParameter(string);
                this.lastGetWasNull = baseParameter.isNull();
                return baseParameter.getDate(this.exceptions);
            }
            String[] stringArray = new String[]{"CallableStatement.getDate"};
            throw this.exceptions.getException(6003, stringArray);
        }
    }

    public Time getTime(String string) throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.state == 4 || this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            if (this.connection.getMetaData().supportsNamedParameters()) {
                BaseParameter baseParameter = this.getAndValidateOutParameter(string);
                this.lastGetWasNull = baseParameter.isNull();
                return baseParameter.getTime(this.exceptions);
            }
            String[] stringArray = new String[]{"CallableStatement.getTime"};
            throw this.exceptions.getException(6003, stringArray);
        }
    }

    public Timestamp getTimestamp(String string) throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.state == 4 || this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            if (this.connection.getMetaData().supportsNamedParameters()) {
                BaseParameter baseParameter = this.getAndValidateOutParameter(string);
                this.lastGetWasNull = baseParameter.isNull();
                if (this.lastGetWasNull) {
                    return null;
                }
                return baseParameter.getTimestamp(this.exceptions).getTimestamp();
            }
            String[] stringArray = new String[]{"CallableStatement.getTimestamp"};
            throw this.exceptions.getException(6003, stringArray);
        }
    }

    public Object getObject(String string) throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.state == 4 || this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            if (this.connection.getMetaData().supportsNamedParameters()) {
                BaseParameter baseParameter = this.getAndValidateOutParameter(string);
                this.lastGetWasNull = baseParameter.isNull();
                if (this.lastGetWasNull) {
                    return null;
                }
                int n2 = BaseData.mapJDBCTypeToJavaObjectType(baseParameter.sqlType);
                return baseParameter.getObject(n2, -1, this.connection, this.exceptions);
            }
            String[] stringArray = new String[]{"CallableStatement.getObject"};
            throw this.exceptions.getException(6003, stringArray);
        }
    }

    public BigDecimal getBigDecimal(String string) throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.state == 4 || this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            if (this.connection.getMetaData().supportsNamedParameters()) {
                BaseParameter baseParameter = this.getAndValidateOutParameter(string);
                this.lastGetWasNull = baseParameter.isNull();
                return baseParameter.getBigDecimal(this.exceptions);
            }
            String[] stringArray = new String[]{"CallableStatement.getBigDecimal"};
            throw this.exceptions.getException(6003, stringArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getObject(String string, Map map) throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            return this.getObject(string);
        }
    }

    public Ref getRef(String string) throws SQLException {
        String[] stringArray = new String[]{"CallableStatement.getRef"};
        throw this.exceptions.getException(6003, stringArray);
    }

    public Blob getBlob(String string) throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.state == 4 || this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            if (this.connection.getMetaData().supportsNamedParameters()) {
                BaseParameter baseParameter = this.getAndValidateOutParameter(string);
                if (!(baseParameter.sqlType == 2004 || baseParameter.sqlType == -4 && this.connection.implConnection.enableXlobOnLongVarX())) {
                    throw this.exceptions.getException(6008);
                }
                this.lastGetWasNull = baseParameter.isNull();
                return baseParameter.getBlob(this.connection, this.exceptions);
            }
            String[] stringArray = new String[]{"CallableStatement.getBlob"};
            throw this.exceptions.getException(6003, stringArray);
        }
    }

    public Clob getClob(String string) throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.state == 4 || this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            if (this.connection.getMetaData().supportsNamedParameters()) {
                BaseParameter baseParameter = this.getAndValidateOutParameter(string);
                if (!(baseParameter.sqlType == 2005 || baseParameter.sqlType == -10 || baseParameter.sqlType == -1 && this.connection.implConnection.enableXlobOnLongVarX())) {
                    throw this.exceptions.getException(6008);
                }
                this.lastGetWasNull = baseParameter.isNull();
                return baseParameter.getClob(this.connection, this.exceptions);
            }
            String[] stringArray = new String[]{"CallableStatement.getClob"};
            throw this.exceptions.getException(6003, stringArray);
        }
    }

    public Array getArray(String string) throws SQLException {
        String[] stringArray = new String[]{"CallableStatement.getArray"};
        throw this.exceptions.getException(6003, stringArray);
    }

    public Date getDate(String string, Calendar calendar) throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.state == 4 || this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            if (this.connection.getMetaData().supportsNamedParameters()) {
                BaseParameter baseParameter = this.getAndValidateOutParameter(string);
                this.lastGetWasNull = baseParameter.isNull();
                return baseParameter.getDate(calendar, this.exceptions);
            }
            String[] stringArray = new String[]{"CallableStatement.getDate"};
            throw this.exceptions.getException(6003, stringArray);
        }
    }

    public Time getTime(String string, Calendar calendar) throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.state == 4 || this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            if (this.connection.getMetaData().supportsNamedParameters()) {
                BaseParameter baseParameter = this.getAndValidateOutParameter(string);
                this.lastGetWasNull = baseParameter.isNull();
                return baseParameter.getTime(calendar, this.exceptions);
            }
            String[] stringArray = new String[]{"CallableStatement.getTime"};
            throw this.exceptions.getException(6003, stringArray);
        }
    }

    public Timestamp getTimestamp(String string, Calendar calendar) throws SQLException {
        Object object = this.synchronizer;
        synchronized (object) {
            if (this.state == 4 || this.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
            if (this.connection.getMetaData().supportsNamedParameters()) {
                BaseParameter baseParameter = this.getAndValidateOutParameter(string);
                this.lastGetWasNull = baseParameter.isNull();
                if (this.lastGetWasNull) {
                    return null;
                }
                return baseParameter.getTimestamp(calendar, this.exceptions).getTimestamp();
            }
            String[] stringArray = new String[]{"CallableStatement.getTimestamp"};
            throw this.exceptions.getException(6003, stringArray);
        }
    }

    public URL getURL(int n2) throws SQLException {
        String[] stringArray = new String[]{"CallableStatement.getURL"};
        throw this.exceptions.getException(6003, stringArray);
    }

    public URL getURL(String string) throws SQLException {
        String[] stringArray = new String[]{"CallableStatement.getURL"};
        throw this.exceptions.getException(6003, stringArray);
    }
}

