/*
 * Decompiled with CFR 0.152.
 */
package ice.pilots.html4.swing;

import ice.pilots.html4.CSSAttribs;
import ice.pilots.html4.DAttr;
import ice.pilots.html4.DElement;
import ice.pilots.html4.DInputElement;
import ice.pilots.html4.ObjectBox;
import ice.pilots.html4.ObjectPainter;
import ice.pilots.html4.swing.DocView;
import ice.pilots.html4.swing.Movable;
import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JInternalFrame;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

class FormInputUpload
extends JPanel
implements ObjectPainter,
DocumentListener,
Movable,
ActionListener {
    private DocView docView;
    private DInputElement element;
    private ObjectBox box;
    private JTextField tfield = null;
    private JButton button = null;
    private JInternalFrame fileframe = null;
    private JFileChooser dialog = null;
    private int maxLength = 100;
    private String startValue;

    FormInputUpload(DocView docView, DElement e) {
        this.docView = docView;
        this.element = (DInputElement)e;
        this.tfield = new JTextField();
        this.button = new JButton("Browse");
        this.dialog = new JFileChooser(".");
        this.fileframe = new JInternalFrame();
        this.checkAttributes();
        int sz = this.element.getAttributeAsInt("size");
        if (sz <= 0) {
            sz = 20;
        }
        this.tfield.setColumns(sz);
        this.setLayout(new BorderLayout());
        this.add((Component)this.tfield, "Center");
        this.add((Component)this.button, "East");
        this.tfield.setBackground(Color.white);
        this.tfield.setFont(new Font("Monospaced", 0, 12));
        this.enableEvents(28L);
        this.button.addActionListener(this);
        this.tfield.getDocument().addDocumentListener(this);
        this.validate();
    }

    public void paintComponent(Graphics g) {
        if (this.isShowing()) {
            super.paintComponent(g);
        }
    }

    public void paintChildren(Graphics g) {
        if (this.isShowing()) {
            super.paintChildren(g);
        } else {
            this.button.setBounds(154, 5, 78, 26);
            this.tfield.setBounds(5, 7, 144, 21);
            g.setColor(Color.lightGray);
            g.drawRect(0, 0, this.tfield.getBounds().width + 2, this.tfield.getBounds().height + 2);
            g.translate(1, 1);
            this.tfield.paint(g);
            g.translate(this.tfield.getBounds().width + 2, -1);
            String text = this.button.getText();
            g.setFont(this.button.getFont());
            FontMetrics fontMetrics = g.getFontMetrics();
            fontMetrics = this.getFontMetrics(this.getFont());
            int height = fontMetrics.getDescent();
            int width = fontMetrics.stringWidth(text);
            g.setColor(Color.lightGray);
            g.fill3DRect(0, 0, this.button.getBounds().width, this.button.getBounds().height - 2, true);
            if (!this.element.getDisabled()) {
                g.setColor(Color.black);
            } else {
                g.setColor(Color.gray);
            }
            g.drawString(text, (this.button.getBounds().width - width) / 2, this.button.getBounds().height / 2 + height);
        }
    }

    private void checkAttributes() {
        String s;
        this.tfield.setEditable(!this.element.getReadOnly());
        this.tfield.setEnabled(!this.element.getDisabled());
        int i = this.element.getMaxLength();
        if (i != 0) {
            this.maxLength = i;
        }
        if ((s = this.element.getValue()) != null && !s.equals(this.tfield.getText())) {
            this.tfield.setText(s);
        }
    }

    public void insertUpdate(DocumentEvent e) {
        this.element.setValue(this.tfield.getText());
    }

    public void removeUpdate(DocumentEvent e) {
        this.element.setValue(this.tfield.getText());
    }

    public void changedUpdate(DocumentEvent e) {
        this.element.setValue(this.tfield.getText());
    }

    public void onElementAttrChange(DElement elem, DAttr attr) {
        this.checkAttributes();
    }

    public void dispose() {
        Container c = this.getParent();
        if (c != null) {
            c.remove(this);
        }
    }

    public void setBox(ObjectBox box) {
        this.box = box;
        this.docView.checkAwtTree(box, this);
    }

    public ObjectBox getBox() {
        return this.box;
    }

    public int getPrefWidth() {
        return this.getPreferredSize().width;
    }

    public int getPrefHeight() {
        return this.getPreferredSize().height;
    }

    public void setPainterSize(int w, int h) {
        this.setSize(w, h);
    }

    public boolean getFocusTraversalKeysEnabled() {
        return false;
    }

    public boolean isFocusable() {
        return true;
    }

    public boolean isFocusTraversable() {
        return false;
    }

    public void draw(Graphics g) {
        if (this.isVisible()) {
            return;
        }
        g.setColor(Color.lightGray);
        g.drawRect(0, 0, this.getSize().width - 1, this.getSize().height - 1);
    }

    public void syncDom(int x, int y, boolean visible) {
        this.setLocation(x, y);
        if (!this.isValid()) {
            this.validate();
        }
        this.setVisible(visible);
    }

    public void actionPerformed(ActionEvent e) {
        int result;
        this.dialog.setDialogType(0);
        this.dialog.setFileSelectionMode(0);
        File selectedFile = null;
        if (this.tfield.getText().length() != 0) {
            selectedFile = new File(this.tfield.getText());
        }
        if (selectedFile != null) {
            this.dialog.setSelectedFile(selectedFile);
        }
        if ((result = this.dialog.showDialog(this.fileframe, "Choose")) == 0 && (selectedFile = this.dialog.getSelectedFile()) != null) {
            String filename = selectedFile.toString();
            this.tfield.setText(filename);
        }
    }

    protected void processEvent(AWTEvent e) {
        if (this.docView.onComponentEvent(this, e)) {
            super.processEvent(e);
        }
    }

    protected void processFocusEvent(FocusEvent e) {
        int id = e.getID();
        if (id == 1004) {
            this.processFocusGained(e);
        } else if (id == 1005) {
            this.processFocusLost(e);
        }
        super.processFocusEvent(e);
    }

    private void processFocusGained(FocusEvent e) {
        if (this.startValue == null) {
            this.startValue = this.tfield.getText();
        }
    }

    private void processFocusLost(FocusEvent e) {
        if (e.isTemporary()) {
            return;
        }
        String tmp = this.tfield.getText();
        if (!tmp.equals(this.startValue)) {
            this.element.dispatchChange();
        }
        this.startValue = null;
    }

    public void setBorderVisible(boolean aDrawBorder) {
    }

    public void setFontHints(CSSAttribs css) {
    }

    public int getClientHeight() {
        Border b = this.getBorder();
        Insets i = b.getBorderInsets(this);
        return this.getHeight() - i.top - i.bottom;
    }

    public int getClientWidth() {
        Border b = this.getBorder();
        Insets i = b.getBorderInsets(this);
        return this.getWidth() - i.left - i.right;
    }
}

