/*
 * Decompiled with CFR 0.152.
 */
package ice.pilots.html4;

import ice.debug.Debug;
import ice.pilots.html4.AccessPosition;
import ice.pilots.html4.BlockBox;
import ice.pilots.html4.BoxList;
import ice.pilots.html4.ButtonBox;
import ice.pilots.html4.CSSAttribs;
import ice.pilots.html4.CSSBox;
import ice.pilots.html4.CSSCounters;
import ice.pilots.html4.CSSDecl;
import ice.pilots.html4.CSSLookup;
import ice.pilots.html4.CSSMatcher;
import ice.pilots.html4.CSSUtil;
import ice.pilots.html4.DAnchorElement;
import ice.pilots.html4.DAreaElement;
import ice.pilots.html4.DAttr;
import ice.pilots.html4.DDocument;
import ice.pilots.html4.DElement;
import ice.pilots.html4.DInputElement;
import ice.pilots.html4.DMapElement;
import ice.pilots.html4.DMutationEvent;
import ice.pilots.html4.DNode;
import ice.pilots.html4.DNodeList;
import ice.pilots.html4.DOMEvent;
import ice.pilots.html4.DOMUIEvent;
import ice.pilots.html4.DOptionElement;
import ice.pilots.html4.DSelectElement;
import ice.pilots.html4.DTextNode;
import ice.pilots.html4.DocPaneXml;
import ice.pilots.html4.FixedPainter;
import ice.pilots.html4.FloatManager;
import ice.pilots.html4.FloatPainter;
import ice.pilots.html4.FocusManager;
import ice.pilots.html4.FontCache;
import ice.pilots.html4.InlineBox;
import ice.pilots.html4.ObjectBox;
import ice.pilots.html4.ObjectPainter;
import ice.pilots.html4.ObjectPool;
import ice.pilots.html4.OutlinePainter;
import ice.pilots.html4.PositionedBox;
import ice.pilots.html4.RefreshEvent;
import ice.pilots.html4.ScrollBox;
import ice.pilots.html4.SelectionAgent;
import ice.pilots.html4.StormData;
import ice.pilots.html4.TextBox;
import ice.pilots.html4.TheView;
import ice.storm.Viewport;
import ice.util.Defs;
import ice.util.ICEException;
import ice.util.JavaVersion;
import ice.util.memory.MemoryManager;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Hashtable;
import java.util.Vector;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.events.EventTarget;

class CSSLayout
implements EventListener {
    static final boolean forceGC = Defs.sysPropertyBoolean("ice.browser.forcegc");
    int[] breaks = new int[1000];
    static final byte PSEUDO_NONE = 0;
    static final byte PSEUDO_HOVER = 1;
    static final byte PSEUDO_ACTIVE = 2;
    static final byte PSEUDO_FOCUS = 4;
    static final byte PSEUDO_BEFORE = 8;
    static final byte PSEUDO_AFTER = 16;
    private Object layout_lock = new Object();
    StormData sdata;
    protected CSSBox topBox = null;
    DDocument doc;
    protected CSSMatcher matcher;
    DocPaneXml docPane;
    TheView theView;
    protected boolean inPrintMode = false;
    OutlinePainter outlinePainter = new OutlinePainter();
    int mutation = 0;
    private boolean refreshEventComingUp = false;
    boolean hasBeenPurged = false;
    int zoom = 256;
    boolean doImageAnimation = true;
    Hashtable dynamicStyles = new Hashtable();
    private CSSCounters counters = new CSSCounters();
    private Vector resetedCounters = null;
    private CSSBox curParentBox;
    CSSBox pseudoBefore = null;
    CSSBox pseudoAfter = null;
    Hashtable substBoxes = new Hashtable();
    private FloatPainter floatPainter = new FloatPainter();
    private FixedPainter fixedPainter = new FixedPainter();
    BoxList boxList = new BoxList();
    private Hashtable anchors = new Hashtable();
    private String waitForRef = null;
    private int presetScrollX;
    private int presetScrollY;
    CSSBox focusedBox = null;
    private FocusManager focusManager = null;
    private boolean fixedBackgrounds = false;
    private SelectionAgent selectionAgent;
    private boolean cleared = true;
    int maxOutlineWidth = 0;
    private int memoryCheckCounter = 0;
    private boolean printback = true;
    private Point eventPos = new Point();
    private CSSBox prevMoveBox;
    private CSSBox prevDownBox;
    private DNode prevMoveNode;
    private DNode prevDownNode;
    private long pressTimeStamp;
    private int previousPressButton = 0;
    private int clickCounter;
    private int prevMoveX = -1;
    private int prevMoveY;
    private int prevMoveScrollX;
    private int prevMoveScrollY;
    private Rectangle sel_tmp = new Rectangle();
    private CSSAttribs documentFocusOutlineStyle;
    private long prevRefreshEventTime = 0L;
    final long minRefreshDelay = Defs.sysPropertyInt("ice.pilots.html4.refreshDelay", 50);
    final long maxRefreshDelay = Defs.sysPropertyInt("ice.pilots.html4.maxRefreshDelay", 500);
    private int layoutCallCount = 0;
    private Color selectionBackground;
    private Color selectionColor;
    private Color highlightColor;
    private Color highlightBackground;
    private Color noFocusSelectionBackground;
    private Color noFocusSelectionForeground;
    private static boolean selectOverride;
    private static boolean backgroundOverride;
    private static boolean supportsTransparency;
    private Color imageSelectionColorSource;
    private Color imageSelectionColor;
    private static Object renderingHints;
    private static Method rHintsMethod;
    private static String antiAlias;
    private static String textAntiAlias;
    private static String renderQuality;
    private static String alphaInterpolation;
    private static String dithering;
    private static String fractionalMetrics;
    private static String interpolation;
    private static String strokeControl;
    private static Object cssDebugger;
    private static Method debugDisplayMethod;
    private FontCache fontCache;
    private boolean documentFocusOutline;
    Rectangle imageablePrintArea = null;
    private AccessPosition implicitAccessibilityPosition;
    private AccessPosition _tempPosition;
    private boolean scrollToFocusedObject;
    private boolean hasReceivedLoadEvent = false;

    CSSLayout(StormData sdata, DDocument doc, CSSMatcher matcher) {
        char[] color;
        this.fontCache = sdata.fontCache;
        this.sdata = sdata;
        this.doc = doc;
        this.matcher = matcher;
        this.theView = new TheView(doc, this);
        this.selectionAgent = new SelectionAgent(doc.getSelection());
        this.implicitAccessibilityPosition = new AccessPosition();
        this._tempPosition = new AccessPosition();
        doc.addEventListener("load", this, true);
        doc.addEventListener("unload", this, true);
        doc.addEventListener("focus", this, true);
        doc.addEventListener("blur", this, true);
        doc.addEventListener("CSSModified", this, true);
        doc.addEventListener("DOMAttrModified", this, true);
        doc.addEventListener("DOMNodeInserted", this, true);
        doc.addEventListener("DOMNodeRemoved", this, true);
        doc.addEventListener("DOMSubtreeModified", this, true);
        String sTemp = Defs.property("ice.pilots.html4.selectionBackground");
        if (sTemp != null) {
            color = sTemp.toCharArray();
            this.selectionBackground = CSSUtil.parseColor(color, 0, color.length);
            backgroundOverride = true;
        }
        if ((sTemp = Defs.property("ice.pilots.html4.selectionColor")) != null) {
            color = sTemp.toCharArray();
            this.selectionColor = CSSUtil.parseColor(color, 0, color.length);
            selectOverride = true;
        }
        try {
            new Color(80, 80, 80, 80);
            supportsTransparency = true;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (backgroundOverride) {
            this.imageSelectionColor = CSSUtil.getImageSelectionColor(this.selectionBackground, supportsTransparency);
        }
        sTemp = Defs.property("ice.pilots.html4.inactiveSelectionBackground", "lightgray");
        color = sTemp.toCharArray();
        this.noFocusSelectionBackground = CSSUtil.parseColor(color, 0, color.length);
        sTemp = Defs.property("ice.pilots.html4.inactiveSelectionColor", "white");
        color = sTemp.toCharArray();
        this.noFocusSelectionForeground = CSSUtil.parseColor(color, 0, color.length);
        sTemp = Defs.property("ice.pilots.html4.highlightColor", "black");
        color = sTemp.toCharArray();
        this.highlightColor = CSSUtil.parseColor(color, 0, color.length);
        sTemp = Defs.property("ice.pilots.html4.highlightBackground", "yellow");
        color = sTemp.toCharArray();
        this.highlightBackground = CSSUtil.parseColor(color, 0, color.length);
        this.updateSelectionColors();
    }

    public void setFontCache(FontCache fontCache) {
        this.fontCache = fontCache;
    }

    public void setDocumentFocusOutline(boolean documentFocusOutline) {
        this.documentFocusOutline = documentFocusOutline;
    }

    final ObjectPool getObjectPool() {
        return this.doc.pilot.objectPool;
    }

    Object getLock() {
        return this.layout_lock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean refExists(String ref) {
        String lowerCase = ref.toLowerCase();
        Object object = this.getLock();
        synchronized (object) {
            if (this.anchors.get(lowerCase) != null) {
                return true;
            }
        }
        return lowerCase.equals("top");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getRefPos(String ref) {
        Object object = this.getLock();
        synchronized (object) {
            CSSBox b;
            DNode n = (DNode)this.anchors.get(ref.toLowerCase());
            if (n != null && (b = this.findCSSBox(n)) != null) {
                Point p = new Point();
                b.findAbsolutePosition(p);
                return p.y;
            }
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DNode getRefNode(String ref) {
        DNode refNode = null;
        Object object = this.getLock();
        synchronized (object) {
            refNode = (DNode)this.anchors.get(ref.toLowerCase());
        }
        return refNode;
    }

    void setWaitForRef(String ref) {
        this.waitForRef = ref;
    }

    void setPresetScrollPos(int presetScrollY) {
        this.presetScrollY = presetScrollY;
    }

    void setPresetScrollPosition(int presetScrollX, int presetScrollY) {
        this.presetScrollX = presetScrollX;
        this.presetScrollY = presetScrollY;
    }

    void setLayoutZoom(int z) {
        if (z < 1 || z > 4096) {
            return;
        }
        this.zoom = z;
        this.doc.mutate();
        this.validateLayout();
    }

    int getLayoutZoom() {
        return this.zoom;
    }

    void clear() {
        this.clear(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clear(boolean clearDocPane) {
        this.mutation = 0;
        this.hasBeenPurged = true;
        this.refreshEventComingUp = false;
        if (this.docPane != null && clearDocPane) {
            this.docPane.do_clear();
        }
        this.theView = new TheView(this.doc, this);
        Object object = this.getLock();
        synchronized (object) {
            this.prevDownBox = null;
            this.prevMoveBox = null;
            this.prevDownNode = null;
            this.prevMoveNode = null;
            this.dynamicStyles = new Hashtable();
            this.anchors = new Hashtable();
            this.counters.clear();
            if (this.topBox != null) {
                this.topBox.dispose();
                this.topBox = null;
            }
            this.curParentBox = null;
            this.focusedBox = null;
            this.floatPainter.clear();
            this.fixedPainter.clear();
            this.boxList.clear();
            if (this.focusManager != null) {
                this.focusManager.clearElements();
            }
            this.fixedBackgrounds = false;
            this.outlinePainter.clear();
            this.cleared = true;
        }
    }

    boolean isLayoutValid() {
        if (this.docPane == null) {
            return true;
        }
        if (this.topBox != null && this.topBox.minWidth == 0) {
            return false;
        }
        return this.doc.getMutation() == this.mutation;
    }

    void validateLayout() {
        if (this.docPane == null) {
            return;
        }
        if (this.doc.getMutation() != this.mutation) {
            this.refresh();
        } else {
            this.docPane.reqRepaint();
        }
    }

    int getWidth() {
        if (this.topBox != null) {
            return this.topBox.width;
        }
        return 0;
    }

    int getHeight() {
        if (this.topBox != null) {
            return this.topBox.height;
        }
        return 0;
    }

    boolean containsFixedBoxes() {
        if (this.fixedPainter != null) {
            return !this.fixedPainter.isEmpty() || this.fixedBackgrounds;
        }
        return false;
    }

    public boolean isViewportActive() {
        Viewport vp = this.doc.getPilot().getStorm().getActiveViewport();
        if (vp == null) {
            return true;
        }
        String activeId = vp.getId();
        return this.doc.getPilot().getViewportId().equals(activeId);
    }

    public Color getSelectionColor() {
        if (this.isViewportActive()) {
            return this.selectionColor;
        }
        return this.noFocusSelectionForeground;
    }

    public Color getSelectionBackground() {
        if (this.isViewportActive()) {
            return this.selectionBackground;
        }
        return this.noFocusSelectionBackground;
    }

    public boolean isSupportsTransparency() {
        return supportsTransparency;
    }

    public Color getHighlightColor() {
        return this.highlightColor;
    }

    public Color getHighlightBackground() {
        return this.highlightBackground;
    }

    public Color getImageSelectionColor() {
        Color c = this.getSelectionBackground();
        if (!c.equals(this.imageSelectionColorSource)) {
            this.imageSelectionColorSource = c;
            this.imageSelectionColor = CSSUtil.getImageSelectionColor(this.imageSelectionColorSource, supportsTransparency);
        }
        return this.imageSelectionColor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void paint(Graphics g) {
        block8: {
            this.outlinePainter.clear();
            if (rHintsMethod != null && g instanceof Graphics2D) {
                try {
                    rHintsMethod.invoke((Object)g, renderingHints);
                }
                catch (Exception e) {
                    if (!Debug.ex) break block8;
                    Debug.ex(e);
                }
            }
        }
        Object object = this.getLock();
        synchronized (object) {
            if (this.topBox != null) {
                this.topBox.paintBackground(g, g.getClipBounds(), 0, 0, this.getWidth(), this.getHeight(), 0);
                this.floatPainter.paintNegativeZ_Indices(g);
                this.topBox.paint(g);
                this.boxList.paint(g);
                this.floatPainter.paintPositiveZ_Indices(g);
                this.outlinePainter.paint(g);
            }
        }
        if (this.focusManager != null && this.documentFocusOutlineStyle != null && this.focusManager.isFrameFocused()) {
            this.outlineViewport(g, this.documentFocusOutlineStyle);
        }
    }

    private void outlineViewport(Graphics g, CSSAttribs outlineStyle) {
        if (outlineStyle.outline_width <= 0) {
            return;
        }
        g.setColor(outlineStyle.outline_color);
        int width = this.docPane.getPaneWidth();
        int height = this.docPane.getPaneHeight();
        int x = this.docPane.getScrollX();
        int y = this.docPane.getScrollY();
        int xx = x + width - outlineStyle.outline_width;
        int yy = y + height - outlineStyle.outline_width;
        CSSUtil.drawStyledLine(g, x, y, xx, y, outlineStyle.outline_style, outlineStyle.outline_width);
        CSSUtil.drawStyledLine(g, x, y, x, yy, outlineStyle.outline_style, outlineStyle.outline_width);
        CSSUtil.drawStyledLine(g, xx, y, xx, yy, outlineStyle.outline_style, outlineStyle.outline_width);
        CSSUtil.drawStyledLine(g, x, yy, xx, yy, outlineStyle.outline_style, outlineStyle.outline_width);
    }

    void paintFixed(Graphics g) {
        if (this.fixedPainter != null) {
            this.fixedPainter.paintNegativeZ_Indices(g);
            this.fixedPainter.paintPositiveZ_Indices(g);
        }
    }

    void layout(int viewportWidth, int viewportHeight) {
        this.do_layout(viewportWidth, viewportHeight);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void do_layout(int viewportWidth, int viewportHeight) {
        ++this.layoutCallCount;
        this.checkDocumentFocusOutline();
        if (this.docPane != null) {
            this.docPane.setCursor(0);
        }
        this.doc.notifyLayoutBegin();
        DNode oldFocus = null;
        if (this.mutation != this.doc.getMutation()) {
            if (this.focusManager != null) {
                oldFocus = this.focusManager.getFocusedElement();
            }
            if (!this.cleared) {
                this.clear(false);
            }
            this.generate();
        }
        Object object = this.getLock();
        synchronized (object) {
            int w;
            this.floatPainter.clear();
            if (this.topBox == null) {
                this.doc.notifyLayoutEnd();
                return;
            }
            this.updateSelectionColors();
            this.topBox.calcMinMaxWidths();
            this.topBox.calculateBreaks(viewportWidth);
            this.topBox.ox = 0;
            this.topBox.oy = 0;
            this.topBox.width = w = viewportWidth;
            FloatManager m = new FloatManager(0, w);
            this.topBox.layout(w, viewportHeight, m);
            this.topBox.height += m.skipTill(w);
            CSSBox b = m.getFirstFloater();
            if (b != null) {
                this.floatPainter.add(b);
            }
            this.fixedPainter.layout(viewportWidth, viewportHeight);
            this.boxList.layout(this.topBox);
            if (w < this.topBox.minWidth && this.topBox.width < this.topBox.minWidth) {
                this.topBox.width = this.topBox.minWidth;
            }
        }
        if (this.focusManager != null) {
            this.focusManager.layoutComplete();
            if (this.scrollToFocusedObject && oldFocus != null) {
                this.focusManager.setFocusedBox(oldFocus);
            }
        }
        this.doc.notifyLayoutEnd();
        if (this.prevMoveX != -1 && this.prevMoveBox == null) {
            this.doMouseOver(null, this.prevMoveX, this.prevMoveY, this.prevMoveScrollX, this.prevMoveScrollY, false);
        }
        if (cssDebugger != null) {
            try {
                Class[] rhMethodArgs = new Class[]{CSSBox.class};
                debugDisplayMethod = cssDebugger.getClass().getMethod("showTree", rhMethodArgs);
                Object[] mArgs = new Object[]{this.topBox};
                debugDisplayMethod.invoke(cssDebugger, mArgs);
            }
            catch (Exception e) {
                cssDebugger = null;
            }
        }
        this.implicitAccessibilityPosition._needsReview = true;
        if (JavaVersion.isV12orGreater()) {
            CSSLayout.updateRenderingHints();
        }
    }

    private void updateSelectionColors() {
        Color c;
        if (!backgroundOverride && this.docPane != null && !(c = this.docPane.getSelectionBackground()).equals(this.selectionBackground)) {
            this.selectionBackground = c;
        }
        if (!selectOverride && this.docPane != null) {
            this.selectionColor = this.docPane.getSelectionColor();
        }
    }

    void publishEvent(String type, String oldValue, String newValue) {
        this.doc.pilot.firePropertyChange(type, oldValue, newValue);
    }

    private static void updateRenderingHints() {
        String newAntiAlias = Defs.sysProperty("ice.pilots.html4.antiAliasing");
        String newTextAntiAlias = Defs.sysProperty("ice.pilots.html4.textAntiAliasing");
        String newRenderQuality = Defs.sysProperty("ice.pilots.html4.renderQuality");
        String newAlphaInterpolation = Defs.sysProperty("ice.pilots.html4.alphaInterpolation");
        String newDithering = Defs.sysProperty("ice.pilots.html4.dithering");
        String newFractionalMetrics = Defs.sysProperty("ice.pilots.html4.fractionalMetrics");
        String newInterpolation = Defs.sysProperty("ice.pilots.html4.interpolation");
        String newStrokeControl = Defs.sysProperty("ice.pilots.html4.strokeControl");
        boolean dirtyRenderingHints = false;
        if (newAntiAlias != null && antiAlias != null && !antiAlias.equals(newAntiAlias) || newAntiAlias != null && antiAlias == null) {
            antiAlias = newAntiAlias;
            dirtyRenderingHints = true;
        }
        if (newTextAntiAlias != null && textAntiAlias != null && !textAntiAlias.equals(newTextAntiAlias) || newTextAntiAlias != null && textAntiAlias == null) {
            textAntiAlias = newTextAntiAlias;
            dirtyRenderingHints = true;
        }
        if (newRenderQuality != null && renderQuality != null && !renderQuality.equals(newRenderQuality) || newRenderQuality != null && renderQuality == null) {
            renderQuality = newRenderQuality;
            dirtyRenderingHints = true;
        }
        if (newAlphaInterpolation != null && alphaInterpolation != null && !alphaInterpolation.equals(newAlphaInterpolation) || newAlphaInterpolation != null && alphaInterpolation == null) {
            alphaInterpolation = newAlphaInterpolation;
            dirtyRenderingHints = true;
        }
        if (newDithering != null && dithering != null && !dithering.equals(newDithering) || newDithering != null && dithering == null) {
            dithering = newDithering;
            dirtyRenderingHints = true;
        }
        if (newFractionalMetrics != null && fractionalMetrics != null && !fractionalMetrics.equals(newFractionalMetrics) || newFractionalMetrics != null && fractionalMetrics == null) {
            fractionalMetrics = newFractionalMetrics;
            dirtyRenderingHints = true;
        }
        if (newInterpolation != null && interpolation != null && !interpolation.equals(newInterpolation) || newInterpolation != null && interpolation == null) {
            interpolation = newInterpolation;
            dirtyRenderingHints = true;
        }
        if (newStrokeControl != null && strokeControl != null && !strokeControl.equals(newStrokeControl) || newStrokeControl != null && strokeControl == null) {
            strokeControl = newStrokeControl;
            dirtyRenderingHints = true;
        }
        if (dirtyRenderingHints) {
            renderingHints = CSSLayout.instantiateRenderingHints(false);
        }
    }

    void postLayout() {
        if (this.waitForRef != null) {
            int y = this.getRefPos(this.waitForRef);
            if (y >= 0) {
                this.waitForRef = null;
                if (this.docPane != null) {
                    this.docPane.setScrollPosition(0, y);
                }
            }
        } else if (this.presetScrollX > 0 || this.presetScrollY > 0) {
            this.docPane.setScrollPosition(this.presetScrollX, this.presetScrollY);
            this.presetScrollX = 0;
            this.presetScrollY = 0;
        }
    }

    public FontCache getFontCache() {
        return this.fontCache;
    }

    void addFixedBox(CSSBox b) {
        this.fixedPainter.add(b);
    }

    void addRelativeBox(CSSBox b, CSSBox pb) {
        this.boxList.addChild(b, pb);
    }

    void addAbsoluteBox(CSSBox b, CSSBox pb) {
        this.boxList.addChild(b, pb);
    }

    FocusManager getFocusManager() {
        return this.focusManager;
    }

    void setFocusManager(FocusManager f) {
        this.focusManager = f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generate() {
        int i;
        int doc_mutation = 0;
        Vector todoObjectBoxes = new Vector();
        Object object = this.getLock();
        synchronized (object) {
            this.prevDownBox = null;
            this.prevMoveBox = null;
            this.prevDownNode = null;
            this.prevMoveNode = null;
            doc_mutation = this.doc.getMutation();
            this.focusedBox = null;
            this.dynamicStyles.clear();
            this.anchors.clear();
            this.counters.clear();
            this.floatPainter.clear();
            this.fixedPainter.clear();
            this.boxList.clear();
            this.maxOutlineWidth = 0;
            this.matcher.build();
            DElement n = (DElement)this.doc.getDocumentElement();
            if (n == null) {
                return;
            }
            this.curParentBox = null;
            this.topBox = this.visitElement(n);
            if (forceGC) {
                System.gc();
                System.gc();
            }
            this.gen_r(n, this.topBox, todoObjectBoxes);
            this.curParentBox = null;
            this.substBoxes.clear();
            this.cleared = false;
        }
        ObjectPool objectPool = this.getObjectPool();
        objectPool.beginCreating();
        DNodeList l = (DNodeList)this.doc.getIFrames();
        int tmp = l.getLength();
        if (tmp > 0) {
            for (i = 0; i < tmp; ++i) {
                DElement e = (DElement)l.item(i);
                ObjectPainter p = objectPool.createEmbeddedObjectPainter(e, null);
                if (p == null) continue;
                p.setBox(null);
            }
            if (this.doc.pilot.isFromHistory) {
                this.doc.pilot.firePropertyChange("viewport", null, "childrenReady");
            }
        }
        int N = todoObjectBoxes.size();
        for (i = 0; i != N; ++i) {
            ObjectPainter p;
            CSSBox b = (CSSBox)todoObjectBoxes.elementAt(i);
            DElement e = (DElement)b.getDomNode();
            if (e == null || (p = objectPool.createEmbeddedObjectPainter(e, b)) == null) continue;
            ObjectBox ob = new ObjectBox(p, this);
            b = b.addChild(ob);
            this.initObjectBox(ob, p);
        }
        objectPool.endCreating();
        todoObjectBoxes.removeAllElements();
        this.mutation = doc_mutation;
        this.doc.notifyLayoutBuilt();
    }

    private void gen_r(DNode node, CSSBox parentBox, Vector todoObjectBoxes) {
        Vector countersToKill = null;
        DNode n = node.getFirstDChild();
        while (n != null) {
            CSSBox b;
            if (this.memoryCheckCounter > 0) {
                this.memoryCheckCounter = 200;
            } else if (MemoryManager.getInstance().isLowMemory()) {
                this.doc.pilot.clear("text/html");
                ICEException ice = new ICEException(1, 4, 2);
                this.doc.pilot.firePropertyChange("contentLoading", ice, "error");
                throw new RuntimeException("low mem in layout");
            }
            if (parentBox.parentBox == null && !this.substBoxes.isEmpty() && (b = (CSSBox)this.substBoxes.get(parentBox)) != null) {
                this.substBoxes.remove(parentBox);
                parentBox = b;
            }
            this.curParentBox = parentBox;
            CSSBox curBox = null;
            if (n instanceof DElement) {
                DElement e = (DElement)n;
                curBox = e.isReplacedElement() ? this.visitObjectElement(e, todoObjectBoxes) : this.visitElement(e);
            } else if (n instanceof DTextNode) {
                curBox = this.visitTextNode((DTextNode)n);
            }
            parentBox = this.curParentBox;
            if (this.resetedCounters != null) {
                countersToKill = this.resetedCounters;
                this.resetedCounters = null;
            }
            if (curBox != null) {
                if (curBox instanceof ScrollBox) {
                    todoObjectBoxes.addElement(curBox);
                }
                if (this.pseudoBefore != null) {
                    CSSBox gb = this.pseudoBefore;
                    this.pseudoBefore = null;
                    curBox = curBox.addChild(gb);
                }
                if (this.pseudoAfter != null) {
                    CSSBox b2 = curBox;
                    CSSBox gb = this.pseudoAfter;
                    this.pseudoAfter = null;
                    this.gen_r(n, curBox, todoObjectBoxes);
                    b2 = b2.addChild(gb);
                } else {
                    this.gen_r(n, curBox, todoObjectBoxes);
                }
                curBox.notifyChildrenGenerated();
            }
            if (countersToKill != null) {
                this.counters.removeCounters(countersToKill);
                countersToKill = null;
            }
            n = n.next;
        }
    }

    protected void initObjectBox(ObjectBox box, ObjectPainter p) {
        p.setBox(box);
    }

    String getCounterValue(String name, boolean multiple, String sep, int style) {
        return this.counters.getCounterValue(name, multiple, sep, style);
    }

    void incCounters(Vector v) {
        this.counters.incCounters(v);
    }

    void updateCounters(Vector v) {
        this.counters.updateCounters(v);
    }

    void resetCounters(Vector v) {
        this.resetedCounters = v;
        this.counters.resetCounters(v);
    }

    private final CSSBox visitElement(DElement e) {
        CSSBox curBox = this.matcher.createCSSBox(e, this.curParentBox, this);
        if (curBox != null) {
            if (!this.inPrintMode) {
                e.hack_box = curBox;
            }
            if (e.isFocusable() && this.focusManager != null) {
                this.focusManager.registerNewElement(curBox, e);
            }
            if (e.tagId == 1) {
                String _anchorName = e.getAttribute(63);
                if (_anchorName == null) {
                    _anchorName = e.getAttribute(50);
                }
                if (_anchorName != null) {
                    this.anchors.put(_anchorName.toLowerCase(), e);
                }
            } else {
                String _anchorName = e.getAttribute(50);
                if (_anchorName != null && _anchorName.length() != 0) {
                    this.anchors.put(_anchorName.toLowerCase(), e);
                }
            }
            if (curBox.css.background_image != null) {
                if ((curBox.css.background_params & 4) != 0) {
                    this.fixedBackgrounds = true;
                }
                if (this.printback) {
                    curBox.loadBackgroundImage(this.doc);
                }
            }
        }
        return curBox;
    }

    void setPrintBack(boolean printback) {
        this.printback = printback;
    }

    boolean getPrintBack() {
        return this.printback;
    }

    final CSSBox visitObjectElement(DElement e, Vector todoObjectBoxes) {
        CSSBox curBox = this.visitElement(e);
        if (curBox != null) {
            Node named;
            todoObjectBoxes.addElement(curBox);
            String s = e.getAttribute(112);
            if (s != null && this.focusManager != null && s.length() > 1 && (named = this.doc.getMaps().namedItem(s.substring(1))) instanceof DMapElement) {
                DMapElement map = (DMapElement)named;
                for (int i = 0; i < map.getAreas().getLength(); ++i) {
                    this.focusManager.registerNewElement(curBox, (DElement)map.getAreas().item(i));
                }
            }
        }
        return null;
    }

    private final CSSBox visitTextNode(DTextNode textNode) {
        TextBox curBox = new TextBox(textNode, this);
        this.curParentBox = this.curParentBox.addChild(curBox);
        return null;
    }

    CSSBox getBoxAt(int x, int y, int scrollX, int scrollY, Point p) {
        CSSBox b = this.fixedPainter.getBoxAt(x, y, p);
        if (b == null) {
            b = this.boxList.getBoxAt(x + scrollX, y + scrollY, p);
        }
        if (b == null) {
            b = this.floatPainter.getBoxAt(x + scrollX, y + scrollY, p);
        }
        if (b == null && this.topBox != null) {
            b = this.topBox.getBoxAt(x + scrollX, y + scrollY, p);
        }
        if (b != null && (b.css.misc & 1) == 0) {
            b = null;
        }
        return b;
    }

    void handleEvent(DOMUIEvent e) {
        this.do_handleEvent(e);
    }

    private void do_handleEvent(DOMUIEvent e) {
        if (this.topBox == null) {
            return;
        }
        int x = e.getPosX();
        int y = e.getPosY();
        int scrollX = e.getScrollX();
        int scrollY = e.getScrollY();
        switch (e.typeId) {
            case 21: 
            case 22: {
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 23: {
                DNode keyEventTarget = null;
                if (this.focusedBox != null) {
                    keyEventTarget = this.focusedBox.getDomNode();
                }
                if (keyEventTarget == null) {
                    keyEventTarget = (DNode)((Object)this.doc.getBody());
                }
                if (keyEventTarget == null) break;
                if (!this.callDispatchEvent(e, keyEventTarget)) {
                    return;
                }
                this.setScrollToFocus(true);
                break;
            }
            case 5: {
                this.doMouseOver(e, x, y, scrollX, scrollY, true);
                break;
            }
            case 7: {
                this.clickCounter = 0;
                this.doMouseOut(e);
                break;
            }
            case 6: {
                this.doMouseMove(e, x, y, scrollX, scrollY);
                break;
            }
            case 3: {
                long tmpTimeStamp = System.currentTimeMillis();
                short button = e.getMouseButtons();
                this.clickCounter = tmpTimeStamp - this.pressTimeStamp < 400L && this.previousPressButton == button ? ++this.clickCounter : 1;
                this.pressTimeStamp = tmpTimeStamp;
                this.previousPressButton = button;
                e.detail = this.clickCounter;
                this.prevDownBox = this.prevMoveBox;
                this.prevDownNode = this.prevMoveNode;
                if (this.prevDownNode != null) {
                    e.setPosX(this.eventPos.x);
                    e.setPosY(this.eventPos.y);
                    if (!this.callDispatchEvent(e, this.prevDownNode)) {
                        return;
                    }
                }
                if (this.prevDownBox == null) break;
                this.prevDownBox.applyDynamicStyle(e.typeId);
                break;
            }
            case 4: {
                if (this.prevMoveNode != null) {
                    e.detail = this.clickCounter;
                    e.setPosX(this.eventPos.x);
                    e.setPosY(this.eventPos.y);
                    e.relatedNode = this.prevMoveNode;
                    if (!this.callDispatchEvent(e, this.prevMoveNode)) {
                        return;
                    }
                    if (this.prevDownBox != null) {
                        this.prevDownBox.applyDynamicStyle(e.typeId);
                    }
                }
                this.prevDownBox = null;
                this.prevDownNode = null;
            }
        }
    }

    private final void doMouseOver(DOMUIEvent e, int x, int y, int scrollX, int scrollY, boolean sendDOMEvent) {
        CSSBox b = this.getBoxAt(x, y, scrollX, scrollY, this.eventPos);
        DNode n = null;
        if (b != null) {
            if (b instanceof ObjectBox) {
                n = ((ObjectBox)b).getDomNode(this.eventPos.x, this.eventPos.y);
                if (n != b.getDomNode() && e != null) {
                    e.nodeAfterMap = b.getDomNode();
                }
            } else {
                n = b.getDomNode();
            }
        }
        this.prevMoveBox = b;
        this.prevMoveNode = n;
        this.prevMoveX = x;
        this.prevMoveY = y;
        this.prevMoveScrollX = scrollX;
        this.prevMoveScrollY = scrollY;
        if (n != null && sendDOMEvent) {
            e.setPosX(this.eventPos.x);
            e.setPosY(this.eventPos.y);
            if (!this.callDispatchEvent(e, n)) {
                return;
            }
        }
        this.doApplyDynamicStyle(b, 5);
        if (b != null && b.css.cursor >= 0) {
            this.docPane.setCursor(b.css.cursor);
        }
    }

    private final void doMouseOut(DOMUIEvent e) {
        CSSBox b = this.prevMoveBox;
        DNode n = this.prevMoveNode;
        this.prevMoveBox = null;
        this.prevMoveNode = null;
        this.prevMoveX = -1;
        if (n != null && !this.callDispatchEvent(e, n)) {
            return;
        }
        if (b != null && b.css.cursor >= 0) {
            this.docPane.setCursor(0);
        }
        this.doApplyDynamicStyle(b, e.typeId);
    }

    private final void doMouseMove(DOMUIEvent e, int x, int y, int scrollX, int scrollY) {
        CSSBox b = this.getBoxAt(x, y, scrollX, scrollY, this.eventPos);
        DNode n = null;
        if (b != null) {
            if (b instanceof ObjectBox) {
                n = ((ObjectBox)b).getDomNode(this.eventPos.x, this.eventPos.y);
                if (n != b.getDomNode()) {
                    e.nodeAfterMap = b.getDomNode();
                }
            } else {
                n = b.getDomNode();
            }
        }
        CSSBox pb = this.prevMoveBox;
        DNode pn = this.prevMoveNode;
        this.prevMoveBox = b;
        this.prevMoveNode = n;
        this.prevMoveX = x;
        this.prevMoveY = y;
        this.prevMoveScrollX = scrollX;
        this.prevMoveScrollY = scrollY;
        if (b == pb && n == pn) {
            if (n != null) {
                e.setPosX(this.eventPos.x);
                e.setPosY(this.eventPos.y);
                if (!this.callDispatchEvent(e, n)) {
                    return;
                }
            }
        } else {
            DNode boxNode;
            DOMUIEvent tmp;
            this.clickCounter = 0;
            if (pn != null) {
                tmp = (DOMUIEvent)this.doc.createDOMEvent(7);
                tmp.copyUIDataFrom(e);
                if (pn instanceof DAreaElement && pb != null) {
                    boxNode = pb.getDomNode();
                    tmp.nodeAfterMap = boxNode.tagId == 6 ? boxNode.getParentDNode().getNextDSibling() : boxNode;
                }
                tmp.relatedNode = n;
                if (!this.callDispatchEvent(tmp, pn)) {
                    return;
                }
            }
            if (pb != null && pb.css.cursor >= 0) {
                this.docPane.setCursor(0);
            }
            this.doApplyDynamicStyle(pb, 7);
            if (n != null) {
                tmp = (DOMUIEvent)this.doc.createDOMEvent(5);
                tmp.copyUIDataFrom(e);
                if (n instanceof DAreaElement && b != null) {
                    boxNode = b.getDomNode();
                    tmp.nodeAfterMap = boxNode.tagId == 6 ? boxNode.getParentDNode().getNextDSibling() : boxNode;
                }
                tmp.setPosX(this.eventPos.x);
                tmp.setPosY(this.eventPos.y);
                tmp.relatedNode = pn;
                if (!this.callDispatchEvent(tmp, n)) {
                    return;
                }
                this.refresh();
            }
            this.doApplyDynamicStyle(b, 5);
            if (b != null && b.css.cursor >= 0) {
                this.docPane.setCursor(b.css.cursor);
            }
        }
    }

    private boolean callDispatchEvent(DOMUIEvent e, DNode n) {
        int savedLayoutCallCount = this.layoutCallCount;
        n.dispatchEvent(e);
        return savedLayoutCallCount == this.layoutCallCount;
    }

    private void doApplyDynamicStyle(CSSBox b, int eventId) {
        CSSAttribs tc;
        CSSBox t;
        if (b == null) {
            return;
        }
        if (b instanceof ButtonBox) {
            b = ((ButtonBox)b).getBlock();
        }
        b.applyDynamicStyle(eventId);
        if (eventId == 7 && (t = this.focusedBox) != null) {
            t.applyDynamicStyle(21);
        }
        if (eventId == 22 && (t = this.focusedBox) != null && (tc = this.getDynamicStyle(t, 1)) != null && t.css != tc && this.prevMoveBox != null) {
            this.prevMoveBox.applyDynamicStyle(5);
        }
    }

    CSSAttribs getDynamicStyle(CSSBox box, int pseudo) {
        DNode n = box.getDomNode();
        if (n == null) {
            return null;
        }
        CSSAttribs[] atrs = (CSSAttribs[])this.dynamicStyles.get(n);
        if (pseudo == 4) {
            pseudo = 3;
        }
        if (atrs == null || pseudo < 0 || pseudo >= atrs.length) {
            return null;
        }
        return atrs[pseudo];
    }

    CSSBox findCSSBox(DNode n) {
        CSSBox b = null;
        if (n instanceof DElement) {
            b = ((DElement)n).hack_box;
        }
        if (b == null) {
            b = this.find_r(this.topBox, n);
            if (b == null) {
                b = this.find_inpainter(this.fixedPainter, n);
            }
            if (b == null) {
                b = this.find_inpainter(this.floatPainter, n);
            }
            if (b == null) {
                b = this.boxList.findCSSBox(n);
            }
        }
        return b;
    }

    ObjectBox getWrappedObjectBoxOrNull(CSSBox box) {
        if (box instanceof InlineBox) {
            InlineBox ibox = (InlineBox)box;
            box = ibox.first;
            while (box != null) {
                if (box instanceof ObjectBox) {
                    return (ObjectBox)box;
                }
                box = box.next;
            }
        } else if (box instanceof ObjectBox) {
            return (ObjectBox)box;
        }
        return null;
    }

    private CSSBox find_inpainter(FloatPainter p, DNode n) {
        CSSBox c = p.getFirst();
        CSSBox bb = null;
        while (c != null && bb == null) {
            bb = this.find_r(c, n);
            c = c.next;
        }
        return bb;
    }

    private CSSBox find_r(CSSBox b, DNode n) {
        if (b == null) {
            return null;
        }
        if (b.getDomNode() == n) {
            return b;
        }
        CSSBox c = b.getFirstChild();
        CSSBox bb = null;
        while (c != null && bb == null) {
            bb = this.find_r(c, n);
            c = c.next;
        }
        return bb;
    }

    public void setScrollToFocus(boolean scrollTo) {
        this.scrollToFocusedObject = scrollTo;
    }

    void clearSelection() {
        this.selectionAgent.clearSelection(this);
        this.docPane.reqRepaint();
    }

    void markDocument(int xPos, int yPos, int scrollX, int scrollY) {
        this.selectionAgent.markDocument(this, xPos, yPos, scrollX, scrollY);
    }

    void setSelection(int x1, int y1, int x2, int y2, int scrollX, int scrollY) {
        this.selectionAgent.setSelection(this, x1, y1, x2, y2, scrollX, scrollY);
        if (this.selectionAgent.isSelectionActive()) {
            this.docPane.reqRepaint();
        }
    }

    void selectWord(int x, int y, int scrollX, int scrollY) {
        this.selectionAgent.selectWord(this, x, y, scrollX, scrollY);
        this.docPane.reqRepaint();
    }

    public void selectWordByIndex(int index) {
        this.selectionAgent.selectWordByIndex(this, index);
        this.docPane.reqRepaint();
    }

    public void selectWordRight() {
        this.selectionAgent.selectWordRight(this);
        this.docPane.reqRepaint();
    }

    public void selectSentenceLeft() {
        this.selectionAgent.selectSentenceLeft(this);
        this.docPane.reqRepaint();
    }

    public void selectSentenceRight() {
        this.selectionAgent.selectSentenceRight(this);
        this.docPane.reqRepaint();
    }

    public void selectWordLeft() {
        this.selectionAgent.selectWordLeft(this);
        this.docPane.reqRepaint();
    }

    public void selectCharRight() {
        this.selectionAgent.selectCharRight(this);
        this.docPane.reqRepaint();
    }

    public void selectCharLeft() {
        this.selectionAgent.selectCharLeft(this);
        this.docPane.reqRepaint();
    }

    public DNode getStartContainer() {
        return this.selectionAgent.getStartContainer();
    }

    public DNode getEndContainer() {
        return this.selectionAgent.getEndContainer();
    }

    public boolean isSelection() {
        return this.selectionAgent.isSelectionActive() & !this.inPrintMode;
    }

    public boolean isInSelection(DNode node) {
        return this.selectionAgent.isInside(node);
    }

    public boolean isInSelection(int xPos, int yPos, int scrollX, int scrollY) {
        return this.selectionAgent.isInside(this, xPos, yPos, scrollX, scrollY);
    }

    public String getHyperlinkAt(int xPos, int yPos, int scrollX, int scrollY) {
        if (this.topBox != null) {
            Point p = new Point();
            DNode node = this.getBoxAt(xPos, yPos, scrollX, scrollY, p).getDomNode();
            while (node != null) {
                String url;
                if (node instanceof DAnchorElement && (url = ((DAnchorElement)node).getHref()) != null) {
                    return this.doc.resolveUrl(url);
                }
                node = node.parent;
            }
        }
        return null;
    }

    public DElement getSelectionDElement() {
        return this.selectionAgent.getSelectionParentNode();
    }

    public void select(DNode node1, int charOffStart, DNode node2, int chrEndOffset) {
        this.selectionAgent.select(node1, charOffStart, node2, chrEndOffset, this);
        this.docPane.reqRepaint();
    }

    void selectAll() {
        this.selectionAgent.selectAll(this);
        this.docPane.reqRepaint();
    }

    public void postSelectedToClipboard() {
        this.selectionAgent.postSelectedToClipboard(this);
    }

    public void defineHighlight(int startIndex, int endIndex) {
        CSSBox startBox;
        if (this.topBox != null && (startBox = ((BlockBox)this.topBox).findChildByIndex(1, startIndex)) != null) {
            this.selectionAgent.defineHighlight(startBox, startIndex -= startBox.getStartingCharacterOffset(), endIndex -= startBox.getStartingCharacterOffset());
            this.docPane.reqRepaint();
        }
    }

    public void clearHighlights() {
        this.selectionAgent.clearHighlights();
        this.docPane.reqRepaint();
    }

    public void scrollToBox(DTextNode node1) {
        TheView view = (TheView)this.doc.getDefaultView();
        if (view != null) {
            Rectangle r = new Rectangle();
            view.findBoundingBox(node1, r);
            if (r.width > 0 && !this.docPane.isVisibleOnScreen(r.x, r.y)) {
                if (r.width < this.docPane.getPaneWidth() && r.x <= this.docPane.getPaneWidth()) {
                    this.docPane.setScrollPosition(0, r.y);
                } else {
                    this.docPane.setScrollPosition(r.x, r.y);
                }
            }
        }
    }

    void paintCallback(Graphics g, ObjectPainter painter) {
        painter.draw(g);
    }

    private CSSBox postProcessBox(CSSBox b) {
        if (b instanceof TextBox) {
            return b.parentBox;
        }
        return b;
    }

    final void checkDocumentFocusOutline() {
        String s;
        if (this.documentFocusOutline && (s = Defs.sysProperty("ice.pilots.html4.documentFocusOutlineStyle", "black dotxrd 1px")) != null) {
            s = "outline: " + s;
            char[] cc = s.toCharArray();
            CSSDecl decl = CSSLookup.parseDeclaration(this.fontCache, cc, 0, 7, 9, s.length() - 9);
            this.documentFocusOutlineStyle = new CSSAttribs(this.fontCache, this.getLayoutZoom());
            while (decl != null) {
                CSSLookup.apply(this.documentFocusOutlineStyle, decl, this.getLayoutZoom(), null);
                decl = decl.next;
            }
            if (this.documentFocusOutlineStyle.outline_color == null) {
                this.documentFocusOutlineStyle.color = Color.black;
            }
        }
    }

    public void handleEvent(Event event) {
        if (this.doc.pilot.noLayoutUpdate != 0) {
            return;
        }
        DOMEvent de = (DOMEvent)event;
        switch (de.getTypeId()) {
            case 13: {
                if (this.hasReceivedLoadEvent) break;
                this.hasReceivedLoadEvent = true;
                this.validateLayout();
                break;
            }
            case 14: {
                if (!this.hasReceivedLoadEvent) break;
                this.hasReceivedLoadEvent = false;
                break;
            }
            case 29: {
                DMutationEvent e = (DMutationEvent)de;
                Element elm = (Element)((Object)e.getTarget());
                String propertyName = e.getAttrName();
                String value = e.getNewValue();
                if (value == null) {
                    this.doc.mutate();
                    this.validateLayout();
                    break;
                }
                if (!this.changeStyle(elm, propertyName, value)) {
                    this.doc.mutate();
                }
                this.validateLayout();
                break;
            }
            case 28: {
                DMutationEvent e = (DMutationEvent)de;
                EventTarget target = e.getTarget();
                String attrName = e.getAttrName();
                if (target instanceof DElement && ((DElement)target).tagId == 34) {
                    this.doc.pilot.updateFrameset((DElement)target);
                    break;
                }
                if (target instanceof DInputElement) {
                    if ("type".equals(attrName)) {
                        ((DInputElement)target).updateType();
                    } else if ("value".equals(attrName)) {
                        this.tryObjectPainterModified(e);
                        this.validateLayout();
                        return;
                    }
                }
                if (this.tryObjectPainterModified(e)) {
                    return;
                }
                if (target instanceof DTextNode && "value".equals(attrName)) {
                    this.validateLayout();
                    return;
                }
                if ("bgcolor".equals(attrName)) {
                    this.docPane.reqRepaint();
                    return;
                }
                this.doc.mutate();
                this.validateLayout();
                break;
            }
            case 26: {
                DMutationEvent e = (DMutationEvent)de;
                DNode target = (DNode)e.getTarget();
                if (target == null) {
                    return;
                }
                this.handleDOMNodeInserted(e, target);
                break;
            }
            case 27: {
                this.doc.mutate();
                this.validateLayout();
                break;
            }
            case 25: {
                this.doc.mutate();
                this.validateLayout();
                break;
            }
            case 21: {
                CSSBox box;
                DOMUIEvent uie = (DOMUIEvent)de;
                DNode target = (DNode)de.getTarget();
                this.focusedBox = box = this.findCSSBox(target);
                this.doApplyDynamicStyle(box, 21);
                if (!(target instanceof DAreaElement)) break;
                Point pos = new Point();
                box = this.getBoxAt(uie.getPosX() + 1, uie.getPosY() + 1, 0, 0, pos);
                if (!(box instanceof ObjectBox)) break;
                ((ObjectBox)box).onBoxFocusChange(target, 21);
                break;
            }
            case 22: {
                DOMUIEvent uie = (DOMUIEvent)de;
                DNode target = (DNode)de.getTarget();
                CSSBox box = this.findCSSBox(target);
                this.doApplyDynamicStyle(box, 22);
                if (target instanceof DAreaElement) {
                    Point pos = new Point();
                    box = this.getBoxAt(uie.getPosX() + 1, uie.getPosY() + 1, 0, 0, pos);
                    if (box instanceof ObjectBox) {
                        ((ObjectBox)box).onBoxFocusChange(target, 22);
                    }
                }
                this.focusedBox = null;
                break;
            }
            default: {
                Defs.badArg();
            }
        }
    }

    private void handleDOMNodeInserted(DMutationEvent e, DNode target) {
        switch (target.getNameId()) {
            case 63: {
                try {
                    DOptionElement opt = (DOptionElement)target;
                    DSelectElement elm = (DSelectElement)opt.getParentNode();
                    if (elm == null) {
                        return;
                    }
                    DSelectElement.SelectPainter painter = elm.getSelectPainter();
                    if (painter == null) break;
                    painter.onOptionStructChange();
                    break;
                }
                catch (ClassCastException ex) {
                    if (Debug.ex) {
                        Debug.ex(ex);
                    }
                    if (Debug.trace) {
                        Debug.trace("HTML.TAG_OPTION - classcast exp");
                    }
                    return;
                }
            }
            case 71: {
                DSelectElement elm = (DSelectElement)target;
                DSelectElement.SelectPainter p = elm.getSelectPainter();
                if (p == null) break;
                break;
            }
            default: {
                this.doc.mutate();
                this.validateLayout();
            }
        }
    }

    private boolean tryObjectPainterModified(DMutationEvent e) {
        try {
            EventTarget evt = e.getTarget();
            if (!(evt instanceof DElement)) {
                return false;
            }
            DElement elm = (DElement)evt;
            ObjectPainter op = this.doc.pilot.objectPool.getNodePainter(elm);
            if (op == null) {
                return false;
            }
            String attrName = e.getAttrName();
            if (attrName == null) {
                return false;
            }
            DAttr attr = (DAttr)elm.getAttributeNode(attrName);
            op.onElementAttrChange(elm, attr);
            return true;
        }
        catch (ClassCastException ex) {
            if (Debug.ex) {
                Debug.ex(ex);
            }
            if (Debug.trace) {
                Debug.trace("BAD: " + e.toString());
            }
            return false;
        }
    }

    private boolean changeStyle(Element e, String propertyName, String value) {
        int len = propertyName.length();
        char[] cc = new char[len + value.length()];
        propertyName.getChars(0, len, cc, 0);
        value.getChars(0, value.length(), cc, len);
        CSSDecl d = CSSLookup.parseDeclaration(this.fontCache, cc, 0, len, len, cc.length - len);
        return this.changeStyle(e, d);
    }

    private boolean changeStyle(Element e, CSSDecl d) {
        boolean ok;
        block24: {
            ok = true;
            try {
                CSSBox b = this.findCSSBox((DElement)e);
                if (b == null) {
                    return false;
                }
                CSSAttribs parentCss = null;
                if (b.getParentBox() != null) {
                    parentCss = b.getParentBox().css;
                }
                while (d != null) {
                    CSSAttribs[] atrs;
                    int prevLeft;
                    int prevTop = b.css.top;
                    if (prevTop == -123456) {
                        prevTop = 0;
                    }
                    if ((prevLeft = b.css.left) == -123456) {
                        prevLeft = 0;
                    }
                    if (d.id == 97) {
                        int mask = b.css.misc & 1;
                        if (d.type == 121 && mask == 0 || d.type == 120 && mask != 0) {
                            d = d.next;
                            continue;
                        }
                    }
                    if (b.dynamic > 0 && (atrs = (CSSAttribs[])this.dynamicStyles.get(b.getDomNode())) != null) {
                        for (int i = 0; i < atrs.length; ++i) {
                            CSSAttribs c = atrs[i];
                            if (c == null) continue;
                            CSSLookup.apply(c, d, this.getLayoutZoom(), parentCss);
                        }
                    }
                    CSSLookup.apply(b.css, d, this.getLayoutZoom(), parentCss);
                    int extra = 0;
                    switch (d.id) {
                        case 94: {
                            extra = b.css.top - prevTop;
                            if (b instanceof PositionedBox) {
                                ((PositionedBox)b).changeTopAndLeft(0, extra);
                                break;
                            }
                            b.oy += extra;
                            break;
                        }
                        case 52: {
                            extra = b.css.left - prevLeft;
                            if (b instanceof PositionedBox) {
                                ((PositionedBox)b).changeTopAndLeft(extra, 0);
                                break;
                            }
                            b.ox += extra;
                            break;
                        }
                        case 32: {
                            break;
                        }
                        case 39: 
                        case 46: 
                        case 51: 
                        case 74: 
                        case 100: 
                        case 102: {
                            ok = false;
                            break;
                        }
                        case 97: {
                            if ((b.css.misc & 0x20) != 0 && b.parentBox != null) {
                                b.css.misc = (short)(b.css.misc & 0xFFFFFFFE);
                                b.css.misc = (short)(b.css.misc | b.parentBox.css.misc & 1);
                            }
                            b.propagateVisibility(b.css.misc, false);
                            break;
                        }
                        case 5: 
                        case 33: {
                            ObjectBox obox = this.getWrappedObjectBoxOrNull(b);
                            if (obox == null) break;
                            obox.updatePainterColors();
                        }
                    }
                    d = d.next;
                }
                if (ok && this.docPane != null) {
                    this.docPane.reqRepaint();
                }
            }
            catch (Exception ex) {
                if (Debug.ex) {
                    Debug.ex(ex);
                }
                if (!Debug.trace) break block24;
                Debug.trace("Style not changed: " + ex);
            }
        }
        return ok;
    }

    static Object instantiateRenderingHints(boolean getSystProps) {
        Object retVal;
        block13: {
            if (getSystProps) {
                antiAlias = Defs.sysProperty("ice.pilots.html4.antiAliasing");
                textAntiAlias = Defs.sysProperty("ice.pilots.html4.textAntiAliasing");
                renderQuality = Defs.sysProperty("ice.pilots.html4.renderQuality");
                alphaInterpolation = Defs.sysProperty("ice.pilots.html4.alphaInterpolation");
                dithering = Defs.sysProperty("ice.pilots.html4.dithering");
                fractionalMetrics = Defs.sysProperty("ice.pilots.html4.fractionalMetrics");
                interpolation = Defs.sysProperty("ice.pilots.html4.interpolation");
                strokeControl = Defs.sysProperty("ice.pilots.html4.strokeControl");
            }
            if (antiAlias == null && textAntiAlias == null && renderQuality == null && alphaInterpolation == null && dithering == null && fractionalMetrics == null && interpolation == null && strokeControl == null) {
                return new RenderingHints(null);
            }
            retVal = null;
            try {
                Class<?> rhClass = Class.forName("java.awt.RenderingHints");
                Class<?> mapClass = Class.forName("java.util.Map");
                Constructor<?>[] consts = rhClass.getConstructors();
                if (consts.length > 0) {
                    for (int cdx = 0; cdx < consts.length; ++cdx) {
                        Class<?>[] args = consts[cdx].getParameterTypes();
                        if (args.length != 1 || !args[0].equals(mapClass)) continue;
                        retVal = consts[cdx].newInstance(new Object[]{null});
                        if (antiAlias != null) {
                            CSSLayout.addKeyValue(retVal, "KEY_ANTIALIASING", antiAlias);
                        }
                        if (textAntiAlias != null) {
                            CSSLayout.addKeyValue(retVal, "KEY_TEXT_ANTIALIASING", textAntiAlias);
                        }
                        if (renderQuality != null) {
                            CSSLayout.addKeyValue(retVal, "KEY_RENDERING", renderQuality);
                        }
                        if (alphaInterpolation != null) {
                            CSSLayout.addKeyValue(retVal, "KEY_ALPHA_INTERPOLATION", alphaInterpolation);
                        }
                        if (dithering != null) {
                            CSSLayout.addKeyValue(retVal, "KEY_DITHERING", dithering);
                        }
                        if (fractionalMetrics != null) {
                            CSSLayout.addKeyValue(retVal, "KEY_FRACTIONALMETRICS", fractionalMetrics);
                        }
                        if (interpolation != null) {
                            CSSLayout.addKeyValue(retVal, "KEY_INTERPOLATION", interpolation);
                        }
                        if (strokeControl == null) break;
                        CSSLayout.addKeyValue(retVal, "KEY_STROKE_CONTROL", strokeControl);
                        break;
                    }
                }
                Class[] rhMethodArgs = new Class[]{mapClass};
                Class<?> c = Class.forName("java.awt.Graphics2D");
                rHintsMethod = c.getMethod("addRenderingHints", rhMethodArgs);
            }
            catch (Exception e) {
                if (!Debug.ex) break block13;
                Debug.ex(e);
            }
        }
        return retVal;
    }

    private static Object instantiateDebugClass() {
        Object retVal = null;
        try {
            Class<?> debugClass = Class.forName("ice.pilots.html4.RenderTreeDialog");
            Class[] classArgs = new Class[]{};
            debugDisplayMethod = debugClass.getMethod("getInstance", classArgs);
            Object[] mArgs = new Object[]{};
            retVal = debugDisplayMethod.invoke(debugClass, mArgs);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return retVal;
    }

    static void addKeyValue(Object rHints, String key, String value) {
        block2: {
            Class<?> rhClass = rHints.getClass();
            try {
                Object[] mArgs = new Object[2];
                Field f = rhClass.getField(key);
                mArgs[0] = f.get(rHints);
                f = rhClass.getField(value);
                mArgs[1] = f.get(rHints);
                Method m = rhClass.getMethod("put", Object.class, Object.class);
                m.invoke(rHints, mArgs);
            }
            catch (Exception e) {
                if (!Debug.ex) break block2;
                Debug.ex(e);
            }
        }
    }

    void refresh() {
        this.refresh(false);
    }

    void refresh(boolean addToBlockerList) {
        if (!this.isLayoutValid()) {
            if (!this.refreshEventComingUp || addToBlockerList) {
                this.refreshEventComingUp = true;
                this.prevRefreshEventTime = System.currentTimeMillis();
                this.hasBeenPurged = false;
                RefreshEvent event = new RefreshEvent(this);
                if (addToBlockerList) {
                    event._loadSessionTag = this.doc.pilot.getPilotViewport().addOnloadBlocker(this);
                }
                event.postToEventThread(this.minRefreshDelay);
            } else {
                long tmp = System.currentTimeMillis();
                if (tmp - this.prevRefreshEventTime > this.maxRefreshDelay) {
                    this.hasBeenPurged = false;
                    RefreshEvent event = new RefreshEvent(this);
                    event.postToEventThread(this.minRefreshDelay);
                    this.prevRefreshEventTime = System.currentTimeMillis();
                }
            }
        }
    }

    void eventThreadRevalidate() {
        if (this.docPane != null) {
            this.docPane.revalidate();
        }
        this.refreshEventComingUp = false;
    }

    public int getCount(int aType) {
        return this.getCount(aType, this.implicitAccessibilityPosition);
    }

    public int getCount(int aType, AccessPosition position) {
        if (aType < 0 || aType > 3) {
            throw new IllegalArgumentException("Boundary type enumeration out of range: " + aType);
        }
        if (this.topBox != null) {
            Point p = new Point();
            int count = this.topBox.getCount(aType, p);
            switch (aType) {
                case 1: {
                    position._maxCharacters = count;
                    break;
                }
                case 2: {
                    position._maxWords = count;
                    break;
                }
                case 3: {
                    position._maxSentences = count;
                }
            }
            return count;
        }
        return 0;
    }

    String getSelectedText() {
        return this.selectionAgent.toString();
    }

    int getSelectionStart() {
        CSSBox cb;
        this.checkInit(this.implicitAccessibilityPosition);
        int index = 0;
        DNode d = this.selectionAgent.getStartContainer();
        if (d != null && (cb = this.findCSSBox(d)) != null) {
            index = cb.getStartingCharacterOffset() + this.selectionAgent.getStartOffset();
        }
        return index;
    }

    int getSelectionEnd() {
        CSSBox cb;
        this.checkInit(this.implicitAccessibilityPosition);
        int index = 0;
        DNode d = this.selectionAgent.getEndContainer();
        if (d != null && (cb = this.findCSSBox(d)) != null && cb instanceof TextBox) {
            index = cb.getStartingCharacterOffset() + this.selectionAgent.getEndOffset();
        }
        return index;
    }

    public void positionToIndex(int aType, int aIndex) {
        this.positionToIndex(aType, aIndex, this.implicitAccessibilityPosition);
    }

    void positionToIndex(int aType, int aIndex, AccessPosition position) {
        this.checkInit(position);
        switch (aType) {
            case 1: {
                if (aIndex < 0 || aIndex >= position._maxCharacters) break;
                position._characterInDoc = aIndex;
                this.getText(aType, aIndex, position, true);
                break;
            }
            case 2: {
                if (aIndex < 0 || aIndex >= position._maxWords) break;
                position._wordInDoc = aIndex;
                this.getText(aType, aIndex, position, true);
                break;
            }
            case 3: {
                if (aIndex < 0 || aIndex >= position._maxSentences) break;
                position._sentenceInDoc = aIndex;
                this.getText(aType, aIndex, position, true);
            }
        }
    }

    String getText(int aType, int aIndex, boolean aUpdatePosition) {
        return this.getText(aType, aIndex, this.implicitAccessibilityPosition, aUpdatePosition);
    }

    String getText(int aType, int aIndex, AccessPosition position, boolean aUpdatePosition) {
        CSSBox node;
        this.checkInit(position);
        if (aIndex == -1) {
            aIndex = 0;
        }
        if (this.topBox != null && (node = ((BlockBox)this.topBox).findChildByIndex(aType, aIndex)) != null) {
            if (aUpdatePosition) {
                return node.getText(aType, aIndex, position);
            }
            return node.getText(aType, aIndex, this._tempPosition);
        }
        return null;
    }

    public DNode getNodeByIndex(int aType, int aIndex) {
        return this.getNodeByIndex(aType, aIndex, this.implicitAccessibilityPosition);
    }

    public DNode getNodeByIndex(int aType, int aIndex, AccessPosition position) {
        CSSBox node;
        this.checkInit(position);
        if (this.topBox != null && (node = ((BlockBox)this.topBox).findChildByIndex(aType, aIndex)) != null) {
            return node.getDomNode();
        }
        return null;
    }

    void checkInit(AccessPosition position) {
        if (position._needsReview) {
            this.getCount(1, position);
            this.getCount(2, position);
            this.getCount(3, position);
            if (position._characterInDoc > position._maxCharacters) {
                position._characterInDoc = 0;
            }
            if (position._wordInDoc > position._maxWords) {
                position._wordInDoc = 0;
            }
            if (position._sentenceInDoc > position._maxSentences) {
                position._sentenceInDoc = 0;
            }
            position._needsReview = false;
        }
    }

    String getCurrentText(int aType) {
        return this.getCurrentText(aType, this.implicitAccessibilityPosition);
    }

    String getCurrentText(int aType, AccessPosition position) {
        this.checkInit(position);
        switch (aType) {
            case 1: {
                if (position._characterInDoc >= position._maxCharacters) break;
                return this.getText(aType, position._characterInDoc, position, false);
            }
            case 2: {
                if (position._wordInDoc >= position._maxWords) break;
                return this.getText(aType, position._wordInDoc, position, false);
            }
            case 3: {
                if (position._sentenceInDoc >= position._maxSentences) break;
                return this.getText(aType, position._sentenceInDoc, position, false);
            }
        }
        return null;
    }

    String getTextAt(int aType, int aX, int aY, int scrollX, int scrollY) {
        int charIndex;
        this.checkInit(this.implicitAccessibilityPosition);
        this.implicitAccessibilityPosition._characterInDoc = charIndex = this.getIndexAtPoint(aX, aY, scrollX, scrollY);
        return this.getText(aType, charIndex, this.implicitAccessibilityPosition, true);
    }

    int getCaretPosition(int aType) {
        int returnVal = 0;
        switch (aType) {
            case 1: {
                returnVal = this.implicitAccessibilityPosition._characterInDoc;
                break;
            }
            case 2: {
                returnVal = this.implicitAccessibilityPosition._wordInDoc;
                break;
            }
            case 3: {
                returnVal = this.implicitAccessibilityPosition._sentenceInDoc;
            }
        }
        if (returnVal == -1) {
            returnVal = 0;
        }
        return returnVal;
    }

    public CSSAttribs getCharAttribs(int aIndex) {
        CSSBox node;
        this.checkInit(this.implicitAccessibilityPosition);
        if (this.topBox != null && (node = ((BlockBox)this.topBox).findChildByIndex(1, aIndex)) != null) {
            return node.css;
        }
        return null;
    }

    public int getIndexAtPoint(int aX, int aY, int scrollX, int scrollY) {
        return this.getIndexAtPoint(aX, aY, scrollX, scrollY, this.implicitAccessibilityPosition);
    }

    public int getIndexAtPoint(int aX, int aY, int scrollX, int scrollY, AccessPosition position) {
        this.checkInit(position);
        int charOffset = -1;
        int charPosition = -1;
        Point ppStart = new Point();
        Point absolutePositionStart = new Point();
        CSSBox startBox = this.getBoxAt(aX, aY, scrollX, scrollY, ppStart);
        if (startBox != null && startBox instanceof TextBox) {
            startBox.findAbsolutePosition(absolutePositionStart);
            charOffset = ((TextBox)startBox).getCharacterIndex(ppStart.x, false);
            charPosition = startBox.getStartingCharacterOffset() + charOffset;
            charPosition = charPosition > 0 ? --charPosition : 0;
        }
        return charPosition;
    }

    public String getNext(int aType) {
        return this.getNext(aType, this.implicitAccessibilityPosition);
    }

    public String getNext(int aType, AccessPosition position) {
        this.checkInit(position);
        switch (aType) {
            case 1: {
                if (position._characterInDoc < position._maxCharacters - 1) {
                    return this.getText(aType, position._characterInDoc + 1, position, true);
                }
                return this.getText(aType, 0, position, true);
            }
            case 2: {
                if (position._wordInDoc < position._maxWords - 1) {
                    return this.getText(aType, position._wordInDoc + 1, position, true);
                }
                return this.getText(aType, 0, position, true);
            }
            case 3: {
                if (position._sentenceInDoc < position._maxSentences - 1) {
                    return this.getText(aType, position._sentenceInDoc + 1, position, true);
                }
                return this.getText(aType, 0, position, true);
            }
        }
        return null;
    }

    public String getPrevious(int aType) {
        return this.getPrevious(aType, this.implicitAccessibilityPosition);
    }

    public String getPrevious(int aType, AccessPosition position) {
        this.checkInit(position);
        switch (aType) {
            case 1: {
                if (position._characterInDoc > 0) {
                    return this.getText(aType, position._characterInDoc - 1, position, true);
                }
                return this.getText(aType, position._maxCharacters - 1, position, true);
            }
            case 2: {
                if (position._wordInDoc > 0) {
                    return this.getText(aType, position._wordInDoc - 1, position, true);
                }
                return this.getText(aType, position._maxWords - 1, position, true);
            }
            case 3: {
                if (position._sentenceInDoc > 0) {
                    return this.getText(aType, position._sentenceInDoc - 1, position, true);
                }
                return this.getText(aType, position._maxSentences - 1, position, true);
            }
        }
        return null;
    }

    void moveCaretToNode(DNode eventTarget) {
        this.checkInit(this.implicitAccessibilityPosition);
        CSSBox box = this.findCSSBox(eventTarget);
        this.positionToIndex(1, box.getStartingCharacterOffset(), this.implicitAccessibilityPosition);
    }

    void setImageablePrintArea(Rectangle imageableRec) {
        this.imageablePrintArea = imageableRec;
    }

    static {
        antiAlias = null;
        textAntiAlias = null;
        renderQuality = null;
        alphaInterpolation = null;
        dithering = null;
        fractionalMetrics = null;
        interpolation = null;
        strokeControl = null;
        if (JavaVersion.isV12orGreater()) {
            renderingHints = CSSLayout.instantiateRenderingHints(true);
            cssDebugger = CSSLayout.instantiateDebugClass();
        }
    }
}

