/*
 * Decompiled with CFR 0.152.
 */
package coldfusion.cloud.aws.sns.producer;

import coldfusion.cloud.CloudService;
import coldfusion.cloud.CloudServiceProducer;
import coldfusion.cloud.aws.AWSCredential;
import coldfusion.cloud.aws.config.AWSServiceConfig;
import coldfusion.cloud.aws.sns.SNSClient;
import coldfusion.cloud.aws.sns.SNSClientImpl;
import coldfusion.cloud.aws.sns.SNSServiceConfig;
import java.util.HashMap;
import java.util.Map;

public class SNSProducer
implements CloudServiceProducer<AWSCredential, AWSServiceConfig> {
    private static Map<String, SNSClient> aliasToSNSClient = new HashMap<String, SNSClient>();

    public CloudService getServiceHandle(AWSCredential credential, AWSServiceConfig serviceConfig) {
        SNSServiceConfig config = (SNSServiceConfig)serviceConfig;
        String id = credential.hashCode() + "-" + config.hashCode();
        SNSClient sqsClient = aliasToSNSClient.get(id);
        if (sqsClient == null) {
            sqsClient = new SNSClientImpl(credential, config);
            aliasToSNSClient.put(id, sqsClient);
        }
        return sqsClient;
    }
}

