/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.parser.image.downsample;

import org.jpedal.color.DeviceRGBColorSpace;
import org.jpedal.color.GenericColorSpace;
import org.jpedal.images.SamplingFactory;
import org.jpedal.parser.image.PdfImageTypes;
import org.jpedal.parser.image.data.ImageData;
import org.jpedal.parser.image.downsample.KernelUtils;

final class EightBitDownSampler {
    private EightBitDownSampler() {
    }

    static GenericColorSpace downSample(ImageData imageData, GenericColorSpace decodeColorData, int sampling) {
        boolean needsSharpening;
        int origLineLength;
        byte[] newData;
        int comp;
        byte[] index = decodeColorData.getIndexedMap();
        boolean hasIndex = index != null;
        int indexCount = 1;
        boolean isBinary = true;
        if (hasIndex) {
            comp = 1;
            imageData.setCompCount(3);
            indexCount = 3;
            index = decodeColorData.convertIndexToRGB(index);
            isBinary = index.length == 6;
            decodeColorData = new DeviceRGBColorSpace();
        } else {
            comp = decodeColorData.getColorComponentCount();
        }
        int newW = imageData.getWidth() / sampling;
        int newH = imageData.getHeight() / sampling;
        byte[] data = imageData.getObjectData();
        int oldSize = data.length;
        if (imageData.getWidth() * imageData.getHeight() == oldSize || decodeColorData.getID() == 1568372915) {
            comp = 1;
        }
        if (hasIndex) {
            newData = new byte[newW * newH * indexCount];
            origLineLength = imageData.getWidth();
        } else {
            newData = new byte[newW * newH * comp];
            origLineLength = imageData.getWidth() * comp;
        }
        isBinary = hasIndex ? EightBitDownSampler.setIndexedPixels(imageData, sampling, index, comp, indexCount, isBinary, newW, newH, data, oldSize, origLineLength, newData) : EightBitDownSampler.setPixels(imageData, sampling, comp, newW, newH, data, oldSize, origLineLength, newData);
        if (isBinary) {
            imageData.setImageType(PdfImageTypes.Binary);
        }
        imageData.setObjectData(newData);
        imageData.setWidth(newW);
        imageData.setHeight(newH);
        boolean bl = needsSharpening = SamplingFactory.kernelSharpen || SamplingFactory.downsampleLevel == 5 || SamplingFactory.downsampleLevel == 6;
        if (needsSharpening && imageData.getImageType() == PdfImageTypes.Binary && sampling < 8) {
            KernelUtils.applyKernel(imageData, comp);
        }
        return decodeColorData;
    }

    private static boolean setPixels(ImageData imageData, int sampling, int comp, int newW, int newH, byte[] data, int oldSize, int origLineLength, byte[] newData) {
        boolean isBinary = true;
        for (int y = 0; y < newH; ++y) {
            for (int x = 0; x < newW; ++x) {
                int wCount = EightBitDownSampler.getwCount(imageData, sampling, x);
                int hCount = EightBitDownSampler.gethCount(imageData, sampling, y);
                isBinary = EightBitDownSampler.scanPixels(sampling, comp, newW, data, oldSize, origLineLength, newData, y, x, isBinary, wCount, hCount);
            }
        }
        return isBinary;
    }

    private static boolean scanPixels(int sampling, int comp, int newW, byte[] data, int oldSize, int origLineLength, byte[] newData, int y, int x, boolean isBinary, int wCount, int hCount) {
        for (int jj = 0; jj < comp; ++jj) {
            int byteTotal = 0;
            int count = 0;
            for (int yy = 0; yy < hCount; ++yy) {
                for (int xx = 0; xx < wCount; ++xx) {
                    int ptr = (yy + y * sampling) * origLineLength + (x * sampling * comp + xx * comp + jj);
                    if (ptr >= oldSize) continue;
                    byteTotal += data[ptr] & 0xFF;
                    isBinary = isBinary && (data[ptr] == 0 || data[ptr] == -1);
                    ++count;
                }
            }
            if (count <= 0) continue;
            int newPtr = jj + x * comp + newW * y * comp;
            newData[newPtr] = (byte)(byteTotal / count);
        }
        return isBinary;
    }

    private static int getwCount(ImageData imageData, int sampling, int x) {
        int wCount = sampling;
        int wGapLeft = imageData.getWidth() - x;
        if (wCount > wGapLeft) {
            wCount = wGapLeft;
        }
        return wCount;
    }

    private static int gethCount(ImageData imageData, int sampling, int y) {
        int hCount = sampling;
        int hGapLeft = imageData.getHeight() - y;
        if (hCount > hGapLeft) {
            hCount = hGapLeft;
        }
        return hCount;
    }

    private static boolean setIndexedPixels(ImageData imageData, int sampling, byte[] index, int comp, int indexCount, boolean isBinary, int newW, int newH, byte[] data, int oldSize, int origLineLength, byte[] newData) {
        for (int y = 0; y < newH; ++y) {
            for (int x = 0; x < newW; ++x) {
                isBinary = EightBitDownSampler.scanIndexedPixels(imageData, sampling, index, comp, indexCount, isBinary, newW, data, oldSize, origLineLength, newData, y, x);
            }
        }
        return isBinary;
    }

    private static boolean scanIndexedPixels(ImageData imageData, int sampling, byte[] index, int comp, int indexCount, boolean isBinary, int newW, byte[] data, int oldSize, int origLineLength, byte[] newData, int y, int x) {
        int wCount = EightBitDownSampler.getwCount(imageData, sampling, x);
        int hCount = EightBitDownSampler.gethCount(imageData, sampling, y);
        for (int jj = 0; jj < comp; ++jj) {
            int count = 0;
            int[] indexAv = new int[indexCount];
            for (int yy = 0; yy < hCount; ++yy) {
                for (int xx = 0; xx < wCount; ++xx) {
                    int ptr = (yy + y * sampling) * origLineLength + (x * sampling * comp + xx * comp + jj);
                    if (ptr >= oldSize) continue;
                    isBinary = EightBitDownSampler.scanValues(index, indexCount, isBinary, (data[ptr] & 0xFF) * indexCount, indexAv);
                    ++count;
                }
            }
            int newPtr = jj + x * indexCount + newW * y * indexCount;
            for (int aa = 0; aa < indexCount; ++aa) {
                newData[newPtr + aa] = (byte)(indexAv[aa] / count);
            }
        }
        return isBinary;
    }

    private static boolean scanValues(byte[] index, int indexCount, boolean isBinary, int i, int[] indexAv) {
        int aa = 0;
        while (aa < indexCount) {
            int byteValue = index[i + aa] & 0xFF;
            isBinary = isBinary && (byteValue == 0 || byteValue == 255);
            int n = aa++;
            indexAv[n] = indexAv[n] + byteValue;
        }
        return isBinary;
    }
}

