/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.jbig2.segment.pageinformation;

import org.jpedal.jbig2.decoders.JBIG2StreamDecoder;
import org.jpedal.jbig2.image.JBIG2Bitmap;
import org.jpedal.jbig2.segment.Segment;
import org.jpedal.jbig2.segment.pageinformation.PageInformationFlags;
import org.jpedal.jbig2.util.BinaryOperation;

public class PageInformationSegment
extends Segment {
    private int pageBitmapHeight;
    private final PageInformationFlags pageInformationFlags = new PageInformationFlags();
    private JBIG2Bitmap pageBitmap;

    public PageInformationSegment(JBIG2StreamDecoder streamDecoder) {
        super(streamDecoder);
    }

    public JBIG2Bitmap getPageBitmap() {
        return this.pageBitmap;
    }

    @Override
    public void readSegment() {
        short[] buff = new short[4];
        this.decoder.readByte(buff);
        int pageBitmapWidth = BinaryOperation.getInt32(buff);
        buff = new short[4];
        this.decoder.readByte(buff);
        this.pageBitmapHeight = BinaryOperation.getInt32(buff);
        buff = new short[4];
        this.decoder.readByte(buff);
        buff = new short[4];
        this.decoder.readByte(buff);
        short pageInformationFlagsField = this.decoder.readByte();
        this.pageInformationFlags.setFlags(pageInformationFlagsField);
        buff = new short[2];
        this.decoder.readByte(buff);
        int pageStriping = BinaryOperation.getInt16(buff);
        int defPix = this.pageInformationFlags.getFlagValue("DEFAULT_PIXEL_VALUE");
        int height = this.pageBitmapHeight == -1 ? pageStriping & Short.MAX_VALUE : this.pageBitmapHeight;
        this.pageBitmap = new JBIG2Bitmap(pageBitmapWidth, height, this.arithmeticDecoder, this.huffmanDecoder, this.mmrDecoder, this.decoder);
        this.pageBitmap.clear(defPix);
    }

    public int getPageBitmapHeight() {
        return this.pageBitmapHeight;
    }

    @Override
    public JBIG2Bitmap[] getBitmaps() {
        return null;
    }
}

