/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.io.types;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.jpedal.exception.PdfException;
import org.jpedal.io.ObjectDecoder;
import org.jpedal.io.PdfFileReader;
import org.jpedal.io.RandomAccessBuffer;
import org.jpedal.io.types.BrokenRefTable;
import org.jpedal.io.types.CompressedObjects;
import org.jpedal.io.types.Dictionary;
import org.jpedal.io.types.ObjectReader;
import org.jpedal.io.types.Offsets;
import org.jpedal.io.types.StreamReaderUtils;
import org.jpedal.io.types.Trailer;
import org.jpedal.objects.raw.CompressedObject;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.NumberUtils;

public class RefTable {
    private final Set<Integer> tablesRead = new HashSet<Integer>();
    private PdfObject encryptObj;
    private int size = -1;
    private byte[] ID;
    private static final String pattern = "obj";
    private PdfObject infoObject;
    private static final int UNSET = -1;
    private static final int COMPRESSED = 1;
    private static final int LEGACY = 2;
    private RandomAccessBuffer pdf_datafile;
    private static final byte[] oldPattern = new byte[]{120, 114, 101, 102};
    private final long eof;
    private final Offsets offset;
    private byte[] lastBytes;

    public RefTable(RandomAccessBuffer pdf_datafile, long eof, Offsets offset) {
        this.pdf_datafile = pdf_datafile;
        this.eof = eof;
        this.offset = offset;
    }

    private int readFirstStartRef() throws PdfException {
        this.offset.setRefTableInvalid(false);
        int pointer = -1;
        int i = 1019;
        StringBuilder startRef = new StringBuilder(10);
        int block = 1024;
        this.lastBytes = new byte[1024];
        i = this.getEndPoint(i);
        i = RefTable.findEndRef(i, this.lastBytes);
        if (i == -1) {
            return 0;
        }
        i += 5;
        while (i < 1024 && (this.lastBytes[i] == 10 || this.lastBytes[i] == 32 || this.lastBytes[i] == 13)) {
            ++i;
        }
        while (i < 1024 && this.lastBytes[i] != 10 && this.lastBytes[i] != 32 && this.lastBytes[i] != 13) {
            startRef.append((char)this.lastBytes[i]);
            ++i;
        }
        if (startRef.length() > 0) {
            pointer = Integer.parseInt(startRef.toString());
        }
        if (pointer == -1) {
            LogWriter.writeLog("No Startref found in last 1024 bytes ");
            try {
                this.closeFile();
            }
            catch (IOException e1) {
                LogWriter.writeLog("Exception " + e1 + " closing file");
            }
            throw new PdfException("No Startref found in last 1024 bytes ");
        }
        return pointer;
    }

    private static int findEndRef(int i, byte[] lastBytes) {
        int fileSize = lastBytes.length;
        if (i > fileSize) {
            i = fileSize - 5;
        }
        while (!(i <= -1 || (lastBytes[i] == 116 && lastBytes[i + 1] == 120 || lastBytes[i] == 114 && lastBytes[i + 1] == 116) && lastBytes[i + 2] == 114 && lastBytes[i + 3] == 101 && lastBytes[i + 4] == 102)) {
            --i;
        }
        return i;
    }

    private int getEndPoint(int i) throws PdfException {
        int[] EndOfFileMarker = new int[]{37, 37, 69, 79};
        int valReached = 3;
        boolean EOFFound = false;
        try {
            long end;
            block8: {
                end = this.eof;
                int bufSize = 255;
                do {
                    byte[] buffer = this.getBytes(end - 255L, 255);
                    int bytesScanned = 0;
                    for (int ii = 254; ii > -1; --ii) {
                        if (!EOFFound) {
                            valReached = 3;
                        }
                        if (buffer[ii] == EndOfFileMarker[valReached]) {
                            --valReached;
                            EOFFound = true;
                        } else {
                            EOFFound = false;
                        }
                        ++bytesScanned;
                        if (valReached >= 0) continue;
                        ii = -1;
                    }
                    if (valReached >= 0) continue;
                    end -= (long)bytesScanned;
                    break block8;
                } while ((end -= 255L) >= 0L);
                end = this.eof;
            }
            int count = (int)(end - 1024L);
            if (count < 0) {
                count = 0;
                int size = (int)this.eof;
                this.lastBytes = new byte[size];
                i = size + 3;
            }
            this.lastBytes = this.getBytes(count, this.lastBytes.length);
        }
        catch (Exception e) {
            LogWriter.writeLog("Exception " + e + " reading last 1024 bytes");
            throw new PdfException(e + " reading last 1024 bytes");
        }
        return i;
    }

    public final PdfObject readReferenceTable(PdfObject linearObj, PdfFileReader currentPdfFile, ObjectReader objectReader) throws PdfException {
        int pointer = -1;
        int eof = (int)this.eof;
        boolean islinearizedCompressed = false;
        if (linearObj == null) {
            pointer = this.readFirstStartRef();
        } else {
            byte[] data = this.pdf_datafile.getPdfBuffer();
            int count = data.length;
            int ptr = 5;
            for (int i = 0; i < count; ++i) {
                if (data[i] == 101 && data[i + 1] == 110 && data[i + 2] == 100 && data[i + 3] == 111 && data[i + 4] == 98 && data[i + 5] == 106) {
                    ptr = i + 6;
                }
                if (data[i] == 120 && data[i + 1] == 114 && data[i + 2] == 101 && data[i + 3] == 102) {
                    pointer = i;
                    i = count;
                    continue;
                }
                if (data[i] != 88 || data[i + 1] != 82 || data[i + 2] != 101 || data[i + 3] != 102) continue;
                islinearizedCompressed = true;
                pointer = ptr;
                while (data[pointer] == 10 || data[pointer] == 13 || data[pointer] == 32) {
                    ++pointer;
                }
                i = count;
            }
        }
        this.offset.addXref(pointer);
        PdfObject rootObj = null;
        boolean isInvalid = true;
        if (pointer >= eof || pointer == 0) {
            LogWriter.writeLog("Pointer not if file - trying to manually find startref");
        } else {
            try {
                if (islinearizedCompressed || this.isCompressedStream(pointer, eof)) {
                    rootObj = this.readCompressedStream(pointer, currentPdfFile, objectReader, linearObj);
                    isInvalid = false;
                } else {
                    rootObj = this.readLegacyReferenceTable(null, pointer, eof, currentPdfFile, objectReader);
                    int offsetSize = this.offset.getSize();
                    if (offsetSize == -1 || this.size == -1 || offsetSize == this.size) {
                        isInvalid = false;
                    }
                }
            }
            catch (Exception e) {
                LogWriter.writeLog("[PDF] Exception reading reg table " + e + " - trying to manually find startref");
            }
        }
        if (isInvalid) {
            this.offset.setRefTableInvalid(true);
            try {
                Object[] objs = BrokenRefTable.readCatalogObjects(this.pdf_datafile, this.offset, currentPdfFile, this.ID);
                rootObj = (PdfObject)objs[0];
                this.encryptObj = (PdfObject)objs[1];
                this.infoObject = (PdfObject)objs[2];
                this.ID = (byte[])objs[3];
            }
            catch (Error err) {
                throw new PdfException(err.getMessage() + " attempting to manually scan file for objects");
            }
            currentPdfFile.readObject(rootObj);
        }
        return rootObj;
    }

    private PdfObject readLegacyReferenceTable(PdfObject rootObj, int pointer, int eof, PdfFileReader currentPdfFile, ObjectReader objectReader) throws PdfException {
        byte[] Bytes;
        int iPointer = pointer;
        if (this.tablesRead.contains(iPointer)) {
            throw new RuntimeException("[PDF] Error Recursive refs table");
        }
        int current = 0;
        while ((Bytes = this.getByteBlock(pointer, eof)) != null) {
            int i;
            int maxLen = Bytes.length;
            boolean trailerNotFound = true;
            for (i = 0; i < maxLen - 7; ++i) {
                if (Bytes[i] != 116 || Bytes[i + 1] != 114 || Bytes[i + 2] != 97 || Bytes[i + 3] != 105 || Bytes[i + 4] != 108 || Bytes[i + 5] != 101 || Bytes[i + 6] != 114) continue;
                trailerNotFound = false;
                break;
            }
            int endTable = i;
            if (i == Bytes.length || trailerNotFound) break;
            while (Bytes[i] != 60 && Bytes[i - 1] != 60) {
                ++i;
            }
            CompressedObject pdfObject = new CompressedObject("0 0 R");
            Dictionary.readDictionary(pdfObject, ++i, Bytes, -1, currentPdfFile);
            i = Dictionary.handleDirectDictionary(i, Bytes);
            pointer = RefTable.getPointer(pointer, Bytes, i);
            i = StreamReaderUtils.skipSpaces(Bytes, 0);
            if (pointer == -1) {
                LogWriter.writeLog("No startRef");
            } else if (Bytes[i] == 120 && Bytes[i + 1] == 114 && Bytes[i + 2] == 101 && Bytes[i + 3] == 102) {
                i = StreamReaderUtils.skipSpaces(Bytes, 5);
                current = this.offset.readXRefs(current, Bytes, endTable, i, eof, this.pdf_datafile);
                int XRefStm = ((PdfObject)pdfObject).getInt(910911090);
                if (XRefStm != -1) {
                    this.movePointer(XRefStm);
                    RefTable.readStreamTableData(currentPdfFile, objectReader, this.offset, this.pdf_datafile);
                }
                rootObj = this.processTrailer(rootObj, pdfObject);
                pointer = ((PdfObject)pdfObject).getInt(541209926);
                if (pointer != -1 && (long)pointer < this.eof) {
                    this.offset.addXref(pointer);
                } else {
                    pointer = -1;
                }
            } else {
                pointer = -1;
                Object[] objs = BrokenRefTable.readCatalogObjects(this.pdf_datafile, this.offset, currentPdfFile, this.ID);
                rootObj = (PdfObject)objs[0];
                this.encryptObj = (PdfObject)objs[1];
                this.infoObject = (PdfObject)objs[2];
                this.ID = (byte[])objs[3];
                currentPdfFile.readObject(rootObj);
                this.offset.setRefTableInvalid(true);
            }
            if (pointer != -1) continue;
            break;
        }
        if (this.encryptObj == null && rootObj != null) {
            rootObj = RefTable.handleBrokenFile(rootObj, currentPdfFile);
        }
        if (rootObj == null) {
            rootObj = this.handleNullValue(currentPdfFile);
        }
        if (this.encryptObj == null) {
            this.tablesRead.add(iPointer);
        }
        return rootObj;
    }

    private PdfObject handleNullValue(PdfFileReader currentPdfFile) throws PdfException {
        this.offset.clear();
        this.offset.reuse();
        Object[] objs = BrokenRefTable.readCatalogObjects(this.pdf_datafile, this.offset, currentPdfFile, this.ID);
        PdfObject rootObj = (PdfObject)objs[0];
        this.encryptObj = (PdfObject)objs[1];
        this.infoObject = (PdfObject)objs[2];
        this.ID = (byte[])objs[3];
        currentPdfFile.readObject(rootObj);
        this.offset.setRefTableInvalid(true);
        return rootObj;
    }

    private byte[] getByteBlock(int pointer, int eof) throws PdfException {
        byte[] Bytes;
        try {
            Bytes = Trailer.readTrailer(1024, pointer, eof, this.pdf_datafile);
        }
        catch (Exception e) {
            try {
                this.closeFile();
            }
            catch (IOException e1) {
                LogWriter.writeLog("Exception " + e + " closing file " + e1);
            }
            throw new PdfException("Exception " + e + " reading trailer");
        }
        return Bytes;
    }

    private static PdfObject handleBrokenFile(PdfObject rootObj, PdfFileReader currentPdfFile) {
        int type = -1;
        int status = rootObj.getStatus();
        byte[] data = rootObj.getUnresolvedData();
        try {
            ObjectDecoder objectDecoder = new ObjectDecoder(currentPdfFile);
            objectDecoder.checkResolved(rootObj);
            type = rootObj.getParameterConstant(608780341);
        }
        catch (Exception e) {
            rootObj.setStatus(status);
            rootObj.setUnresolvedData(data, status);
            LogWriter.writeLog("[PDF] Exception reading type on root object " + e);
        }
        if (type == 373243460) {
            rootObj = null;
        }
        return rootObj;
    }

    private static int getPointer(int pointer, byte[] bytes, int i) {
        int s;
        boolean hasRef = true;
        i = StreamReaderUtils.skipSpaces(bytes, i);
        while (bytes[i] == 37) {
            while (bytes[i] != 10) {
                ++i;
            }
            ++i;
        }
        while (bytes[i] != 116 && bytes[i + 1] != 120 && bytes[i + 2] != 114 && bytes[i + 3] != 101 && bytes[i + 4] != 102) {
            if (bytes[i] == 111 && bytes[i + 1] == 98 && bytes[i + 2] == 106) {
                hasRef = false;
                break;
            }
            ++i;
        }
        if (hasRef && (s = (i = StreamReaderUtils.skipSpaces(bytes, i + 8))) != (i = StreamReaderUtils.skipToEndOfKey(bytes, i))) {
            pointer = NumberUtils.parseInt(s, i, bytes);
        }
        return pointer;
    }

    private PdfObject readCompressedStream(int pointer, PdfFileReader currentPdfFile, ObjectReader objectReader, PdfObject linearObj) throws PdfException {
        PdfObject rootObj = null;
        while (pointer != -1) {
            this.movePointer(pointer);
            PdfObject pdfObject = RefTable.readStreamTableData(currentPdfFile, objectReader, this.offset, this.pdf_datafile);
            rootObj = this.processTrailer(rootObj, pdfObject);
            if (linearObj != null) {
                pointer = -1;
                continue;
            }
            pointer = pdfObject.getInt(541209926);
            if (pointer == -1 || this.isCompressedStream(pointer, (int)this.eof)) continue;
            return this.readLegacyReferenceTable(rootObj, pointer, (int)this.eof, currentPdfFile, objectReader);
        }
        return rootObj;
    }

    private static PdfObject readStreamTableData(PdfFileReader currentPdfFile, ObjectReader objectReader, Offsets offset, RandomAccessBuffer pdf_datafile) throws PdfException {
        int[] Index;
        byte[] raw = objectReader.readObjectData(-1, null);
        CompressedObject pdfObject = new CompressedObject(RefTable.getObjectName(raw));
        pdfObject.setCompressedStream(true);
        ObjectDecoder objectDecoder = new ObjectDecoder(currentPdfFile);
        objectDecoder.readDictionaryAsObject(pdfObject, 0, raw);
        int[] fieldSizes = ((PdfObject)pdfObject).getIntArray(39);
        byte[] xrefs = pdfObject.getDecodedStream();
        if (xrefs == null) {
            xrefs = currentPdfFile.readStream(pdfObject, true, true, false, false, true, null);
        }
        if ((Index = ((PdfObject)pdfObject).getIntArray(1043608929)) == null) {
            CompressedObjects.readCompressedOffsets(0, 0, ((PdfObject)pdfObject).getInt(590957109), fieldSizes, xrefs, offset, pdf_datafile);
        } else {
            int count = Index.length;
            int pntr = 0;
            for (int aa = 0; aa < count; aa += 2) {
                pntr = CompressedObjects.readCompressedOffsets(pntr, Index[aa], Index[aa + 1], fieldSizes, xrefs, offset, pdf_datafile);
            }
        }
        return pdfObject;
    }

    private PdfObject processTrailer(PdfObject rootObj, PdfObject pdfObject) {
        if (rootObj == null) {
            byte[][] IDs;
            rootObj = pdfObject.getDictionary(574570308);
            this.encryptObj = pdfObject.getDictionary(1113489015);
            if (this.encryptObj != null && (IDs = pdfObject.getStringArray(6420)) != null && this.ID == null) {
                this.ID = IDs[0];
            }
            this.infoObject = pdfObject.getDictionary(423507519);
        }
        if (pdfObject != null) {
            this.size = pdfObject.getInt(590957109);
        }
        return rootObj;
    }

    private static String getObjectName(byte[] raw) {
        StringBuilder objectName = new StringBuilder();
        int last = 32;
        int matched = 0;
        int length = raw.length;
        for (int i1 = 0; i1 < length; ++i1) {
            char current1 = (char)raw[i1];
            if (current1 == '\n' || current1 == '\r') {
                current1 = ' ';
            }
            if (current1 == ' ' && last == 32) {
                matched = 0;
            } else if (current1 == pattern.charAt(matched)) {
                ++matched;
            } else {
                matched = 0;
                objectName.append(current1);
            }
            if (matched == 3) break;
            last = current1;
        }
        objectName.append('R');
        return objectName.toString();
    }

    private byte[] getBytes(long start, int count) {
        byte[] buffer = new byte[count];
        if (start >= 0L) {
            try {
                this.pdf_datafile.seek(start);
                this.pdf_datafile.read(buffer);
            }
            catch (IOException e) {
                LogWriter.writeLog("Exception: " + e.getMessage());
            }
        }
        return buffer;
    }

    private void closeFile() throws IOException {
        if (this.pdf_datafile != null) {
            this.pdf_datafile.close();
            this.pdf_datafile = null;
        }
    }

    private boolean isCompressedStream(int pointer, int eof) {
        int bufSize = 50;
        int charReached_legacy = 0;
        int charReached_comp1 = 0;
        int charReached_comp2 = 0;
        int[] objStm = new int[]{79, 98, 106, 83, 116, 109};
        int[] XRef = new int[]{88, 82, 101, 102};
        int type = -1;
        int bytesScanned = 0;
        boolean firstRead = true;
        while (true) {
            if ((bufSize = RefTable.setBufferSize(pointer, eof, bufSize)) == 0) {
                return false;
            }
            if (pointer < 0) {
                pointer += bufSize;
                continue;
            }
            byte[] buffer = this.getBytes(pointer, bufSize);
            if (firstRead && buffer[0] == 114 && buffer[1] == 101 && buffer[2] == 102) {
                charReached_legacy = 1;
            }
            firstRead = false;
            for (int i = 0; i < bufSize; ++i) {
                byte currentByte = buffer[i];
                if (currentByte == oldPattern[charReached_legacy] && type != 1) {
                    ++charReached_legacy;
                    type = 2;
                } else if (currentByte == objStm[charReached_comp1]) {
                    ++charReached_comp1;
                    type = 1;
                } else if (currentByte == XRef[charReached_comp2]) {
                    ++charReached_comp2;
                    type = 1;
                } else {
                    charReached_legacy = 0;
                    charReached_comp1 = 0;
                    charReached_comp2 = 0;
                    type = -1;
                }
                if (bytesScanned > 65536) {
                    type = -1;
                    break;
                }
                ++bytesScanned;
                if (charReached_legacy == 3 || charReached_comp1 == 4 || charReached_comp2 == 4) break;
            }
            if (charReached_legacy == 3 || charReached_comp1 == 4 || charReached_comp2 == 4) break;
            pointer += bufSize;
        }
        return type == 1;
    }

    private static int setBufferSize(int pointer, int eof, int bufSize) {
        if (pointer + bufSize > eof) {
            bufSize = eof - pointer;
        }
        if (bufSize < 0) {
            bufSize = 50;
        }
        return bufSize;
    }

    public PdfObject getInfoObject() {
        return this.infoObject;
    }

    public PdfObject getEncryptionObject() {
        return this.encryptObj;
    }

    public byte[] getID() {
        return this.ID;
    }

    private void movePointer(long pointer) {
        try {
            if (pointer > this.pdf_datafile.length()) {
                LogWriter.writeLog("Attempting to access ref outside file");
            } else {
                this.pdf_datafile.seek(pointer);
            }
        }
        catch (Exception e) {
            LogWriter.writeLog("Exception " + e + " moving pointer to  " + pointer + " in file.");
        }
    }
}

