/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.io.security;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Map;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import org.jpedal.io.IdrInputStream;
import org.jpedal.io.IdrOutputStream;
import org.jpedal.io.ObjectStore;
import org.jpedal.io.security.CryptoIDR;
import org.jpedal.utils.LogWriter;

class CachedDataHelper {
    private final Map<String, String> cachedObjects;
    private BufferedOutputStream streamCache;
    private BufferedInputStream bis;

    CachedDataHelper(Map<String, String> cachedObjects) {
        this.cachedObjects = cachedObjects;
    }

    byte[] init(byte[] data, String cacheName, byte[] encHash) {
        byte[] AESData = null;
        try {
            if (data == null) {
                AESData = new byte[16];
                try (IdrInputStream fis = new IdrInputStream(new FileInputStream(cacheName), new CryptoIDR(encHash));){
                    fis.read(AESData);
                }
            }
            File tempFile2 = File.createTempFile("jpedal", ".raw", new File(ObjectStore.temp_dir));
            this.cachedObjects.put(tempFile2.getAbsolutePath(), "x");
            ObjectStore.copy(cacheName, tempFile2.getAbsolutePath());
            File rawFile = new File(cacheName);
            rawFile.delete();
            this.streamCache = new BufferedOutputStream(new IdrOutputStream(new FileOutputStream(cacheName), new CryptoIDR(encHash)));
            this.bis = new BufferedInputStream(new IdrInputStream(new FileInputStream(tempFile2), new CryptoIDR(encHash)));
        }
        catch (IOException e1) {
            LogWriter.writeLog("Exception " + e1 + " in decrypt");
        }
        return AESData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writeOutCachedData(Cipher cipher) throws IOException {
        try (CipherInputStream cis = new CipherInputStream(this.bis, cipher);){
            int nextByte;
            while ((nextByte = cis.read()) != -1) {
                this.streamCache.write(nextByte);
            }
        }
        finally {
            try {
                if (this.streamCache != null) {
                    this.streamCache.close();
                }
            }
            catch (Exception e) {
                LogWriter.writeLog(e);
            }
        }
    }

    void skip() {
        try {
            if (this.bis != null) {
                this.bis.skip(16L);
            }
        }
        catch (IOException e) {
            LogWriter.writeLog("Exception: " + e.getMessage());
        }
    }
}

