/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.io.filter;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.util.Map;
import org.jpedal.io.filter.BaseFilter;
import org.jpedal.io.filter.PdfFilter;
import org.jpedal.io.types.StreamReaderUtils;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.parser.text.HexTextUtils;
import org.jpedal.utils.FastByteArrayOutputStream;
import org.jpedal.utils.LogWriter;

public class ASCIIHex
extends BaseFilter
implements PdfFilter {
    public ASCIIHex(PdfObject decodeParms) {
        super(decodeParms);
    }

    @Override
    public byte[] decode(byte[] data) {
        int length = data.length;
        if (data[length - 1] == 62) {
            --length;
        }
        FastByteArrayOutputStream bos2 = new FastByteArrayOutputStream(length + 1 >> 1);
        int b = StreamReaderUtils.skipSpaces(data, 0);
        while (b < length) {
            int charCount = HexTextUtils.getHexCharCount(b, data, 2);
            bos2.write(HexTextUtils.getHexValue(b, charCount, data));
            if (charCount == 0) break;
            b = StreamReaderUtils.skipSpaces(data, b + charCount);
        }
        return bos2.toByteArray();
    }

    @Override
    public void decode(BufferedInputStream bis, BufferedOutputStream streamCache, String cacheName, Map<String, String> cachedObjects) {
        this.bis = bis;
        this.streamCache = streamCache;
        this.cachedObjects = cachedObjects;
        try {
            StringBuilder value = new StringBuilder();
            int count = bis.available();
            for (int i = 0; i < count; ++i) {
                char current = (char)bis.read();
                while (current == '\n') {
                    current = (char)bis.read();
                }
                if (current >= '0' && current <= '9' || current >= 'a' && current <= 'f' || current >= 'A' && current <= 'F') {
                    value.append(current);
                    if (count == 1) {
                        streamCache.write(Integer.valueOf(value.toString(), 16));
                        count = 0;
                        value = new StringBuilder();
                    } else {
                        ++count;
                    }
                }
                if (current == '>') break;
            }
            if (count == 1) {
                value.append('0');
                streamCache.write(Integer.valueOf(value.toString(), 16));
            }
        }
        catch (IOException e1) {
            LogWriter.writeLog("IO exception in RunLength " + e1);
        }
    }
}

