/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.fonts.tt;

import java.io.Serializable;
import java.util.ArrayList;
import org.jpedal.fonts.objects.FontData;

public class FontFile2
implements Serializable {
    private static final long serialVersionUID = -3097990864237320960L;
    public static final int HEAD = 0;
    public static final int MAXP = 1;
    public static final int CMAP = 2;
    public static final int LOCA = 3;
    public static final int GLYF = 4;
    public static final int HHEA = 5;
    public static final int HMTX = 6;
    public static final int NAME = 7;
    public static final int POST = 8;
    public static final int CVT = 9;
    public static final int FPGM = 10;
    private static final int HDMX = 11;
    private static final int KERN = 12;
    public static final int OS2 = 13;
    public static final int PREP = 14;
    private static final int DSIG = 15;
    public static final int CFF = 16;
    private static final int GSUB = 17;
    private static final int BASE = 18;
    private static final int EBDT = 19;
    private static final int EBLC = 20;
    private static final int GASP = 21;
    private static final int VHEA = 22;
    private static final int VMTX = 23;
    private static final int GDEF = 24;
    private static final int JSTF = 25;
    private static final int LTSH = 26;
    private static final int PCLT = 27;
    private static final int VDMX = 28;
    private static final int BSLN = 29;
    private static final int MORT = 30;
    private static final int FDSC = 31;
    private static final int FFTM = 32;
    private static final int GPOS = 33;
    private static final int FEAT = 34;
    private static final int JUST = 35;
    private static final int PROP = 36;
    private static final int LCCL = 37;
    private static final int Zapf = 38;
    protected static final int MAX_TABLE_COUNT = 39;
    protected int[][] checksums;
    protected int[][] tables;
    protected int[][] tableLength;
    private FontData fontDataAsObject;
    private byte[] fontDataAsArray;
    private boolean useArray = true;
    protected ArrayList<String> tableList = new ArrayList(32);
    private int pointer;
    protected static final int OPENTYPE = 1;
    private static final int TRUETYPE = 2;
    protected static final int TTC = 3;
    protected static final int PS = 10;
    protected static final int TTF = 11;
    protected int subType = 10;
    protected int type = 2;
    protected int currentFontID;
    private int fontCount = 1;
    protected int numTables = 11;
    protected int searchRange = 128;
    protected int entrySelector = 3;
    protected int rangeShift = 48;

    public FontFile2(FontData data) {
        this.useArray = false;
        this.fontDataAsObject = data;
        this.readHeader();
    }

    public FontFile2(byte[] data) {
        this.fontDataAsArray = data;
        this.readHeader();
    }

    public FontFile2(byte[] data, boolean ignoreHeaders) {
        this.fontDataAsArray = data;
        if (!ignoreHeaders) {
            this.readHeader();
        }
    }

    protected FontFile2() {
    }

    public void setSelectedFontIndex(int currentFontID) {
        if (currentFontID < this.fontCount) {
            this.currentFontID = currentFontID;
        }
    }

    private void readHeader() {
        int scalerType = this.getNextUint32();
        if (scalerType == 0x4F54544F) {
            this.type = 1;
        } else if (scalerType == 1953784678) {
            this.type = 3;
        }
        if (this.type == 3) {
            int currentFont;
            this.getNextUint32();
            this.fontCount = this.getNextUint32();
            this.checksums = new int[39][this.fontCount];
            this.tables = new int[39][this.fontCount];
            this.tableLength = new int[39][this.fontCount];
            int[] fontOffsets = new int[this.fontCount];
            for (currentFont = 0; currentFont < this.fontCount; ++currentFont) {
                int fontStart;
                this.currentFontID = currentFont;
                fontOffsets[currentFont] = fontStart = this.getNextUint32();
            }
            for (currentFont = 0; currentFont < this.fontCount; ++currentFont) {
                this.currentFontID = currentFont;
                this.pointer = fontOffsets[currentFont];
                this.getNextUint32();
                this.readTablesForFont();
            }
            this.currentFontID = 0;
        } else {
            this.checksums = new int[39][1];
            this.tables = new int[39][1];
            this.tableLength = new int[39][1];
            this.readTablesForFont();
        }
    }

    private void readTablesForFont() {
        this.numTables = this.getNextUint16();
        this.searchRange = this.getNextUint16();
        this.entrySelector = this.getNextUint16();
        this.rangeShift = this.getNextUint16();
        for (int l = 0; l < this.numTables; ++l) {
            String tag = this.getNextUint32AsTag();
            int checksum = this.getNextUint32();
            int offset = this.getNextUint32();
            int length = this.getNextUint32();
            this.tableList.add(tag);
            int id = FontFile2.getTableID(tag);
            if (id == -1 || length == 0) continue;
            this.checksums[id][this.currentFontID] = checksum;
            this.tables[id][this.currentFontID] = offset;
            this.tableLength[id][this.currentFontID] = length;
        }
    }

    protected static int getTableID(String tag) {
        int id = -1;
        switch (tag) {
            case "maxp": {
                id = 1;
                break;
            }
            case "head": {
                id = 0;
                break;
            }
            case "cmap": {
                id = 2;
                break;
            }
            case "loca": {
                id = 3;
                break;
            }
            case "glyf": {
                id = 4;
                break;
            }
            case "hhea": {
                id = 5;
                break;
            }
            case "hmtx": {
                id = 6;
                break;
            }
            case "name": {
                id = 7;
                break;
            }
            case "post": {
                id = 8;
                break;
            }
            case "cvt ": {
                id = 9;
                break;
            }
            case "fpgm": {
                id = 10;
                break;
            }
            case "hdmx": {
                id = 11;
                break;
            }
            case "kern": {
                id = 12;
                break;
            }
            case "OS/2": {
                id = 13;
                break;
            }
            case "prep": {
                id = 14;
                break;
            }
            case "DSIG": {
                id = 15;
                break;
            }
            case "BASE": {
                id = 18;
                break;
            }
            case "CFF ": {
                id = 16;
                break;
            }
            case "GSUB": {
                id = 17;
                break;
            }
            case "EBDT": {
                id = 19;
                break;
            }
            case "EBLC": {
                id = 20;
                break;
            }
            case "gasp": {
                id = 21;
                break;
            }
            case "vhea": {
                id = 22;
                break;
            }
            case "vmtx": {
                id = 23;
                break;
            }
            case "GDEF": {
                id = 24;
                break;
            }
            case "JSTF": {
                id = 25;
                break;
            }
            case "LTSH": {
                id = 26;
                break;
            }
            case "PCLT": {
                id = 27;
                break;
            }
            case "VDMX": {
                id = 28;
                break;
            }
            case "mort": {
                id = 30;
                break;
            }
            case "bsln": {
                id = 29;
                break;
            }
            case "fdsc": {
                id = 31;
                break;
            }
            case "FFTM": {
                id = 32;
                break;
            }
            case "GPOS": {
                id = 33;
                break;
            }
            case "feat": {
                id = 34;
                break;
            }
            case "just": {
                id = 35;
                break;
            }
            case "prop": {
                id = 36;
                break;
            }
            case "LCCL": {
                id = 37;
                break;
            }
            case "Zapf": {
                id = 38;
                break;
            }
        }
        return id;
    }

    public int selectTable(int tableID) {
        this.pointer = this.tables[tableID][this.currentFontID];
        return this.pointer;
    }

    public int getTableSize(int tableID) {
        return this.tableLength[tableID][this.currentFontID];
    }

    public int getTableStart(int tableID) {
        return this.tables[tableID][this.currentFontID];
    }

    public final int getNextUint32() {
        int returnValue = 0;
        for (int i = 0; i < 4; ++i) {
            int nextValue = this.useArray ? (this.pointer < this.fontDataAsArray.length ? this.fontDataAsArray[this.pointer] & 0xFF : 0) : this.fontDataAsObject.getByte(this.pointer) & 0xFF;
            returnValue += nextValue << 8 * (3 - i);
            ++this.pointer;
        }
        return returnValue;
    }

    public final int getNextUint64() {
        int returnValue = 0;
        for (int i = 0; i < 8; ++i) {
            int nextValue = this.useArray ? this.fontDataAsArray[this.pointer] : this.fontDataAsObject.getByte(this.pointer);
            if (nextValue < 0) {
                nextValue = 256 + nextValue;
            }
            returnValue += nextValue << 8 * (7 - i);
            ++this.pointer;
        }
        return returnValue;
    }

    public final void setPointer(int p) {
        this.pointer = p;
    }

    public final int getOffset(int tableID) {
        return this.tableLength[tableID][this.currentFontID];
    }

    public final int getPointer() {
        return this.pointer;
    }

    private String getNextUint32AsTag() {
        StringBuilder returnValue = new StringBuilder();
        for (int i = 0; i < 4; ++i) {
            char c = this.useArray ? (char)this.fontDataAsArray[this.pointer] : (char)this.fontDataAsObject.getByte(this.pointer);
            returnValue.append(c);
            ++this.pointer;
        }
        return returnValue.toString();
    }

    public final int getNextUint16() {
        int returnValue = 0;
        for (int i = 0; i < 2; ++i) {
            int nextValue = this.useArray ? this.fontDataAsArray[this.pointer] & 0xFF : this.fontDataAsObject.getByte(this.pointer) & 0xFF;
            returnValue += nextValue << 8 * (1 - i);
            ++this.pointer;
        }
        return returnValue;
    }

    public final int getNextUint8() {
        int nextValue = this.useArray ? this.fontDataAsArray[this.pointer] & 0xFF : this.fontDataAsObject.getByte(this.pointer) & 0xFF;
        ++this.pointer;
        return nextValue;
    }

    public final int getNextint8() {
        byte nextValue = this.useArray ? this.fontDataAsArray[this.pointer] : this.fontDataAsObject.getByte(this.pointer);
        ++this.pointer;
        return nextValue;
    }

    public void skip(int i) {
        this.pointer += i;
    }

    public short getFWord() {
        int returnValue = 0;
        for (int i = 0; i < 2; ++i) {
            int nextValue = this.useArray ? this.fontDataAsArray[this.pointer] & 0xFF : this.fontDataAsObject.getByte(this.pointer) & 0xFF;
            returnValue += nextValue << 8 * (1 - i);
            ++this.pointer;
        }
        return (short)returnValue;
    }

    public short getNextInt16() {
        int returnValue = 0;
        for (int i = 0; i < 2; ++i) {
            int nextValue = this.useArray ? this.fontDataAsArray[this.pointer] & 0xFF : this.fontDataAsObject.getByte(this.pointer) & 0xFF;
            returnValue += nextValue << 8 * (1 - i);
            ++this.pointer;
        }
        return (short)returnValue;
    }

    public short getNextSignedInt16() {
        int returnValue = 0;
        for (int i = 0; i < 2; ++i) {
            int nextValue = this.useArray ? this.fontDataAsArray[this.pointer] & 0xFF : this.fontDataAsObject.getByte(this.pointer) & 0xFF;
            returnValue += nextValue << 8 * (1 - i);
            ++this.pointer;
        }
        return (short)returnValue;
    }

    public short readUFWord() {
        int returnValue = 0;
        for (int i = 0; i < 2; ++i) {
            int nextValue = this.useArray ? this.fontDataAsArray[this.pointer] & 0xFF : this.fontDataAsObject.getByte(this.pointer) & 0xFF;
            returnValue += nextValue << 8 * (1 - i);
            ++this.pointer;
        }
        return (short)returnValue;
    }

    public float getFixed() {
        int number = this.useArray ? (this.fontDataAsArray[this.pointer] & 0xFF) * 256 + (this.fontDataAsArray[this.pointer + 1] & 0xFF) : (this.fontDataAsObject.getByte(this.pointer) & 0xFF) * 256 + (this.fontDataAsObject.getByte(this.pointer + 1) & 0xFF);
        if (number > 32768) {
            number -= 65536;
        }
        this.pointer += 2;
        int dec = this.useArray ? (this.fontDataAsArray[this.pointer] & 0xFF) * 256 + (this.fontDataAsArray[this.pointer + 1] & 0xFF) : (this.fontDataAsObject.getByte(this.pointer) & 0xFF) * 256 + (this.fontDataAsObject.getByte(this.pointer + 1) & 0xFF);
        this.pointer += 2;
        return (float)number + (float)dec / 65536.0f;
    }

    public String getString() {
        if (this.useArray && this.pointer == this.fontDataAsArray.length) {
            return "";
        }
        int length = this.useArray ? this.fontDataAsArray[this.pointer] & 0xFF : this.fontDataAsObject.getByte(this.pointer) & 0xFF;
        char[] chars = new char[length];
        ++this.pointer;
        for (int i = 0; i < length; ++i) {
            int nextChar = this.useArray ? this.fontDataAsArray[this.pointer] & 0xFF : this.fontDataAsObject.getByte(this.pointer) & 0xFF;
            ++this.pointer;
            chars[i] = (char)nextChar;
            if (!this.useArray || this.pointer < this.fontDataAsArray.length) continue;
            i = length;
        }
        return String.copyValueOf(chars);
    }

    public float getF2Dot14() {
        int firstValue = this.useArray ? ((this.fontDataAsArray[this.pointer] & 0xFF) << 8) + (this.fontDataAsArray[this.pointer + 1] & 0xFF) : ((this.fontDataAsObject.getByte(this.pointer) & 0xFF) << 8) + (this.fontDataAsObject.getByte(this.pointer + 1) & 0xFF);
        this.pointer += 2;
        switch (firstValue) {
            case 49152: {
                return -1.0f;
            }
            case 16384: {
                return 1.0f;
            }
        }
        return (float)(firstValue - 2 * (firstValue & 0x8000)) / 16384.0f;
    }

    public byte[] readBytes(int startPointer, int length) {
        if (this.useArray) {
            byte[] block = new byte[length];
            System.arraycopy(this.fontDataAsArray, startPointer, block, 0, length);
            return block;
        }
        return this.fontDataAsObject.getBytes(startPointer, length);
    }

    public byte[] getTableBytes(int tableID) {
        int startPointer = this.tables[tableID][this.currentFontID];
        int length = this.tableLength[tableID][this.currentFontID];
        if (this.useArray) {
            if (this.fontDataAsArray.length - startPointer < length) {
                length = this.fontDataAsArray.length - startPointer;
            }
            byte[] block = new byte[length];
            System.arraycopy(this.fontDataAsArray, startPointer, block, 0, length);
            return block;
        }
        return this.fontDataAsObject.getBytes(startPointer, length);
    }

    public int getFontCount() {
        return this.fontCount;
    }

    public boolean hasValuesLeft() {
        int size = this.useArray ? this.fontDataAsArray.length : this.fontDataAsObject.length();
        return this.pointer < size;
    }

    public int getBytesLeft() {
        int size = this.useArray ? this.fontDataAsArray.length : this.fontDataAsObject.length();
        return size - this.pointer;
    }
}

