/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.fonts.tt;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.jpedal.fonts.StandardFonts;
import org.jpedal.fonts.tt.FontFile2;
import org.jpedal.fonts.tt.Table;
import org.jpedal.fonts.tt.cmap.Format;
import org.jpedal.fonts.tt.cmap.Format0;
import org.jpedal.fonts.tt.cmap.Format12;
import org.jpedal.fonts.tt.cmap.Format2;
import org.jpedal.utils.LogWriter;

public class CMAP
extends Table {
    private static final boolean debugMarksOldCode = false;
    private static final int PLATFORM_UNICODE = 0;
    private static final int PLATFORM_MAC = 1;
    private static final int PLATFORM_WIN = 3;
    private static final int ENCODING_SYMBOL = 0;
    private static final int ENCODING_UNICODE_BMP = 1;
    private static final int ENCODING_PRC = 3;
    protected int[][] glyphIndexToChar;
    private boolean hasFormat4;
    private boolean hasFormat6;
    private int lastFormat4Found = -1;
    private boolean remapEncoding;
    private int segCount;
    protected int[] endCode;
    protected int[] startCode;
    protected int[] idDelta;
    protected int[] idRangeOffset;
    protected int[] glyphIdArray;
    private int[] f6glyphIdArray;
    private int firstCode = -1;
    private int entryCount = -1;
    protected int[] CMAPformats;
    protected int[] CMAPlength;
    protected int[] CMAPlang;
    protected int[] CMAPsegCount;
    protected int[] CMAPsearchRange;
    protected int[] CMAPentrySelector;
    protected int[] CMAPrangeShift;
    protected int[] CMAPreserved;
    private Map<Integer, Integer> glyfValues;
    protected int[] platformID;
    private static final Map<String, Integer> exceptions = new HashMap<String, Integer>();
    private int subtableToUse;
    protected int id;
    protected int subtableCount;
    protected int[] CMAPsubtables;
    protected int[] encodingID;
    private int fontEncoding;
    private Format table;

    public CMAP(FontFile2 currentFontFile, int startPointer) {
        if (startPointer == 0) {
            LogWriter.writeLog("No CMAP table found");
        } else {
            this.id = currentFontFile.getNextUint16();
            this.subtableCount = currentFontFile.getNextUint16();
            this.CMAPsubtables = new int[this.subtableCount];
            this.platformID = new int[this.subtableCount];
            this.encodingID = new int[this.subtableCount];
            this.CMAPformats = new int[this.subtableCount];
            this.CMAPsearchRange = new int[this.subtableCount];
            this.CMAPentrySelector = new int[this.subtableCount];
            this.CMAPrangeShift = new int[this.subtableCount];
            this.CMAPreserved = new int[this.subtableCount];
            this.CMAPsegCount = new int[this.subtableCount];
            this.CMAPlength = new int[this.subtableCount];
            this.CMAPlang = new int[this.subtableCount];
            this.glyphIndexToChar = new int[this.subtableCount][256];
            for (int i = 0; i < this.subtableCount; ++i) {
                this.platformID[i] = currentFontFile.getNextUint16();
                this.encodingID[i] = currentFontFile.getNextUint16();
                this.CMAPsubtables[i] = currentFontFile.getNextUint32();
            }
            for (int j = 0; j < this.subtableCount; ++j) {
                currentFontFile.selectTable(2);
                currentFontFile.skip(this.CMAPsubtables[j]);
                this.CMAPformats[j] = currentFontFile.getNextUint16();
                boolean valid = true;
                if (this.CMAPformats[j] == 0) {
                    this.table = new Format0(this.glyphIndexToChar);
                    valid = this.table.readTable(currentFontFile, j, this.CMAPlength, this.CMAPlang);
                } else if (this.CMAPformats[j] == 2) {
                    this.table = new Format2();
                    this.table.readTable(currentFontFile, j, this.CMAPlength, this.CMAPlang);
                } else if (this.CMAPformats[j] == 4) {
                    this.readFormat4Table(currentFontFile, j);
                } else if (this.CMAPformats[j] == 6) {
                    this.readFormat6Table(currentFontFile, j);
                } else if (this.CMAPformats[j] == 12) {
                    this.table = new Format12();
                    this.table.readTable(currentFontFile, j, this.CMAPlength, this.CMAPlang);
                } else {
                    valid = false;
                }
                if (valid) continue;
                this.CMAPformats[j] = -1;
            }
        }
    }

    private void readFormat4Table(FontFile2 currentFontFile, int subtableID) {
        int i;
        this.CMAPlength[subtableID] = currentFontFile.getNextUint16();
        this.CMAPlang[subtableID] = currentFontFile.getNextUint16();
        this.CMAPsegCount[subtableID] = currentFontFile.getNextUint16();
        this.segCount = this.CMAPsegCount[subtableID] / 2;
        this.CMAPsearchRange[subtableID] = currentFontFile.getNextUint16();
        this.CMAPentrySelector[subtableID] = currentFontFile.getNextUint16();
        this.CMAPrangeShift[subtableID] = currentFontFile.getNextUint16();
        if (this.hasFormat4) {
            if (this.CMAPlength[this.lastFormat4Found] > this.CMAPlength[subtableID]) {
                this.CMAPlength[subtableID] = this.CMAPlength[this.lastFormat4Found];
                this.CMAPsegCount[subtableID] = this.CMAPsegCount[this.lastFormat4Found];
                this.CMAPsearchRange[subtableID] = this.CMAPsearchRange[this.lastFormat4Found];
                this.CMAPentrySelector[subtableID] = this.CMAPentrySelector[this.lastFormat4Found];
                this.CMAPrangeShift[subtableID] = this.CMAPrangeShift[this.lastFormat4Found];
                return;
            }
            if (this.CMAPlength[this.lastFormat4Found] < this.CMAPlength[subtableID]) {
                this.CMAPlength[this.lastFormat4Found] = this.CMAPlength[subtableID];
                this.CMAPsegCount[this.lastFormat4Found] = this.CMAPsegCount[subtableID];
                this.CMAPsearchRange[this.lastFormat4Found] = this.CMAPsearchRange[subtableID];
                this.CMAPentrySelector[this.lastFormat4Found] = this.CMAPentrySelector[subtableID];
                this.CMAPrangeShift[this.lastFormat4Found] = this.CMAPrangeShift[subtableID];
            }
        }
        this.lastFormat4Found = subtableID;
        this.hasFormat4 = true;
        this.endCode = new int[this.segCount];
        for (i = 0; i < this.segCount; ++i) {
            this.endCode[i] = currentFontFile.getNextUint16();
        }
        this.CMAPreserved[subtableID] = currentFontFile.getNextUint16();
        this.startCode = new int[this.segCount];
        for (i = 0; i < this.segCount; ++i) {
            this.startCode[i] = currentFontFile.getNextUint16();
        }
        this.idDelta = new int[this.segCount];
        for (i = 0; i < this.segCount; ++i) {
            this.idDelta[i] = currentFontFile.getNextUint16();
        }
        this.idRangeOffset = new int[this.segCount];
        for (i = 0; i < this.segCount; ++i) {
            this.idRangeOffset[i] = currentFontFile.getNextUint16();
        }
        int count = (this.CMAPlength[subtableID] - 16 - this.segCount * 8) / 2;
        this.glyphIdArray = new int[count];
        for (int i2 = 0; i2 < count; ++i2) {
            this.glyphIdArray[i2] = currentFontFile.getNextUint16();
        }
    }

    private void readFormat6Table(FontFile2 currentFontFile, int subtableID) {
        this.hasFormat6 = true;
        this.CMAPlength[subtableID] = currentFontFile.getNextUint16();
        this.CMAPlang[subtableID] = currentFontFile.getNextUint16();
        this.firstCode = currentFontFile.getNextUint16();
        this.entryCount = currentFontFile.getNextUint16();
        this.f6glyphIdArray = new int[this.firstCode + this.entryCount];
        for (int jj = 0; jj < this.entryCount; ++jj) {
            this.f6glyphIdArray[jj + this.firstCode] = currentFontFile.getNextUint16();
        }
    }

    protected CMAP() {
    }

    int convertIndexToCharacterCode(String glyph, int index) {
        int rawIndex = index;
        int format = this.CMAPformats[this.subtableToUse];
        if (this.remapEncoding) {
            if (glyph != null && !"notdef".equals(glyph)) {
                index = StandardFonts.getAdobeMap(glyph);
            } else if (exceptions.containsKey(glyph)) {
                index = exceptions.get(glyph);
            }
        }
        int value = -1;
        if (rawIndex == 128 && this.endCode != null && "Euro".equals(glyph)) {
            value = this.getFormat4Value(8364, value);
        } else if (format == 0) {
            int format4Value;
            if (index > 255) {
                index = 0;
            }
            if ((value = this.glyphIndexToChar[this.subtableToUse][index]) == 0 && rawIndex != -1) {
                value = this.glyphIndexToChar[this.subtableToUse][rawIndex];
            }
            if (value == 0 && (format4Value = this.getFormat4Value(index, 0)) > 0) {
                value = format4Value;
            }
        } else if (format == 4) {
            if ((value = this.getFormat4Value(index, value)) == -1) {
                value = index > 61440 ? this.getFormat4Value(index - 61440, value) : this.getFormat4Value(index + 61440, value);
            }
            if (value == -1) {
                value = this.getFormat4Value(rawIndex + 61440, value);
            }
        } else if (this.table != null) {
            value = this.table.getValue(index, value);
        }
        if (value == -1 && this.hasFormat6) {
            index = rawIndex;
            format = 6;
        }
        if (format == 6) {
            if (this.fontEncoding != 1) {
                index = StandardFonts.lookupCharacterIndex(glyph, 0);
            }
            value = index >= this.f6glyphIdArray.length ? 0 : this.f6glyphIdArray[index];
        }
        return value;
    }

    private int getFormat4Value(int index, int value) {
        for (int i = 0; i < this.segCount; ++i) {
            if (this.endCode[i] < index || this.startCode[i] > index) continue;
            if (this.idRangeOffset[i] == 0) {
                value = (this.idDelta[i] + index) % 65536;
            } else {
                int rangesRemaining = this.idRangeOffset.length - i;
                int idx = this.idRangeOffset[i] / 2 + (index - this.startCode[i]) - rangesRemaining;
                if (idx < this.glyphIdArray.length) {
                    value = this.glyphIdArray[idx];
                    if (value != 0) {
                        value = (this.idDelta[i] + value) % 65536;
                    }
                } else {
                    value = 0;
                }
            }
            i = this.segCount;
        }
        return value;
    }

    public void setEncodingToUse(boolean hasEncoding, int fontEncoding) {
        this.fontEncoding = fontEncoding;
        this.subtableToUse = -1;
        int count = this.platformID.length;
        for (int i = 0; i < count; ++i) {
            boolean format4MissingValues;
            if (!hasEncoding || fontEncoding != 2 || this.platformID[i] != 1 || this.encodingID[i] != 0 || this.CMAPformats[i] != 0) continue;
            boolean bl = format4MissingValues = this.glyphIndexToChar[i][223] == 0 || this.getFormat4Value(223, 0) != 0;
            if (format4MissingValues) break;
            this.subtableToUse = i;
            this.checkforRemapping(true, 2, count);
            break;
        }
        if (this.subtableToUse == -1) {
            int[] formats;
            block1: for (int format : formats = new int[]{1, 4, 0, 2, 6, 12}) {
                if (this.subtableToUse != -1) continue;
                for (int i = 0; i < count; ++i) {
                    if (this.CMAPformats[i] != format) continue;
                    this.subtableToUse = i;
                    if (format != 4 && format != 0) continue block1;
                    this.checkforRemapping(hasEncoding, fontEncoding, count);
                    continue block1;
                }
            }
        }
    }

    private void checkforRemapping(boolean hasEncoding, int fontEncoding, int count) {
        int encoding = this.encodingID[this.subtableToUse];
        int platform = this.platformID[this.subtableToUse];
        this.remapEncoding = encoding == 3 && platform == 0 && count > 1 && (hasEncoding || fontEncoding == 1) ? true : (encoding == 0 && platform == 0 && hasEncoding && fontEncoding == 2 ? true : (encoding == 1 && platform == 3 && hasEncoding && (fontEncoding == 2 || fontEncoding == 0) ? true : (encoding == 0 && platform == 1 && fontEncoding != 0 ? true : !hasEncoding && fontEncoding != 1 && this.fontEncoding != 6)));
    }

    public boolean containsKey(Integer key) {
        if (this.glyfValues == null) {
            this.glyfValues = this.buildCharStringTable();
        }
        return this.glyfValues.containsKey(key);
    }

    public Map<Integer, Integer> buildCharStringTable() {
        HashMap<Integer, Integer> glyfValues;
        block5: {
            block4: {
                glyfValues = new HashMap<Integer, Integer>();
                if (!this.hasFormat4) break block4;
                ArrayList<Integer> list4 = new ArrayList<Integer>();
                for (int z = 0; z < this.segCount; ++z) {
                    int total = this.endCode[z] - this.startCode[z] + 1;
                    for (int q = 0; q < total; ++q) {
                        list4.add(this.startCode[z] + q);
                    }
                }
                for (Integer i : list4) {
                    glyfValues.put(i, this.getFormat4Value(i, 0));
                }
                break block5;
            }
            if (!this.hasFormat6) break block5;
            for (int z = 0; z < this.entryCount; ++z) {
                glyfValues.put(this.firstCode + z, this.f6glyphIdArray[this.firstCode + z]);
            }
        }
        return glyfValues;
    }

    static {
        String[] keys = new String[]{"notequal", "infinity", "lessequal", "greaterequal", "partialdiff", "summation", "product", "pi", "integral", "Omega", "radical", "approxequal", "Delta", "lozenge", "Euro", "apple"};
        int[] values = new int[]{173, 176, 178, 179, 182, 183, 184, 185, 186, 189, 195, 197, 198, 215, 219, 240};
        for (int i = 0; i < values.length; ++i) {
            exceptions.put(keys[i], values[i]);
        }
        StandardFonts.checkLoaded(2);
    }
}

